/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork;

import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.WanDhcpOptionOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.WanMultipleIpOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.Ipv4DhcpVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;
import org.springframework.util.CollectionUtils;

@KeepClass
public class Ipv4DhcpOpenApiVO {
    @Schema(name="unicastDhcp", description="Unicast DHCP")
    private Boolean unicastDhcp;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DNS Server.")
    @Schema(name="primaryDns", description="Primary DNS")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DNS Server.") String primaryDns;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DNS Server.")
    @Schema(name="secondaryDns", description="Secondary DNS")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DNS Server.") String secondaryDns;
    @Pattern(regexp="^[a-zA-Z0-9_]{0,63}$", message="Enter the host name with up to 63 characters using numbers, letters, and underscores only.")
    @Schema(name="hostname", description="Host name")
    private @Pattern(regexp="^[a-zA-Z0-9_]{0,63}$", message="Enter the host name with up to 63 characters using numbers, letters, and underscores only.") String hostname;
    @Range(min=576L, max=1500L, message="MTU parameter [mtu] should between 576 and 1500.")
    @NotNull(message="Parameter [mtu] should not be null.")
    @Schema(name="mtu", description="576-1500, default:1500.")
    private @Range(min=576L, max=1500L, message="MTU parameter [mtu] should between 576 and 1500.") @NotNull(message="Parameter [mtu] should not be null.") Integer mtu;
    @Valid
    @Schema(name="wanMultipleIps")
    private List<WanMultipleIpOpenApiVO> wanMultipleIps;
    @Schema(name="dhcpOptions")
    private List<WanDhcpOptionOpenApiVO> dhcpOptions;

    public static Ipv4DhcpOpenApiVO buildFromWebVO(Ipv4DhcpVO vo) {
        Ipv4DhcpOpenApiVO res = new Ipv4DhcpOpenApiVO();
        if (vo == null) {
            return res;
        }
        res.setUnicastDhcp("on".equals(vo.getUnicast()));
        res.setPrimaryDns(vo.getDns1());
        res.setSecondaryDns(vo.getDns2());
        res.setHostname(vo.getHostname());
        res.setMtu(vo.getMtu());
        res.setWanMultipleIps(CollectionUtils.isEmpty((Collection)vo.getWanMultipleIps()) ? new ArrayList<WanMultipleIpOpenApiVO>() : vo.getWanMultipleIps().stream().map(WanMultipleIpOpenApiVO::buildFromWebVO).collect(Collectors.toList()));
        res.setDhcpOptions(CollectionUtils.isEmpty((Collection)vo.getDhcpOptions()) ? new ArrayList<WanDhcpOptionOpenApiVO>() : vo.getDhcpOptions().stream().map(WanDhcpOptionOpenApiVO::buildFromWebVO).collect(Collectors.toList()));
        return res;
    }

    public static Ipv4DhcpVO toWebVO(Ipv4DhcpOpenApiVO vo) {
        Ipv4DhcpVO res = new Ipv4DhcpVO();
        if (vo == null) {
            return res;
        }
        res.setUnicast(Boolean.TRUE.equals(vo.getUnicastDhcp()) ? "on" : "off");
        res.setDns1(vo.getPrimaryDns());
        res.setDns2(vo.getSecondaryDns());
        res.setHostname(vo.getHostname());
        res.setMtu(vo.getMtu());
        res.setWanMultipleIps(CollectionUtils.isEmpty(vo.getWanMultipleIps()) ? new ArrayList() : vo.getWanMultipleIps().stream().map(WanMultipleIpOpenApiVO::toWebVO).collect(Collectors.toList()));
        res.setDhcpOptions(CollectionUtils.isEmpty(vo.getDhcpOptions()) ? new ArrayList() : vo.getDhcpOptions().stream().map(WanDhcpOptionOpenApiVO::toWebVO).collect(Collectors.toList()));
        return res;
    }

    @Generated
    public Boolean getUnicastDhcp() {
        return this.unicastDhcp;
    }

    @Generated
    public String getPrimaryDns() {
        return this.primaryDns;
    }

    @Generated
    public String getSecondaryDns() {
        return this.secondaryDns;
    }

    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Generated
    public Integer getMtu() {
        return this.mtu;
    }

    @Generated
    public List<WanMultipleIpOpenApiVO> getWanMultipleIps() {
        return this.wanMultipleIps;
    }

    @Generated
    public List<WanDhcpOptionOpenApiVO> getDhcpOptions() {
        return this.dhcpOptions;
    }

    @Generated
    public Ipv4DhcpOpenApiVO setUnicastDhcp(Boolean unicastDhcp) {
        this.unicastDhcp = unicastDhcp;
        return this;
    }

    @Generated
    public Ipv4DhcpOpenApiVO setPrimaryDns(String primaryDns) {
        this.primaryDns = primaryDns;
        return this;
    }

    @Generated
    public Ipv4DhcpOpenApiVO setSecondaryDns(String secondaryDns) {
        this.secondaryDns = secondaryDns;
        return this;
    }

    @Generated
    public Ipv4DhcpOpenApiVO setHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    @Generated
    public Ipv4DhcpOpenApiVO setMtu(Integer mtu) {
        this.mtu = mtu;
        return this;
    }

    @Generated
    public Ipv4DhcpOpenApiVO setWanMultipleIps(List<WanMultipleIpOpenApiVO> wanMultipleIps) {
        this.wanMultipleIps = wanMultipleIps;
        return this;
    }

    @Generated
    public Ipv4DhcpOpenApiVO setDhcpOptions(List<WanDhcpOptionOpenApiVO> dhcpOptions) {
        this.dhcpOptions = dhcpOptions;
        return this;
    }

    @Generated
    public String toString() {
        return "Ipv4DhcpOpenApiVO(unicastDhcp=" + this.getUnicastDhcp() + ", primaryDns=" + this.getPrimaryDns() + ", secondaryDns=" + this.getSecondaryDns() + ", hostname=" + this.getHostname() + ", mtu=" + this.getMtu() + ", wanMultipleIps=" + this.getWanMultipleIps() + ", dhcpOptions=" + this.getDhcpOptions() + ")";
    }
}

