/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork;

import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.f;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.Ipv4Connection2VO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;

@KeepClass
public class Ipv4Connection2OpenApiVO {
    @Schema(name="secondaryProtoType", description="It should be a value as follows: 0:Static IP; 1:Dynamic IP; 2: None(Only for PPPoE).")
    @NotNull(message="Parameter [secondaryProtoType] should not be null.")
    private @NotNull(message="Parameter [secondaryProtoType] should not be null.") Integer secondaryProtoType;
    @Pattern.List(value={@Pattern(regexp="(((?!^0\\.0\\.0\\.0$)(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6}))|(^[A-Za-z0-9\\_\\-]+\\.{1,})", message="Invalid VPN Server/Domain Name."), @Pattern(regexp="^[\\041-\\0176]{1,253}$", message="Invalid VPN Server/Domain Name.")})
    @Schema(name="server", description="(Optional) VPN Server/Domain Name. It is required for L2TP/PPTP.")
    private @Pattern.List(value={@Pattern(regexp="(((?!^0\\.0\\.0\\.0$)(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6}))|(^[A-Za-z0-9\\_\\-]+\\.{1,})", message="Invalid VPN Server/Domain Name."), @Pattern(regexp="^[\\041-\\0176]{1,253}$", message="Invalid VPN Server/Domain Name.")}) String server;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid IP address.")
    @Schema(name="ipAddress", description="(Optional) It is required when [secondaryProtoType] is 0.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid IP address.") String ipAddress;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid subnet mask.")
    @Schema(name="subnetMask", description="(Optional) It is required when [secondaryProtoType] is 0.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid subnet mask.") String subnetMask;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid gateway address.")
    @Schema(name="defaultGateway", description="(Optional) It is required when [secondaryProtoType] is 0.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid gateway address.") String defaultGateway;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DNS server.")
    @Schema(name="primaryDns", description="(Optional) It is required when [secondaryProtoType] is 0.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DNS server.") String primaryDns;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DNS server.")
    @Schema(name="secondaryDns", description="(Optional) It is required when [secondaryProtoType] is 0.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DNS server.") String secondaryDns;

    public static Ipv4Connection2OpenApiVO buildFromWebVO(Ipv4Connection2VO vo) {
        Ipv4Connection2OpenApiVO res = new Ipv4Connection2OpenApiVO();
        if (vo == null) {
            return res;
        }
        res.setSecondaryProtoType(f.a(vo.getProto()).b());
        res.setServer(vo.getServer());
        res.setIpAddress(vo.getIpaddr());
        res.setSubnetMask(vo.getNetmask());
        res.setDefaultGateway(vo.getGateway());
        res.setPrimaryDns(vo.getDns1());
        res.setSecondaryDns(vo.getDns2());
        return res;
    }

    public static Ipv4Connection2VO toWebVO(Ipv4Connection2OpenApiVO vo, String mainProto) {
        Ipv4Connection2VO res = new Ipv4Connection2VO();
        if (vo == null) {
            return res;
        }
        res.setMainProto(mainProto);
        res.setProto(f.a(vo.getSecondaryProtoType()).a());
        res.setServer(vo.getServer());
        res.setIpaddr(vo.getIpAddress());
        res.setNetmask(vo.getSubnetMask());
        res.setGateway(vo.getDefaultGateway());
        res.setDns1(vo.getPrimaryDns());
        res.setDns2(vo.getSecondaryDns());
        return res;
    }

    @Generated
    public Integer getSecondaryProtoType() {
        return this.secondaryProtoType;
    }

    @Generated
    public String getServer() {
        return this.server;
    }

    @Generated
    public String getIpAddress() {
        return this.ipAddress;
    }

    @Generated
    public String getSubnetMask() {
        return this.subnetMask;
    }

    @Generated
    public String getDefaultGateway() {
        return this.defaultGateway;
    }

    @Generated
    public String getPrimaryDns() {
        return this.primaryDns;
    }

    @Generated
    public String getSecondaryDns() {
        return this.secondaryDns;
    }

    @Generated
    public Ipv4Connection2OpenApiVO setSecondaryProtoType(Integer secondaryProtoType) {
        this.secondaryProtoType = secondaryProtoType;
        return this;
    }

    @Generated
    public Ipv4Connection2OpenApiVO setServer(String server) {
        this.server = server;
        return this;
    }

    @Generated
    public Ipv4Connection2OpenApiVO setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    @Generated
    public Ipv4Connection2OpenApiVO setSubnetMask(String subnetMask) {
        this.subnetMask = subnetMask;
        return this;
    }

    @Generated
    public Ipv4Connection2OpenApiVO setDefaultGateway(String defaultGateway) {
        this.defaultGateway = defaultGateway;
        return this;
    }

    @Generated
    public Ipv4Connection2OpenApiVO setPrimaryDns(String primaryDns) {
        this.primaryDns = primaryDns;
        return this;
    }

    @Generated
    public Ipv4Connection2OpenApiVO setSecondaryDns(String secondaryDns) {
        this.secondaryDns = secondaryDns;
        return this;
    }

    @Generated
    public String toString() {
        return "Ipv4Connection2OpenApiVO(secondaryProtoType=" + this.getSecondaryProtoType() + ", server=" + this.getServer() + ", ipAddress=" + this.getIpAddress() + ", subnetMask=" + this.getSubnetMask() + ", defaultGateway=" + this.getDefaultGateway() + ", primaryDns=" + this.getPrimaryDns() + ", secondaryDns=" + this.getSecondaryDns() + ")";
    }
}

