/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork;

import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.LteWanPortSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.OsgPortInfoOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.UsbLteSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.WanLoadBalanceOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.WanPortSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.InternetVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;

public class InternetOpenApiVO {
    @Schema(name="omadacId", description="Omadac ID.")
    private String omadacId;
    @Schema(name="siteId", description="Site ID.")
    @NotNull(message="siteId parameter [siteId] should not be null.")
    private @NotNull(message="siteId parameter [siteId] should not be null.") String siteId;
    @Schema(name="enable", description="Is Internet enable.")
    private Boolean enable;
    @Schema(name="osgPortInfo", description="Gateway port info.")
    private OsgPortInfoOpenApiVO osgPortInfo;
    @Schema(name="portUuids", description="The list of wan port UUID.")
    private List<String> portUuids;
    @Schema(name="interval", description="Time taken to check the connection of wan port.")
    private Integer interval;
    @Schema(name="unit", description="Unit.")
    private Integer unit;
    @Schema(name="supportCustomInterval", description="Whether the device supports Custom Interval.")
    private Boolean supportCustomInterval;
    @Schema(name="supportDiscreteWan", description="Whether the device supports Discrete Wan.")
    private Boolean supportDiscreteWan;
    @Schema(name="supportReduceUsbRfi", description="Whether the device supports Reduce USB 3.0 Interference Reduction.")
    private Boolean supportReduceUsbRfi;
    @Schema(name="supportAllWan", description="Whether the device supports all wan.")
    private Boolean supportAllWan;
    @Schema(name="supportMaxWanNum", description="The maximum number of wans supported.")
    private Integer supportMaxWanNum;
    @Schema(name="supportIpv6NonAddress", description="Whether the IPv6 configuration supports Non-Address.")
    private Boolean supportIpv6NonAddress;
    @Schema(name="supportMssClamping", description="Whether MSS clamping is supported for PPPoE, L2TP, and PPTP.")
    private Boolean supportMssClamping;
    @Schema(name="supportPppoeMru", description="Whether to configure PPPoE MRUs.")
    private Boolean supportPppoeMru;
    @Schema(name="supportWanMultipleIp", description="Whether to configure multiple IP addresses for wan ports.")
    private Boolean supportWanMultipleIp;
    @Schema(name="supportLte", description="Whether to configure LTE Wan.")
    private Boolean supportLte;
    @Schema(name="supportDualSim", description="Whether it supports dual SIM single standby: 0: not support, 1: support.")
    private Integer supportDualSim;
    @Schema(name="supportDsl", description="Whether it supports DSL.")
    private Boolean supportDsl;
    @Schema(name="supportVirtualWan", description="Whether it supports virtual wan.")
    private Boolean supportVirtualWan;
    @Schema(name="supportNetworkIsolation", description="Whether it supports isolate network.")
    private Boolean supportNetworkIsolation;
    @Schema(name="supportDhcpOptions", description="Whether WAN port dhcpOptions can be customized.")
    private Boolean supportDhcpOptions;
    @Schema(name="supportUsbDhcpOptions", description="Whether USB port dhcpOptions can be customized.")
    private Boolean supportUsbDhcpOptions;
    @Schema(name="wanPortSettings", description="A list of wan port setting.")
    @Valid
    private List<WanPortSettingOpenApiVO> wanPortSettings;
    @Schema(name="usbLteSettings", description="A list of USB LTE setting.")
    private List<UsbLteSettingOpenApiVO> usbLteSettings;
    @Schema(name="lteWanSettings", description="A list of LTE wan setting.")
    @Valid
    private List<LteWanPortSettingOpenApiVO> lteWanSettings;
    @Schema(name="wanLoadBalance", description="Load balancing configuration for multi-WAN interfaces.")
    @Valid
    private WanLoadBalanceOpenApiVO wanLoadBalance;
    @Schema(name="networkNames", description="A list of the name of the LanNetwork entry that was invalidated on the frontend.")
    private List<String> networkNames;
    @Schema(name="unmatchedWans", description="A list of the name of the WAN port that was invalidated on the frontend.")
    private List<String> unmatchedWans;
    @Schema(name="gatewayMac", description="Gateway MAC.")
    @a
    private String gatewayMac;
    @Schema(name="enableModified", description="Whether it enable modified.")
    private Boolean enableModified;
    @Schema(name="lteIntervalTips", description="Whether to display the interval prompt for LTE ports.")
    private Boolean lteIntervalTips;
    @Schema(name="resource", description="Resource of data.")
    private Integer resource;

    public static InternetVO toVO(InternetOpenApiVO internetOpenApiVO) {
        InternetVO internetVO = new InternetVO();
        if (Objects.isNull(internetOpenApiVO)) {
            return internetVO;
        }
        internetVO.setOmadacId(internetOpenApiVO.getOmadacId());
        internetVO.setSiteId(internetOpenApiVO.getSiteId());
        internetVO.setEnable(internetOpenApiVO.getEnable());
        internetVO.setOsgPortInfo(OsgPortInfoOpenApiVO.toWebVO(internetOpenApiVO.getOsgPortInfo()));
        internetVO.setPortUuids(internetOpenApiVO.getPortUuids());
        internetVO.setInterval(internetOpenApiVO.getInterval());
        internetVO.setUnit(internetOpenApiVO.getUnit());
        internetVO.setSupportCustomInterval(internetOpenApiVO.getSupportCustomInterval());
        internetVO.setSupportDiscreteWan(internetOpenApiVO.getSupportDiscreteWan());
        internetVO.setSupportReduceUsbRfi(internetOpenApiVO.getSupportReduceUsbRfi());
        internetVO.setSupportAllWan(internetOpenApiVO.getSupportAllWan());
        internetVO.setSupportMaxWanNum(internetOpenApiVO.getSupportMaxWanNum());
        internetVO.setSupportIpv6NonAddress(internetOpenApiVO.getSupportIpv6NonAddress());
        internetVO.setSupportMssClamping(internetOpenApiVO.getSupportMssClamping());
        internetVO.setSupportPppoeMru(internetOpenApiVO.getSupportPppoeMru());
        internetVO.setSupportWanMultipleIp(internetOpenApiVO.getSupportWanMultipleIp());
        internetVO.setSupportLte(internetOpenApiVO.getSupportLte());
        internetVO.setSupportDualSim(internetOpenApiVO.getSupportDualSim());
        internetVO.setSupportDsl(internetOpenApiVO.getSupportDsl());
        internetVO.setSupportVirtualWan(internetOpenApiVO.getSupportVirtualWan());
        internetVO.setSupportNetworkIsolation(internetOpenApiVO.getSupportNetworkIsolation());
        internetVO.setSupportDhcpOptions(internetOpenApiVO.getSupportDhcpOptions());
        internetVO.setSupportUsbDhcpOptions(internetOpenApiVO.getSupportUsbDhcpOptions());
        internetVO.setWanPortSettings(CollectionUtils.isEmpty(internetOpenApiVO.getWanPortSettings()) ? new ArrayList() : internetOpenApiVO.getWanPortSettings().stream().map(WanPortSettingOpenApiVO::toWebVO).toList());
        internetVO.setUsbLteSettings(CollectionUtils.isEmpty(internetOpenApiVO.getUsbLteSettings()) ? new ArrayList() : internetOpenApiVO.getUsbLteSettings().stream().map(UsbLteSettingOpenApiVO::toVO).toList());
        internetVO.setLteWanSettings(CollectionUtils.isEmpty(internetOpenApiVO.getLteWanSettings()) ? new ArrayList() : internetOpenApiVO.getLteWanSettings().stream().map(LteWanPortSettingOpenApiVO::toWebVO).toList());
        internetVO.setWanLoadBalance(WanLoadBalanceOpenApiVO.toWebVO(internetOpenApiVO.getWanLoadBalance()));
        internetVO.setNetworkNames(internetOpenApiVO.getNetworkNames());
        internetVO.setUnmatchedWans(internetOpenApiVO.getUnmatchedWans());
        internetVO.setGatewayMac(internetOpenApiVO.getGatewayMac());
        internetVO.setEnableModified(internetOpenApiVO.getEnableModified());
        internetVO.setLteIntervalTips(internetOpenApiVO.getLteIntervalTips());
        internetVO.setResource(internetOpenApiVO.getResource());
        return internetVO;
    }

    public static InternetOpenApiVO buildFromWebVO(InternetVO webVO) {
        if (Objects.isNull(webVO)) {
            return new InternetOpenApiVO();
        }
        InternetOpenApiVO internetOpenApiVO = new InternetOpenApiVO();
        internetOpenApiVO.setOmadacId(webVO.getOmadacId());
        internetOpenApiVO.setSiteId(webVO.getSiteId());
        internetOpenApiVO.setEnable(webVO.getEnable());
        internetOpenApiVO.setOsgPortInfo(OsgPortInfoOpenApiVO.buildFromWebVO(webVO.getOsgPortInfo()));
        internetOpenApiVO.setPortUuids(webVO.getPortUuids());
        internetOpenApiVO.setInterval(webVO.getInterval());
        internetOpenApiVO.setUnit(webVO.getUnit());
        internetOpenApiVO.setSupportCustomInterval(webVO.getSupportCustomInterval());
        internetOpenApiVO.setSupportDiscreteWan(webVO.getSupportDiscreteWan());
        internetOpenApiVO.setSupportReduceUsbRfi(webVO.getSupportReduceUsbRfi());
        internetOpenApiVO.setSupportAllWan(webVO.getSupportAllWan());
        internetOpenApiVO.setSupportMaxWanNum(webVO.getSupportMaxWanNum());
        internetOpenApiVO.setSupportIpv6NonAddress(webVO.getSupportIpv6NonAddress());
        internetOpenApiVO.setSupportMssClamping(webVO.getSupportMssClamping());
        internetOpenApiVO.setSupportPppoeMru(webVO.getSupportPppoeMru());
        internetOpenApiVO.setSupportWanMultipleIp(webVO.getSupportWanMultipleIp());
        internetOpenApiVO.setSupportLte(webVO.getSupportLte());
        internetOpenApiVO.setSupportDualSim(webVO.getSupportDualSim());
        internetOpenApiVO.setSupportDsl(webVO.getSupportDsl());
        internetOpenApiVO.setSupportVirtualWan(webVO.getSupportVirtualWan());
        internetOpenApiVO.setSupportNetworkIsolation(webVO.getSupportNetworkIsolation());
        internetOpenApiVO.setSupportDhcpOptions(webVO.getSupportDhcpOptions());
        internetOpenApiVO.setSupportUsbDhcpOptions(webVO.getSupportUsbDhcpOptions());
        internetOpenApiVO.setWanPortSettings(CollectionUtils.isEmpty((Collection)webVO.getWanPortSettings()) ? new ArrayList<WanPortSettingOpenApiVO>() : webVO.getWanPortSettings().stream().map(WanPortSettingOpenApiVO::buildFromWebVO).toList());
        internetOpenApiVO.setLteWanSettings(CollectionUtils.isEmpty((Collection)webVO.getLteWanSettings()) ? new ArrayList<LteWanPortSettingOpenApiVO>() : webVO.getLteWanSettings().stream().map(LteWanPortSettingOpenApiVO::fromWebVO).toList());
        internetOpenApiVO.setUsbLteSettings(CollectionUtils.isEmpty((Collection)webVO.getUsbLteSettings()) ? new ArrayList<UsbLteSettingOpenApiVO>() : webVO.getUsbLteSettings().stream().map(UsbLteSettingOpenApiVO::buildFromWebVO).toList());
        internetOpenApiVO.setWanLoadBalance(WanLoadBalanceOpenApiVO.buildFromWebVO(webVO.getWanLoadBalance()));
        internetOpenApiVO.setNetworkNames(webVO.getNetworkNames());
        internetOpenApiVO.setUnmatchedWans(webVO.getUnmatchedWans());
        internetOpenApiVO.setGatewayMac(webVO.getGatewayMac());
        internetOpenApiVO.setEnableModified(webVO.getEnableModified());
        internetOpenApiVO.setLteIntervalTips(webVO.getLteIntervalTips());
        internetOpenApiVO.setResource(webVO.getResource());
        return internetOpenApiVO;
    }

    @Generated
    public String getOmadacId() {
        return this.omadacId;
    }

    @Generated
    public String getSiteId() {
        return this.siteId;
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public OsgPortInfoOpenApiVO getOsgPortInfo() {
        return this.osgPortInfo;
    }

    @Generated
    public List<String> getPortUuids() {
        return this.portUuids;
    }

    @Generated
    public Integer getInterval() {
        return this.interval;
    }

    @Generated
    public Integer getUnit() {
        return this.unit;
    }

    @Generated
    public Boolean getSupportCustomInterval() {
        return this.supportCustomInterval;
    }

    @Generated
    public Boolean getSupportDiscreteWan() {
        return this.supportDiscreteWan;
    }

    @Generated
    public Boolean getSupportReduceUsbRfi() {
        return this.supportReduceUsbRfi;
    }

    @Generated
    public Boolean getSupportAllWan() {
        return this.supportAllWan;
    }

    @Generated
    public Integer getSupportMaxWanNum() {
        return this.supportMaxWanNum;
    }

    @Generated
    public Boolean getSupportIpv6NonAddress() {
        return this.supportIpv6NonAddress;
    }

    @Generated
    public Boolean getSupportMssClamping() {
        return this.supportMssClamping;
    }

    @Generated
    public Boolean getSupportPppoeMru() {
        return this.supportPppoeMru;
    }

    @Generated
    public Boolean getSupportWanMultipleIp() {
        return this.supportWanMultipleIp;
    }

    @Generated
    public Boolean getSupportLte() {
        return this.supportLte;
    }

    @Generated
    public Integer getSupportDualSim() {
        return this.supportDualSim;
    }

    @Generated
    public Boolean getSupportDsl() {
        return this.supportDsl;
    }

    @Generated
    public Boolean getSupportVirtualWan() {
        return this.supportVirtualWan;
    }

    @Generated
    public Boolean getSupportNetworkIsolation() {
        return this.supportNetworkIsolation;
    }

    @Generated
    public Boolean getSupportDhcpOptions() {
        return this.supportDhcpOptions;
    }

    @Generated
    public Boolean getSupportUsbDhcpOptions() {
        return this.supportUsbDhcpOptions;
    }

    @Generated
    public List<WanPortSettingOpenApiVO> getWanPortSettings() {
        return this.wanPortSettings;
    }

    @Generated
    public List<UsbLteSettingOpenApiVO> getUsbLteSettings() {
        return this.usbLteSettings;
    }

    @Generated
    public List<LteWanPortSettingOpenApiVO> getLteWanSettings() {
        return this.lteWanSettings;
    }

    @Generated
    public WanLoadBalanceOpenApiVO getWanLoadBalance() {
        return this.wanLoadBalance;
    }

    @Generated
    public List<String> getNetworkNames() {
        return this.networkNames;
    }

    @Generated
    public List<String> getUnmatchedWans() {
        return this.unmatchedWans;
    }

    @Generated
    public String getGatewayMac() {
        return this.gatewayMac;
    }

    @Generated
    public Boolean getEnableModified() {
        return this.enableModified;
    }

    @Generated
    public Boolean getLteIntervalTips() {
        return this.lteIntervalTips;
    }

    @Generated
    public Integer getResource() {
        return this.resource;
    }

    @Generated
    public void setOmadacId(String omadacId) {
        this.omadacId = omadacId;
    }

    @Generated
    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    @Generated
    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    @Generated
    public void setOsgPortInfo(OsgPortInfoOpenApiVO osgPortInfo) {
        this.osgPortInfo = osgPortInfo;
    }

    @Generated
    public void setPortUuids(List<String> portUuids) {
        this.portUuids = portUuids;
    }

    @Generated
    public void setInterval(Integer interval) {
        this.interval = interval;
    }

    @Generated
    public void setUnit(Integer unit) {
        this.unit = unit;
    }

    @Generated
    public void setSupportCustomInterval(Boolean supportCustomInterval) {
        this.supportCustomInterval = supportCustomInterval;
    }

    @Generated
    public void setSupportDiscreteWan(Boolean supportDiscreteWan) {
        this.supportDiscreteWan = supportDiscreteWan;
    }

    @Generated
    public void setSupportReduceUsbRfi(Boolean supportReduceUsbRfi) {
        this.supportReduceUsbRfi = supportReduceUsbRfi;
    }

    @Generated
    public void setSupportAllWan(Boolean supportAllWan) {
        this.supportAllWan = supportAllWan;
    }

    @Generated
    public void setSupportMaxWanNum(Integer supportMaxWanNum) {
        this.supportMaxWanNum = supportMaxWanNum;
    }

    @Generated
    public void setSupportIpv6NonAddress(Boolean supportIpv6NonAddress) {
        this.supportIpv6NonAddress = supportIpv6NonAddress;
    }

    @Generated
    public void setSupportMssClamping(Boolean supportMssClamping) {
        this.supportMssClamping = supportMssClamping;
    }

    @Generated
    public void setSupportPppoeMru(Boolean supportPppoeMru) {
        this.supportPppoeMru = supportPppoeMru;
    }

    @Generated
    public void setSupportWanMultipleIp(Boolean supportWanMultipleIp) {
        this.supportWanMultipleIp = supportWanMultipleIp;
    }

    @Generated
    public void setSupportLte(Boolean supportLte) {
        this.supportLte = supportLte;
    }

    @Generated
    public void setSupportDualSim(Integer supportDualSim) {
        this.supportDualSim = supportDualSim;
    }

    @Generated
    public void setSupportDsl(Boolean supportDsl) {
        this.supportDsl = supportDsl;
    }

    @Generated
    public void setSupportVirtualWan(Boolean supportVirtualWan) {
        this.supportVirtualWan = supportVirtualWan;
    }

    @Generated
    public void setSupportNetworkIsolation(Boolean supportNetworkIsolation) {
        this.supportNetworkIsolation = supportNetworkIsolation;
    }

    @Generated
    public void setSupportDhcpOptions(Boolean supportDhcpOptions) {
        this.supportDhcpOptions = supportDhcpOptions;
    }

    @Generated
    public void setSupportUsbDhcpOptions(Boolean supportUsbDhcpOptions) {
        this.supportUsbDhcpOptions = supportUsbDhcpOptions;
    }

    @Generated
    public void setWanPortSettings(List<WanPortSettingOpenApiVO> wanPortSettings) {
        this.wanPortSettings = wanPortSettings;
    }

    @Generated
    public void setUsbLteSettings(List<UsbLteSettingOpenApiVO> usbLteSettings) {
        this.usbLteSettings = usbLteSettings;
    }

    @Generated
    public void setLteWanSettings(List<LteWanPortSettingOpenApiVO> lteWanSettings) {
        this.lteWanSettings = lteWanSettings;
    }

    @Generated
    public void setWanLoadBalance(WanLoadBalanceOpenApiVO wanLoadBalance) {
        this.wanLoadBalance = wanLoadBalance;
    }

    @Generated
    public void setNetworkNames(List<String> networkNames) {
        this.networkNames = networkNames;
    }

    @Generated
    public void setUnmatchedWans(List<String> unmatchedWans) {
        this.unmatchedWans = unmatchedWans;
    }

    @Generated
    public void setGatewayMac(String gatewayMac) {
        this.gatewayMac = gatewayMac;
    }

    @Generated
    public void setEnableModified(Boolean enableModified) {
        this.enableModified = enableModified;
    }

    @Generated
    public void setLteIntervalTips(Boolean lteIntervalTips) {
        this.lteIntervalTips = lteIntervalTips;
    }

    @Generated
    public void setResource(Integer resource) {
        this.resource = resource;
    }

    @Generated
    public String toString() {
        return "InternetOpenApiVO(omadacId=" + this.getOmadacId() + ", siteId=" + this.getSiteId() + ", enable=" + this.getEnable() + ", osgPortInfo=" + this.getOsgPortInfo() + ", portUuids=" + this.getPortUuids() + ", interval=" + this.getInterval() + ", unit=" + this.getUnit() + ", supportCustomInterval=" + this.getSupportCustomInterval() + ", supportDiscreteWan=" + this.getSupportDiscreteWan() + ", supportReduceUsbRfi=" + this.getSupportReduceUsbRfi() + ", supportAllWan=" + this.getSupportAllWan() + ", supportMaxWanNum=" + this.getSupportMaxWanNum() + ", supportIpv6NonAddress=" + this.getSupportIpv6NonAddress() + ", supportMssClamping=" + this.getSupportMssClamping() + ", supportPppoeMru=" + this.getSupportPppoeMru() + ", supportWanMultipleIp=" + this.getSupportWanMultipleIp() + ", supportLte=" + this.getSupportLte() + ", supportDualSim=" + this.getSupportDualSim() + ", supportDsl=" + this.getSupportDsl() + ", supportVirtualWan=" + this.getSupportVirtualWan() + ", supportNetworkIsolation=" + this.getSupportNetworkIsolation() + ", supportDhcpOptions=" + this.getSupportDhcpOptions() + ", supportUsbDhcpOptions=" + this.getSupportUsbDhcpOptions() + ", wanPortSettings=" + this.getWanPortSettings() + ", usbLteSettings=" + this.getUsbLteSettings() + ", lteWanSettings=" + this.getLteWanSettings() + ", wanLoadBalance=" + this.getWanLoadBalance() + ", networkNames=" + this.getNetworkNames() + ", unmatchedWans=" + this.getUnmatchedWans() + ", gatewayMac=" + this.getGatewayMac() + ", enableModified=" + this.getEnableModified() + ", lteIntervalTips=" + this.getLteIntervalTips() + ", resource=" + this.getResource() + ")";
    }

    @Generated
    public InternetOpenApiVO(String omadacId, String siteId, Boolean enable, OsgPortInfoOpenApiVO osgPortInfo, List<String> portUuids, Integer interval, Integer unit, Boolean supportCustomInterval, Boolean supportDiscreteWan, Boolean supportReduceUsbRfi, Boolean supportAllWan, Integer supportMaxWanNum, Boolean supportIpv6NonAddress, Boolean supportMssClamping, Boolean supportPppoeMru, Boolean supportWanMultipleIp, Boolean supportLte, Integer supportDualSim, Boolean supportDsl, Boolean supportVirtualWan, Boolean supportNetworkIsolation, Boolean supportDhcpOptions, Boolean supportUsbDhcpOptions, List<WanPortSettingOpenApiVO> wanPortSettings, List<UsbLteSettingOpenApiVO> usbLteSettings, List<LteWanPortSettingOpenApiVO> lteWanSettings, WanLoadBalanceOpenApiVO wanLoadBalance, List<String> networkNames, List<String> unmatchedWans, String gatewayMac, Boolean enableModified, Boolean lteIntervalTips, Integer resource) {
        this.omadacId = omadacId;
        this.siteId = siteId;
        this.enable = enable;
        this.osgPortInfo = osgPortInfo;
        this.portUuids = portUuids;
        this.interval = interval;
        this.unit = unit;
        this.supportCustomInterval = supportCustomInterval;
        this.supportDiscreteWan = supportDiscreteWan;
        this.supportReduceUsbRfi = supportReduceUsbRfi;
        this.supportAllWan = supportAllWan;
        this.supportMaxWanNum = supportMaxWanNum;
        this.supportIpv6NonAddress = supportIpv6NonAddress;
        this.supportMssClamping = supportMssClamping;
        this.supportPppoeMru = supportPppoeMru;
        this.supportWanMultipleIp = supportWanMultipleIp;
        this.supportLte = supportLte;
        this.supportDualSim = supportDualSim;
        this.supportDsl = supportDsl;
        this.supportVirtualWan = supportVirtualWan;
        this.supportNetworkIsolation = supportNetworkIsolation;
        this.supportDhcpOptions = supportDhcpOptions;
        this.supportUsbDhcpOptions = supportUsbDhcpOptions;
        this.wanPortSettings = wanPortSettings;
        this.usbLteSettings = usbLteSettings;
        this.lteWanSettings = lteWanSettings;
        this.wanLoadBalance = wanLoadBalance;
        this.networkNames = networkNames;
        this.unmatchedWans = unmatchedWans;
        this.gatewayMac = gatewayMac;
        this.enableModified = enableModified;
        this.lteIntervalTips = lteIntervalTips;
        this.resource = resource;
    }

    @Generated
    public InternetOpenApiVO() {
    }
}

