/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork;

import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.LteWanPortSettingOpenApiV2VO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.OsgPortInfoOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.UsbLteSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.WanLoadBalanceOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.WanPortSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.InternetVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;

public class InternetOpenApiV2VO {
    @Schema(name="omadacId", description="Omadac ID.")
    private String omadacId;
    @Schema(name="siteId", description="Site ID.")
    @NotNull(message="siteId parameter [siteId] should not be null.")
    private @NotNull(message="siteId parameter [siteId] should not be null.") String siteId;
    @Schema(name="realOsgModel", description="real gateway model")
    private String realOsgModel;
    @Schema(name="enable", description="Is Internet enable.")
    private Boolean enable;
    @Schema(name="osgPortInfo", description="Gateway port info.")
    private OsgPortInfoOpenApiVO osgPortInfo;
    @Schema(name="portUuids", description="The list of wan port UUID.")
    private List<String> portUuids;
    @Schema(name="interval", description="Time taken to check the connection of wan port.")
    private Integer interval;
    @Schema(name="unit", description="Unit.")
    private Integer unit;
    @Schema(name="supportCustomInterval", description="Whether the device supports Custom Interval.")
    private Boolean supportCustomInterval;
    @Schema(name="supportDiscreteWan", description="Whether the device supports Discrete Wan.")
    private Boolean supportDiscreteWan;
    @Schema(name="supportReduceUsbRfi", description="Whether the device supports Reduce USB 3.0 Interference Reduction.")
    private Boolean supportReduceUsbRfi;
    @Schema(name="supportAllWan", description="Whether the device supports all wan.")
    private Boolean supportAllWan;
    @Schema(name="supportMaxWanNum", description="The maximum number of wans supported.")
    private Integer supportMaxWanNum;
    @Schema(name="supportIpv6NonAddress", description="Whether the IPv6 configuration supports Non-Address.")
    private Boolean supportIpv6NonAddress;
    @Schema(name="supportMssClamping", description="Whether MSS clamping is supported for PPPoE, L2TP, and PPTP.")
    private Boolean supportMssClamping;
    @Schema(name="supportPppoeMru", description="Whether to configure PPPoE MRUs.")
    private Boolean supportPppoeMru;
    @Schema(name="supportWanMultipleIp", description="Whether to configure multiple IP addresses for wan ports.")
    private Boolean supportWanMultipleIp;
    @Schema(name="supportLte", description="Whether to configure LTE Wan.")
    private Boolean supportLte;
    @Schema(name="supportDualSim", description="Whether it supports dual SIM single standby: 0: not support, 1: support.")
    private Integer supportDualSim;
    @Schema(name="supportDsl", description="Whether it supports DSL.")
    private Boolean supportDsl;
    @Schema(name="supportVirtualWan", description="Whether it supports virtual wan.")
    private Boolean supportVirtualWan;
    @Schema(name="supportDhcpOptions", description="Whether dhcpOptions can be customized.")
    private Boolean supportDhcpOptions;
    @Schema(name="wanPortSettings", description="A list of wan port setting.")
    @Valid
    private List<WanPortSettingOpenApiVO> wanPortSettings;
    @Schema(name="usbLteSettings", description="A list of USB LTE setting.")
    private List<UsbLteSettingOpenApiVO> usbLteSettings;
    @Schema(name="lteWanSettings", description="A list of LTE wan setting.")
    @Valid
    private List<LteWanPortSettingOpenApiV2VO> lteWanSettings;
    @Schema(name="wanLoadBalance", description="Load balancing configuration for multi-WAN interfaces.")
    @Valid
    private WanLoadBalanceOpenApiVO wanLoadBalance;
    @Schema(name="networkNames", description="A list of the name of the LanNetwork entry that was invalidated on the frontend.")
    private List<String> networkNames;
    @Schema(name="unmatchedWans", description="A list of the name of the WAN port that was invalidated on the frontend.")
    private List<String> unmatchedWans;
    @Schema(name="gatewayMac", description="Gateway MAC.")
    @a
    private String gatewayMac;
    @Schema(name="enableModified", description="Whether it enable modified.")
    private Boolean enableModified;
    @Schema(name="lteIntervalTips", description="Whether to display the interval prompt for LTE ports.")
    private Boolean lteIntervalTips;
    @Schema(name="resource", description="Resource of data.")
    private Integer resource;

    public static InternetOpenApiV2VO buildFromWebVO(InternetVO webVO) {
        if (Objects.isNull(webVO)) {
            return new InternetOpenApiV2VO();
        }
        InternetOpenApiV2VO internetOpenApiV2VO = new InternetOpenApiV2VO();
        internetOpenApiV2VO.setOmadacId(webVO.getOmadacId());
        internetOpenApiV2VO.setSiteId(webVO.getSiteId());
        internetOpenApiV2VO.setRealOsgModel(webVO.getOsgPortInfo().getRealOsgModel());
        internetOpenApiV2VO.setEnable(webVO.getEnable());
        internetOpenApiV2VO.setPortUuids(webVO.getPortUuids());
        internetOpenApiV2VO.setSupportCustomInterval(webVO.getSupportCustomInterval());
        internetOpenApiV2VO.setInterval(webVO.getInterval());
        internetOpenApiV2VO.setUnit(webVO.getUnit());
        internetOpenApiV2VO.setSupportDualSim(webVO.getSupportDualSim());
        internetOpenApiV2VO.setLteIntervalTips(webVO.getLteIntervalTips());
        internetOpenApiV2VO.setLteWanSettings(CollectionUtils.isEmpty((Collection)webVO.getLteWanSettings()) ? new ArrayList<LteWanPortSettingOpenApiV2VO>() : webVO.getLteWanSettings().stream().map(LteWanPortSettingOpenApiV2VO::fromWebVO).toList());
        return internetOpenApiV2VO;
    }

    @Generated
    public String getOmadacId() {
        return this.omadacId;
    }

    @Generated
    public String getSiteId() {
        return this.siteId;
    }

    @Generated
    public String getRealOsgModel() {
        return this.realOsgModel;
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public OsgPortInfoOpenApiVO getOsgPortInfo() {
        return this.osgPortInfo;
    }

    @Generated
    public List<String> getPortUuids() {
        return this.portUuids;
    }

    @Generated
    public Integer getInterval() {
        return this.interval;
    }

    @Generated
    public Integer getUnit() {
        return this.unit;
    }

    @Generated
    public Boolean getSupportCustomInterval() {
        return this.supportCustomInterval;
    }

    @Generated
    public Boolean getSupportDiscreteWan() {
        return this.supportDiscreteWan;
    }

    @Generated
    public Boolean getSupportReduceUsbRfi() {
        return this.supportReduceUsbRfi;
    }

    @Generated
    public Boolean getSupportAllWan() {
        return this.supportAllWan;
    }

    @Generated
    public Integer getSupportMaxWanNum() {
        return this.supportMaxWanNum;
    }

    @Generated
    public Boolean getSupportIpv6NonAddress() {
        return this.supportIpv6NonAddress;
    }

    @Generated
    public Boolean getSupportMssClamping() {
        return this.supportMssClamping;
    }

    @Generated
    public Boolean getSupportPppoeMru() {
        return this.supportPppoeMru;
    }

    @Generated
    public Boolean getSupportWanMultipleIp() {
        return this.supportWanMultipleIp;
    }

    @Generated
    public Boolean getSupportLte() {
        return this.supportLte;
    }

    @Generated
    public Integer getSupportDualSim() {
        return this.supportDualSim;
    }

    @Generated
    public Boolean getSupportDsl() {
        return this.supportDsl;
    }

    @Generated
    public Boolean getSupportVirtualWan() {
        return this.supportVirtualWan;
    }

    @Generated
    public Boolean getSupportDhcpOptions() {
        return this.supportDhcpOptions;
    }

    @Generated
    public List<WanPortSettingOpenApiVO> getWanPortSettings() {
        return this.wanPortSettings;
    }

    @Generated
    public List<UsbLteSettingOpenApiVO> getUsbLteSettings() {
        return this.usbLteSettings;
    }

    @Generated
    public List<LteWanPortSettingOpenApiV2VO> getLteWanSettings() {
        return this.lteWanSettings;
    }

    @Generated
    public WanLoadBalanceOpenApiVO getWanLoadBalance() {
        return this.wanLoadBalance;
    }

    @Generated
    public List<String> getNetworkNames() {
        return this.networkNames;
    }

    @Generated
    public List<String> getUnmatchedWans() {
        return this.unmatchedWans;
    }

    @Generated
    public String getGatewayMac() {
        return this.gatewayMac;
    }

    @Generated
    public Boolean getEnableModified() {
        return this.enableModified;
    }

    @Generated
    public Boolean getLteIntervalTips() {
        return this.lteIntervalTips;
    }

    @Generated
    public Integer getResource() {
        return this.resource;
    }

    @Generated
    public void setOmadacId(String omadacId) {
        this.omadacId = omadacId;
    }

    @Generated
    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    @Generated
    public void setRealOsgModel(String realOsgModel) {
        this.realOsgModel = realOsgModel;
    }

    @Generated
    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    @Generated
    public void setOsgPortInfo(OsgPortInfoOpenApiVO osgPortInfo) {
        this.osgPortInfo = osgPortInfo;
    }

    @Generated
    public void setPortUuids(List<String> portUuids) {
        this.portUuids = portUuids;
    }

    @Generated
    public void setInterval(Integer interval) {
        this.interval = interval;
    }

    @Generated
    public void setUnit(Integer unit) {
        this.unit = unit;
    }

    @Generated
    public void setSupportCustomInterval(Boolean supportCustomInterval) {
        this.supportCustomInterval = supportCustomInterval;
    }

    @Generated
    public void setSupportDiscreteWan(Boolean supportDiscreteWan) {
        this.supportDiscreteWan = supportDiscreteWan;
    }

    @Generated
    public void setSupportReduceUsbRfi(Boolean supportReduceUsbRfi) {
        this.supportReduceUsbRfi = supportReduceUsbRfi;
    }

    @Generated
    public void setSupportAllWan(Boolean supportAllWan) {
        this.supportAllWan = supportAllWan;
    }

    @Generated
    public void setSupportMaxWanNum(Integer supportMaxWanNum) {
        this.supportMaxWanNum = supportMaxWanNum;
    }

    @Generated
    public void setSupportIpv6NonAddress(Boolean supportIpv6NonAddress) {
        this.supportIpv6NonAddress = supportIpv6NonAddress;
    }

    @Generated
    public void setSupportMssClamping(Boolean supportMssClamping) {
        this.supportMssClamping = supportMssClamping;
    }

    @Generated
    public void setSupportPppoeMru(Boolean supportPppoeMru) {
        this.supportPppoeMru = supportPppoeMru;
    }

    @Generated
    public void setSupportWanMultipleIp(Boolean supportWanMultipleIp) {
        this.supportWanMultipleIp = supportWanMultipleIp;
    }

    @Generated
    public void setSupportLte(Boolean supportLte) {
        this.supportLte = supportLte;
    }

    @Generated
    public void setSupportDualSim(Integer supportDualSim) {
        this.supportDualSim = supportDualSim;
    }

    @Generated
    public void setSupportDsl(Boolean supportDsl) {
        this.supportDsl = supportDsl;
    }

    @Generated
    public void setSupportVirtualWan(Boolean supportVirtualWan) {
        this.supportVirtualWan = supportVirtualWan;
    }

    @Generated
    public void setSupportDhcpOptions(Boolean supportDhcpOptions) {
        this.supportDhcpOptions = supportDhcpOptions;
    }

    @Generated
    public void setWanPortSettings(List<WanPortSettingOpenApiVO> wanPortSettings) {
        this.wanPortSettings = wanPortSettings;
    }

    @Generated
    public void setUsbLteSettings(List<UsbLteSettingOpenApiVO> usbLteSettings) {
        this.usbLteSettings = usbLteSettings;
    }

    @Generated
    public void setLteWanSettings(List<LteWanPortSettingOpenApiV2VO> lteWanSettings) {
        this.lteWanSettings = lteWanSettings;
    }

    @Generated
    public void setWanLoadBalance(WanLoadBalanceOpenApiVO wanLoadBalance) {
        this.wanLoadBalance = wanLoadBalance;
    }

    @Generated
    public void setNetworkNames(List<String> networkNames) {
        this.networkNames = networkNames;
    }

    @Generated
    public void setUnmatchedWans(List<String> unmatchedWans) {
        this.unmatchedWans = unmatchedWans;
    }

    @Generated
    public void setGatewayMac(String gatewayMac) {
        this.gatewayMac = gatewayMac;
    }

    @Generated
    public void setEnableModified(Boolean enableModified) {
        this.enableModified = enableModified;
    }

    @Generated
    public void setLteIntervalTips(Boolean lteIntervalTips) {
        this.lteIntervalTips = lteIntervalTips;
    }

    @Generated
    public void setResource(Integer resource) {
        this.resource = resource;
    }

    @Generated
    public String toString() {
        return "InternetOpenApiV2VO(omadacId=" + this.getOmadacId() + ", siteId=" + this.getSiteId() + ", realOsgModel=" + this.getRealOsgModel() + ", enable=" + this.getEnable() + ", osgPortInfo=" + this.getOsgPortInfo() + ", portUuids=" + this.getPortUuids() + ", interval=" + this.getInterval() + ", unit=" + this.getUnit() + ", supportCustomInterval=" + this.getSupportCustomInterval() + ", supportDiscreteWan=" + this.getSupportDiscreteWan() + ", supportReduceUsbRfi=" + this.getSupportReduceUsbRfi() + ", supportAllWan=" + this.getSupportAllWan() + ", supportMaxWanNum=" + this.getSupportMaxWanNum() + ", supportIpv6NonAddress=" + this.getSupportIpv6NonAddress() + ", supportMssClamping=" + this.getSupportMssClamping() + ", supportPppoeMru=" + this.getSupportPppoeMru() + ", supportWanMultipleIp=" + this.getSupportWanMultipleIp() + ", supportLte=" + this.getSupportLte() + ", supportDualSim=" + this.getSupportDualSim() + ", supportDsl=" + this.getSupportDsl() + ", supportVirtualWan=" + this.getSupportVirtualWan() + ", supportDhcpOptions=" + this.getSupportDhcpOptions() + ", wanPortSettings=" + this.getWanPortSettings() + ", usbLteSettings=" + this.getUsbLteSettings() + ", lteWanSettings=" + this.getLteWanSettings() + ", wanLoadBalance=" + this.getWanLoadBalance() + ", networkNames=" + this.getNetworkNames() + ", unmatchedWans=" + this.getUnmatchedWans() + ", gatewayMac=" + this.getGatewayMac() + ", enableModified=" + this.getEnableModified() + ", lteIntervalTips=" + this.getLteIntervalTips() + ", resource=" + this.getResource() + ")";
    }

    @Generated
    public InternetOpenApiV2VO(String omadacId, String siteId, String realOsgModel, Boolean enable, OsgPortInfoOpenApiVO osgPortInfo, List<String> portUuids, Integer interval, Integer unit, Boolean supportCustomInterval, Boolean supportDiscreteWan, Boolean supportReduceUsbRfi, Boolean supportAllWan, Integer supportMaxWanNum, Boolean supportIpv6NonAddress, Boolean supportMssClamping, Boolean supportPppoeMru, Boolean supportWanMultipleIp, Boolean supportLte, Integer supportDualSim, Boolean supportDsl, Boolean supportVirtualWan, Boolean supportDhcpOptions, List<WanPortSettingOpenApiVO> wanPortSettings, List<UsbLteSettingOpenApiVO> usbLteSettings, List<LteWanPortSettingOpenApiV2VO> lteWanSettings, WanLoadBalanceOpenApiVO wanLoadBalance, List<String> networkNames, List<String> unmatchedWans, String gatewayMac, Boolean enableModified, Boolean lteIntervalTips, Integer resource) {
        this.omadacId = omadacId;
        this.siteId = siteId;
        this.realOsgModel = realOsgModel;
        this.enable = enable;
        this.osgPortInfo = osgPortInfo;
        this.portUuids = portUuids;
        this.interval = interval;
        this.unit = unit;
        this.supportCustomInterval = supportCustomInterval;
        this.supportDiscreteWan = supportDiscreteWan;
        this.supportReduceUsbRfi = supportReduceUsbRfi;
        this.supportAllWan = supportAllWan;
        this.supportMaxWanNum = supportMaxWanNum;
        this.supportIpv6NonAddress = supportIpv6NonAddress;
        this.supportMssClamping = supportMssClamping;
        this.supportPppoeMru = supportPppoeMru;
        this.supportWanMultipleIp = supportWanMultipleIp;
        this.supportLte = supportLte;
        this.supportDualSim = supportDualSim;
        this.supportDsl = supportDsl;
        this.supportVirtualWan = supportVirtualWan;
        this.supportDhcpOptions = supportDhcpOptions;
        this.wanPortSettings = wanPortSettings;
        this.usbLteSettings = usbLteSettings;
        this.lteWanSettings = lteWanSettings;
        this.wanLoadBalance = wanLoadBalance;
        this.networkNames = networkNames;
        this.unmatchedWans = unmatchedWans;
        this.gatewayMac = gatewayMac;
        this.enableModified = enableModified;
        this.lteIntervalTips = lteIntervalTips;
        this.resource = resource;
    }

    @Generated
    public InternetOpenApiV2VO() {
    }
}

