/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork;

import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.DialupSettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@KeepClass
public class DialupSettingOpenApiVO {
    @NotNull
    @Range(max=1L)
    @Schema(name="networkSearch", description="Network search mode should be a value as follows: 0: auto; 1: manual.")
    private @NotNull @Range(max=1L) Integer networkSearch;
    @Schema(name="isp", description="Only for networkSearch mode manual and the ISP from the scan result must be available.")
    private String isp;
    @Schema(name="ispNum", description="Only for networkSearch mode manual and the ISP from the scan result must be available.")
    private Integer ispNum;
    @NotNull
    @Schema(name="apnMode", description="Apn mode should be a value as follows: 0: auto; 1: manual.")
    private Integer apnMode;
    @Schema(name="apn", description="APN profile ID, only for apnMode manual")
    private String apn;

    public static DialupSettingOpenApiVO fromWebVO(DialupSettingVO vo) {
        DialupSettingOpenApiVO openApiVO = new DialupSettingOpenApiVO();
        openApiVO.setNetworkSearch(vo.getNetworkSearch());
        if (Objects.equals(openApiVO.getNetworkSearch(), 1)) {
            openApiVO.setIsp(vo.getIsp());
            openApiVO.setIspNum(vo.getIspNum());
        }
        openApiVO.setApnMode(vo.getApnMode());
        if (Objects.equals(openApiVO.getApnMode(), 1)) {
            openApiVO.setApn(vo.getApn());
        }
        return openApiVO;
    }

    public static DialupSettingVO toWebVO(DialupSettingOpenApiVO openApiVO) {
        DialupSettingVO webVO = new DialupSettingVO();
        webVO.setNetworkSearch(openApiVO.getNetworkSearch());
        if (Objects.equals(webVO.getNetworkSearch(), 1)) {
            webVO.setIsp(openApiVO.getIsp());
            webVO.setIspNum(openApiVO.getIspNum());
        }
        webVO.setApnMode(openApiVO.getApnMode());
        if (Objects.equals(webVO.getApnMode(), 1)) {
            webVO.setApn(openApiVO.getApn());
        }
        return webVO;
    }

    @Generated
    public Integer getNetworkSearch() {
        return this.networkSearch;
    }

    @Generated
    public String getIsp() {
        return this.isp;
    }

    @Generated
    public Integer getIspNum() {
        return this.ispNum;
    }

    @Generated
    public Integer getApnMode() {
        return this.apnMode;
    }

    @Generated
    public String getApn() {
        return this.apn;
    }

    @Generated
    public void setNetworkSearch(Integer networkSearch) {
        this.networkSearch = networkSearch;
    }

    @Generated
    public void setIsp(String isp) {
        this.isp = isp;
    }

    @Generated
    public void setIspNum(Integer ispNum) {
        this.ispNum = ispNum;
    }

    @Generated
    public void setApnMode(Integer apnMode) {
        this.apnMode = apnMode;
    }

    @Generated
    public void setApn(String apn) {
        this.apn = apn;
    }

    @Generated
    public String toString() {
        return "DialupSettingOpenApiVO(networkSearch=" + this.getNetworkSearch() + ", isp=" + this.getIsp() + ", ispNum=" + this.getIspNum() + ", apnMode=" + this.getApnMode() + ", apn=" + this.getApn() + ")";
    }
}

