/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork;

import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.DialupSettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@KeepClass
public class DialupSettingOpenApiV2VO {
    @NotNull
    @Range(max=1L, message="NetworkSearch should be 0 or 1.")
    @Schema(name="networkSearch", description="Network search mode should be a value as follows: 0: auto; 1: manual.")
    private @NotNull @Range(max=1L, message="NetworkSearch should be 0 or 1.") Integer networkSearch;
    @Schema(name="isp", description="Only for networkSearch mode manual.")
    private String isp;
    @Schema(name="ispNum", description="Only for networkSearch mode manual.")
    private Integer ispNum;
    @NotNull
    @Schema(name="apnMode", description="Apn mode should be a value as follows: 0: auto; 1: manual.")
    private Integer apnMode;
    @Schema(name="apn", description="APN profile ID, only for apnMode manual")
    private String apn;
    @Range(min=100L, max=3552L, message="FailoverTimeout should between 100 and 3552.")
    @Schema(name="failoverTimeout", description="SIM card's failoverTimeout. Set the dial-up timeout (100 to 3552 seconds). If the connection is not successfully established within the specified time, the gateway will use the other SIM card to connect to the internet.")
    private @Range(min=100L, max=3552L, message="FailoverTimeout should between 100 and 3552.") Integer failoverTimeout;
    @NotNull
    @Schema(name="dataRoaming", description="SIM card's data roaming")
    private Boolean dataRoaming;
    @NotNull
    @Schema(name="networkMode", description="SIM card's networkMode: 1:3G Only, 2:4G Only, 3:4G Preferred4: 5G-NSA/4G, 5: 5G-SA, 6: 5G/4G/3G")
    @Range(min=1L, max=6L, message="NetworkMode should between 1 and 6.")
    private @NotNull @Range(min=1L, max=6L, message="NetworkMode should between 1 and 6.") Integer networkMode;
    @Schema(name="bandMode", description="SIM card's bandMode: 0:auto, 1:manual, only for networkMode 4g Only and 4G Preferred")
    private Integer bandMode;
    @Schema(name="bands", description="SIM card's 4g bands. Only for band mode manual")
    private List<String> bands;
    @Schema(name="bands", description="SIM card's 5g bands. Only for band mode manual")
    private List<String> bands5g;

    public static DialupSettingVO toWebVO(DialupSettingOpenApiV2VO openApiVO) {
        DialupSettingVO webVO = new DialupSettingVO();
        webVO.setNetworkSearch(openApiVO.getNetworkSearch());
        if (Objects.equals(webVO.getNetworkSearch(), 1)) {
            webVO.setIsp(openApiVO.getIsp());
            webVO.setIspNum(openApiVO.getIspNum());
        }
        webVO.setApnMode(openApiVO.getApnMode());
        if (Objects.equals(webVO.getApnMode(), 1)) {
            webVO.setApn(openApiVO.getApn());
        }
        webVO.setDataRoaming(openApiVO.getDataRoaming());
        webVO.setFailoverTimeout(openApiVO.getFailoverTimeout());
        webVO.setNetworkMode(openApiVO.getNetworkMode());
        webVO.setBandMode(openApiVO.getBandMode());
        if (Objects.equals(webVO.getBandMode(), 1)) {
            webVO.setBands(openApiVO.getBands());
            webVO.setBands5g(openApiVO.getBands5g());
        }
        return webVO;
    }

    public static DialupSettingOpenApiV2VO fromWebVO(DialupSettingVO vo) {
        DialupSettingOpenApiV2VO openApiVO = new DialupSettingOpenApiV2VO();
        openApiVO.setNetworkSearch(vo.getNetworkSearch());
        if (Objects.equals(openApiVO.getNetworkSearch(), 1)) {
            openApiVO.setIsp(vo.getIsp());
            openApiVO.setIspNum(vo.getIspNum());
        }
        openApiVO.setApnMode(vo.getApnMode());
        if (Objects.equals(openApiVO.getApnMode(), 1)) {
            openApiVO.setApn(vo.getApn());
        }
        openApiVO.setDataRoaming(vo.getDataRoaming());
        openApiVO.setFailoverTimeout(vo.getFailoverTimeout());
        openApiVO.setNetworkMode(vo.getNetworkMode());
        openApiVO.setBandMode(vo.getBandMode());
        if (Objects.equals(openApiVO.getBandMode(), 1)) {
            openApiVO.setBands(vo.getBands());
            openApiVO.setBands5g(vo.getBands5g());
        }
        return openApiVO;
    }

    @Generated
    public Integer getNetworkSearch() {
        return this.networkSearch;
    }

    @Generated
    public String getIsp() {
        return this.isp;
    }

    @Generated
    public Integer getIspNum() {
        return this.ispNum;
    }

    @Generated
    public Integer getApnMode() {
        return this.apnMode;
    }

    @Generated
    public String getApn() {
        return this.apn;
    }

    @Generated
    public Integer getFailoverTimeout() {
        return this.failoverTimeout;
    }

    @Generated
    public Boolean getDataRoaming() {
        return this.dataRoaming;
    }

    @Generated
    public Integer getNetworkMode() {
        return this.networkMode;
    }

    @Generated
    public Integer getBandMode() {
        return this.bandMode;
    }

    @Generated
    public List<String> getBands() {
        return this.bands;
    }

    @Generated
    public List<String> getBands5g() {
        return this.bands5g;
    }

    @Generated
    public void setNetworkSearch(Integer networkSearch) {
        this.networkSearch = networkSearch;
    }

    @Generated
    public void setIsp(String isp) {
        this.isp = isp;
    }

    @Generated
    public void setIspNum(Integer ispNum) {
        this.ispNum = ispNum;
    }

    @Generated
    public void setApnMode(Integer apnMode) {
        this.apnMode = apnMode;
    }

    @Generated
    public void setApn(String apn) {
        this.apn = apn;
    }

    @Generated
    public void setFailoverTimeout(Integer failoverTimeout) {
        this.failoverTimeout = failoverTimeout;
    }

    @Generated
    public void setDataRoaming(Boolean dataRoaming) {
        this.dataRoaming = dataRoaming;
    }

    @Generated
    public void setNetworkMode(Integer networkMode) {
        this.networkMode = networkMode;
    }

    @Generated
    public void setBandMode(Integer bandMode) {
        this.bandMode = bandMode;
    }

    @Generated
    public void setBands(List<String> bands) {
        this.bands = bands;
    }

    @Generated
    public void setBands5g(List<String> bands5g) {
        this.bands5g = bands5g;
    }

    @Generated
    public String toString() {
        return "DialupSettingOpenApiV2VO(networkSearch=" + this.getNetworkSearch() + ", isp=" + this.getIsp() + ", ispNum=" + this.getIspNum() + ", apnMode=" + this.getApnMode() + ", apn=" + this.getApn() + ", failoverTimeout=" + this.getFailoverTimeout() + ", dataRoaming=" + this.getDataRoaming() + ", networkMode=" + this.getNetworkMode() + ", bandMode=" + this.getBandMode() + ", bands=" + this.getBands() + ", bands5g=" + this.getBands5g() + ")";
    }
}

