/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork;

import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.DhcpOptionOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.DhcpRangeOpenApiVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class DhcpSettingsConfigTemplateOpenApiVO {
    @Schema(name="enable", description="When value is true, DHCP server is enabled")
    private Boolean enable;
    @Valid
    @Schema(name="ipRangePool", description="The list of DHCP Range, which size can't be more than \"dhcpRangePoolSize\", \"dhcpRangePoolSize\" can be obtained from 'Get LAN network template list' interface.")
    private List<DhcpRangeOpenApiVO> ipRangePool;
    @Schema(name="dhcpns", description="Setup DHCP server: \"auto\" or \"manual\"")
    private String dhcpns;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DHCP Name Server IP1")
    @Schema(name="priDns", description="When DHCPs are \"manual\", primary DNS Server.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DHCP Name Server IP1") String priDns;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DHCP Name Server IP2")
    @Schema(name="sndDns", description="When DHCPs are \"manual\", second DNS Server.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DHCP Name Server IP2") String sndDns;
    @Range(min=2L, max=10080L, message="Value of leasetime is from 2 to 10080.")
    @Schema(name="leasetime", description="Leasetime should be within the range of 2-10080")
    private @Range(min=2L, max=10080L, message="Value of leasetime is from 2 to 10080.") Integer leasetime;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DHCP Gateway IP")
    @Schema(name="gateway", description="Manual Setup of DHCP Gateway IP")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DHCP Gateway IP") String gateway;
    @Schema(name="options", description="User custom DHCP options")
    private List<DhcpOptionOpenApiVO> options;

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public List<DhcpRangeOpenApiVO> getIpRangePool() {
        return this.ipRangePool;
    }

    @Generated
    public String getDhcpns() {
        return this.dhcpns;
    }

    @Generated
    public String getPriDns() {
        return this.priDns;
    }

    @Generated
    public String getSndDns() {
        return this.sndDns;
    }

    @Generated
    public Integer getLeasetime() {
        return this.leasetime;
    }

    @Generated
    public String getGateway() {
        return this.gateway;
    }

    @Generated
    public List<DhcpOptionOpenApiVO> getOptions() {
        return this.options;
    }

    @Generated
    public DhcpSettingsConfigTemplateOpenApiVO setEnable(Boolean enable) {
        this.enable = enable;
        return this;
    }

    @Generated
    public DhcpSettingsConfigTemplateOpenApiVO setIpRangePool(List<DhcpRangeOpenApiVO> ipRangePool) {
        this.ipRangePool = ipRangePool;
        return this;
    }

    @Generated
    public DhcpSettingsConfigTemplateOpenApiVO setDhcpns(String dhcpns) {
        this.dhcpns = dhcpns;
        return this;
    }

    @Generated
    public DhcpSettingsConfigTemplateOpenApiVO setPriDns(String priDns) {
        this.priDns = priDns;
        return this;
    }

    @Generated
    public DhcpSettingsConfigTemplateOpenApiVO setSndDns(String sndDns) {
        this.sndDns = sndDns;
        return this;
    }

    @Generated
    public DhcpSettingsConfigTemplateOpenApiVO setLeasetime(Integer leasetime) {
        this.leasetime = leasetime;
        return this;
    }

    @Generated
    public DhcpSettingsConfigTemplateOpenApiVO setGateway(String gateway) {
        this.gateway = gateway;
        return this;
    }

    @Generated
    public DhcpSettingsConfigTemplateOpenApiVO setOptions(List<DhcpOptionOpenApiVO> options) {
        this.options = options;
        return this;
    }

    @Generated
    public String toString() {
        return "DhcpSettingsConfigTemplateOpenApiVO(enable=" + this.getEnable() + ", ipRangePool=" + this.getIpRangePool() + ", dhcpns=" + this.getDhcpns() + ", priDns=" + this.getPriDns() + ", sndDns=" + this.getSndDns() + ", leasetime=" + this.getLeasetime() + ", gateway=" + this.getGateway() + ", options=" + this.getOptions() + ")";
    }
}

