/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork;

import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.BandResultOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.scan.band.BandScanResultVO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;
import org.springframework.util.CollectionUtils;

public class BandScanResultOpenApiVO {
    @Schema(name="status", description="The status of the band scan: 0 - Failed, 1 - Succeeded, 2 - Scanning.")
    @Range(min=0L, max=2L, message="Value of status is from 0 to 2.")
    private @Range(min=0L, max=2L, message="Value of status is from 0 to 2.") Integer status;
    @Schema(name="bands", description="The result of the band scan.")
    private List<BandResultOpenApiVO> bands;
    @Schema(name="isp", description="Internet service provider.")
    private String isp;
    @Schema(name="simCard", description="When the device supports Dual-SIM card, parameter [simCard] should not be null.1: SIM1; 2: SIM2.")
    @Range(min=1L, max=2L, message="Value of simCard is 1 or 2.")
    private @Range(min=1L, max=2L, message="Value of simCard is 1 or 2.") Integer simCard;

    public static BandScanResultOpenApiVO buildFromWebVO(BandScanResultVO vo) {
        BandScanResultOpenApiVO res = new BandScanResultOpenApiVO();
        if (Objects.isNull(vo)) {
            return res;
        }
        res.setStatus(vo.getStatus());
        res.setBands(CollectionUtils.isEmpty((Collection)vo.getBands()) ? new ArrayList<BandResultOpenApiVO>() : vo.getBands().stream().map(BandResultOpenApiVO::buildFromWebVO).collect(Collectors.toList()));
        res.setIsp(vo.getIsp());
        res.setSimCard(vo.getSimCard());
        return res;
    }

    @Generated
    public Integer getStatus() {
        return this.status;
    }

    @Generated
    public List<BandResultOpenApiVO> getBands() {
        return this.bands;
    }

    @Generated
    public String getIsp() {
        return this.isp;
    }

    @Generated
    public Integer getSimCard() {
        return this.simCard;
    }

    @Generated
    public void setStatus(Integer status) {
        this.status = status;
    }

    @Generated
    public void setBands(List<BandResultOpenApiVO> bands) {
        this.bands = bands;
    }

    @Generated
    public void setIsp(String isp) {
        this.isp = isp;
    }

    @Generated
    public void setSimCard(Integer simCard) {
        this.simCard = simCard;
    }

    @Generated
    public String toString() {
        return "BandScanResultOpenApiVO(status=" + this.getStatus() + ", bands=" + this.getBands() + ", isp=" + this.getIsp() + ", simCard=" + this.getSimCard() + ")";
    }

    @Generated
    public BandScanResultOpenApiVO() {
    }

    @Generated
    public BandScanResultOpenApiVO(Integer status, List<BandResultOpenApiVO> bands, String isp, Integer simCard) {
        this.status = status;
        this.bands = bands;
        this.isp = isp;
        this.simCard = simCard;
    }
}

