/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.vpn.wireguardvpn.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

public class WireguardPeerOpenApiVO {
    @Schema(name="name", description="The name of WireGuard peer should contain 1 to 64 characters.")
    @NotNull(message="Parameter [name] can not be null.")
    @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] can only be 1 to 64 characters, with no spaces at the beginning and end.")
    private @NotNull(message="Parameter [name] can not be null.") @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] can only be 1 to 64 characters, with no spaces at the beginning and end.") String name;
    @Schema(name="status", description="The status of WireGuard peer. Valid value is true or false.")
    @NotNull(message="Parameter [status] can not be null.")
    private @NotNull(message="Parameter [status] can not be null.") Boolean status;
    @Schema(name="interfaceId", description="The ID of WireGuard VPN to which this WireGuard peer binds. The ID can be obtained from 'Get all wireguard's id and name info' interface.")
    @NotNull(message="Parameter [interfaceId] can not be null.")
    private @NotNull(message="Parameter [interfaceId] can not be null.") String interfaceId;
    @Schema(name="publicKey", description="The public key of WireGuard peer must have 44 character of base64 and end with '='.")
    @NotNull(message="Parameter [publicKey] can not be null.")
    @Pattern(regexp="^[0-9a-zA-Z+/]{43}=$", message="Parameter [publicKey] must have 44 character of base64 and end with '='.")
    private @NotNull(message="Parameter [publicKey] can not be null.") @Pattern(regexp="^[0-9a-zA-Z+/]{43}=$", message="Parameter [publicKey] must have 44 character of base64 and end with '='.") String publicKey;
    @Length(max=253, message="This length should be no more than 253.")
    @Schema(name="endPoint", description="The end point IP of WireGuard peer. Get whether supports domain from interface 'Get wireguard peer list'.")
    private @Length(max=253, message="This length should be no more than 253.") String endPoint;
    @Schema(name="endPointPort", description="The end point port of WireGuard peer should be within the range of 1-65535.")
    @Range(min=1L, max=65535L, message="Parameter [endPointPort] must be between 1 and  65535.")
    private @Range(min=1L, max=65535L, message="Parameter [endPointPort] must be between 1 and  65535.") Integer endPointPort;
    @Schema(name="allowAddress", description="IP/MASK address list of WireGuard peer allowed.")
    @NotNull(message="Parameter [allowAddress] can not be null.")
    private @NotNull(message="Parameter [allowAddress] can not be null.") List<String> allowAddress;
    @Schema(name="presharedKey", description="The presharedKey of WireGuard peer must have 44 character of base64 and end with '='.")
    @Pattern(regexp="^[0-9a-zA-Z+/]{43}=$", message="Parameter [presharedKey] must have 44 character of base64 and end with '='.")
    private @Pattern(regexp="^[0-9a-zA-Z+/]{43}=$", message="Parameter [presharedKey] must have 44 character of base64 and end with '='.") String presharedKey;
    @Schema(name="keepAlive", description="The keepalive second of WireGuard peer should be within the range of 0-65535.")
    @NotNull(message="Parameter [keepAlive] can not be null.")
    @Range(min=0L, max=65535L, message="Parameter [keepAlive] must be between 0 and 65535.")
    private @NotNull(message="Parameter [keepAlive] can not be null.") @Range(min=0L, max=65535L, message="Parameter [keepAlive] must be between 0 and 65535.") Integer keepAlive;
    @Schema(name="comment", description="The comment of WireGuard peer should contain 0 to 128 characters.")
    @Pattern(regexp="^$|^[^ ]$|^[^ ].{0,126}[^ ]$", message="Parameter [comment] should not more than 128 character.")
    private @Pattern(regexp="^$|^[^ ]$|^[^ ].{0,126}[^ ]$", message="Parameter [comment] should not more than 128 character.") String comment;

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public String getInterfaceId() {
        return this.interfaceId;
    }

    @Generated
    public String getPublicKey() {
        return this.publicKey;
    }

    @Generated
    public String getEndPoint() {
        return this.endPoint;
    }

    @Generated
    public Integer getEndPointPort() {
        return this.endPointPort;
    }

    @Generated
    public List<String> getAllowAddress() {
        return this.allowAddress;
    }

    @Generated
    public String getPresharedKey() {
        return this.presharedKey;
    }

    @Generated
    public Integer getKeepAlive() {
        return this.keepAlive;
    }

    @Generated
    public String getComment() {
        return this.comment;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setStatus(Boolean status) {
        this.status = status;
    }

    @Generated
    public void setInterfaceId(String interfaceId) {
        this.interfaceId = interfaceId;
    }

    @Generated
    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    @Generated
    public void setEndPoint(String endPoint) {
        this.endPoint = endPoint;
    }

    @Generated
    public void setEndPointPort(Integer endPointPort) {
        this.endPointPort = endPointPort;
    }

    @Generated
    public void setAllowAddress(List<String> allowAddress) {
        this.allowAddress = allowAddress;
    }

    @Generated
    public void setPresharedKey(String presharedKey) {
        this.presharedKey = presharedKey;
    }

    @Generated
    public void setKeepAlive(Integer keepAlive) {
        this.keepAlive = keepAlive;
    }

    @Generated
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Generated
    public String toString() {
        return "WireguardPeerOpenApiVO(name=" + this.getName() + ", status=" + this.getStatus() + ", interfaceId=" + this.getInterfaceId() + ", publicKey=" + this.getPublicKey() + ", endPoint=" + this.getEndPoint() + ", endPointPort=" + this.getEndPointPort() + ", allowAddress=" + this.getAllowAddress() + ", presharedKey=" + this.getPresharedKey() + ", keepAlive=" + this.getKeepAlive() + ", comment=" + this.getComment() + ")";
    }
}

