/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.vpn.wireguardvpn.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class WireguardOpenApiVO {
    @Schema(name="name", description="The name of WireGuard VPN should contain 1 to 64 characters.")
    @NotNull(message="Parameter [name] can not be null.")
    @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] can only be 1 to 64 characters, with no spaces at the beginning and end.")
    private @NotNull(message="Parameter [name] can not be null.") @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] can only be 1 to 64 characters, with no spaces at the beginning and end.") String name;
    @Schema(name="status", description="The status of WireGuard VPN. Valid value is true or false.")
    @NotNull(message="Parameter [status] can not be null.")
    private @NotNull(message="Parameter [status] can not be null.") Boolean status;
    @Schema(name="mtu", description="The MTU of WireGuard VPN should be within the range of 576-1440.")
    @NotNull(message="Parameter [mtu] can not be null.")
    @Range(min=576L, max=1440L, message="Parameter [mtu] must be between 576 and 1440.")
    private @NotNull(message="Parameter [mtu] can not be null.") @Range(min=576L, max=1440L, message="Parameter [mtu] must be between 576 and 1440.") Integer mtu;
    @Schema(name="listenPort", description="The listening port for WireGuard VPN should be within the range of 1-65535.")
    @NotNull(message="Parameter [listenPort] can not be null.")
    @Range(min=1L, max=65535L, message="Parameter [listenPort] must be between 1 and 65535.")
    private @NotNull(message="Parameter [listenPort] can not be null.") @Range(min=1L, max=65535L, message="Parameter [listenPort] must be between 1 and 65535.") Integer listenPort;
    @Schema(name="privateKey", description="The private key of WireGuard VPN must have 44 character of base64 and end with '='.")
    @NotNull(message="Parameter [privatekey] can not be null.")
    @Pattern(regexp="^[0-9a-zA-Z+/]{43}=$", message="Parameter [privatekey] must have 44 character of base64 and end with '='.")
    private @NotNull(message="Parameter [privatekey] can not be null.") @Pattern(regexp="^[0-9a-zA-Z+/]{43}=$", message="Parameter [privatekey] must have 44 character of base64 and end with '='.") String privateKey;
    @Schema(name="localIp", description="The local IP address of WireGuard VPN.")
    @NotNull(message="Parameter [localIp] can not be null.")
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Parameter [localIp] is invalid.")
    private @NotNull(message="Parameter [localIp] can not be null.") @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Parameter [localIp] is invalid.") String localIp;

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public Integer getMtu() {
        return this.mtu;
    }

    @Generated
    public Integer getListenPort() {
        return this.listenPort;
    }

    @Generated
    public String getPrivateKey() {
        return this.privateKey;
    }

    @Generated
    public String getLocalIp() {
        return this.localIp;
    }

    @Generated
    public WireguardOpenApiVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public WireguardOpenApiVO setStatus(Boolean status) {
        this.status = status;
        return this;
    }

    @Generated
    public WireguardOpenApiVO setMtu(Integer mtu) {
        this.mtu = mtu;
        return this;
    }

    @Generated
    public WireguardOpenApiVO setListenPort(Integer listenPort) {
        this.listenPort = listenPort;
        return this;
    }

    @Generated
    public WireguardOpenApiVO setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    @Generated
    public WireguardOpenApiVO setLocalIp(String localIp) {
        this.localIp = localIp;
        return this;
    }

    @Generated
    public String toString() {
        return "WireguardOpenApiVO(name=" + this.getName() + ", status=" + this.getStatus() + ", mtu=" + this.getMtu() + ", listenPort=" + this.getListenPort() + ", privateKey=" + this.getPrivateKey() + ", localIp=" + this.getLocalIp() + ")";
    }
}

