/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.vpn.vpn;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.vpn.grid.VpnUserOpenApiGridVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.profile.dto.embed.IPSubnetsVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.vpn.dto.VpnUserVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="VpnUserResponse")
public class VpnUserResponseOpenApiV2VO {
    @Schema(name="id", description="ID of the VPN user.")
    private String id;
    @Schema(name="omadacId", description="ID of current Controller.")
    private String omadacId;
    @Schema(name="site", description="ID of current Site.")
    private String site;
    @Schema(name="username", description="Username of the VPN user.")
    @PII(strategy=PIIMaskStrategy.HASH)
    private String username;
    @Schema(name="password", description="Password of the VPN user.")
    @PII(strategy=PIIMaskStrategy.MASK)
    private String password;
    @Schema(name="protocol", description="Protocol should be a value as follows: 0: L2TP or PPTP; 1: openVPN.")
    private Integer protocol;
    @Schema(name="clientMode", description="Client mode should be a value as follows: 0: Client-To-Site, 1: Site-To-Site.")
    private Integer clientMode;
    @Schema(name="maxConnections", description="Max connections should be within the range of 1\u2013100.")
    @Range(min=1L, max=100L, message="Value of maxConnections is from 1 to 100.")
    private @Range(min=1L, max=100L, message="Value of maxConnections is from 1 to 100.") Integer maxConnections;
    @Schema(name="userRemoteSubnets", description="User remote subnets of the VPN user.")
    private List<IPSubnetsVO> userRemoteSubnets;
    @Schema(name="servers", description="Servers of the VPN user. Server can be created using 'Create client-to-site VPN server' interface, and server ID can be obtained from 'Get client-to-site VPN server list' interface.")
    private List<String> servers;
    @Schema(name="localIp", description="Local IP of the VPN user")
    private String localIp;
    @Schema(name="serverNames", description="Server names of the VPN user.")
    private String serverNames;
    @Schema(name="existLocalIp", description="Whether Local IP has been configured.")
    private Boolean existLocalIp;
    @Schema(name="existProtocol", description="Whether OpenVPN has configured as VPN Type.")
    private Boolean existProtocol;

    public static VpnUserResponseOpenApiV2VO toOpenApiVO(@Nonnull VpnUserVO vo) {
        VpnUserResponseOpenApiV2VO vpnUserResponseOpenApiV2VO = new VpnUserResponseOpenApiV2VO();
        vpnUserResponseOpenApiV2VO.setId(vo.getId());
        vpnUserResponseOpenApiV2VO.setUsername(vo.getUsername());
        vpnUserResponseOpenApiV2VO.setPassword(vo.getPassword());
        vpnUserResponseOpenApiV2VO.setProtocol(vo.getProtocol());
        vpnUserResponseOpenApiV2VO.setClientMode(vo.getClientMode());
        vpnUserResponseOpenApiV2VO.setMaxConnections(vo.getMaxConnections());
        vpnUserResponseOpenApiV2VO.setUserRemoteSubnets(vo.getUserRemoteSubnets());
        vpnUserResponseOpenApiV2VO.setServers(vo.getServers());
        vpnUserResponseOpenApiV2VO.setLocalIp(vo.getLocalIp());
        vpnUserResponseOpenApiV2VO.setServerNames(vo.getServerNames());
        vpnUserResponseOpenApiV2VO.setExistProtocol(vo.isExistProtocol());
        vpnUserResponseOpenApiV2VO.setExistLocalIp(vo.isExistLocalIp());
        vpnUserResponseOpenApiV2VO.setOmadacId(vo.getOmadacId());
        vpnUserResponseOpenApiV2VO.setSite(vo.getSite());
        return vpnUserResponseOpenApiV2VO;
    }

    public static List<VpnUserResponseOpenApiV2VO> toOpenApiListVO(@Nonnull List<VpnUserVO> voList) {
        return voList.stream().map(VpnUserResponseOpenApiV2VO::toOpenApiVO).collect(Collectors.toList());
    }

    public static VpnUserOpenApiGridVO<VpnUserResponseOpenApiV2VO> toOpenApiGridVO(@Nonnull GridVO<VpnUserVO> gridVO, Boolean supportLocalIp, Boolean supportProtocol) {
        VpnUserOpenApiGridVO<VpnUserResponseOpenApiV2VO> openApiGridVO = new VpnUserOpenApiGridVO<VpnUserResponseOpenApiV2VO>();
        openApiGridVO.setTotalRows(gridVO.getTotalRows());
        openApiGridVO.setCurrentPage(gridVO.getCurrentPage());
        openApiGridVO.setCurrentSize(gridVO.getCurrentSize());
        openApiGridVO.setData(gridVO.getData().stream().map(VpnUserResponseOpenApiV2VO::toOpenApiVO).collect(Collectors.toList()));
        openApiGridVO.setSupportLocalIp(supportLocalIp);
        openApiGridVO.setSupportProtocol(supportProtocol);
        return openApiGridVO;
    }

    public static VpnUserVO toVO(VpnUserResponseOpenApiV2VO openApiVO) {
        VpnUserVO vo = new VpnUserVO();
        vo.setId(openApiVO.getId());
        vo.setUsername(openApiVO.getUsername());
        vo.setPassword(openApiVO.getPassword());
        vo.setProtocol(openApiVO.getProtocol());
        vo.setClientMode(openApiVO.getClientMode());
        vo.setMaxConnections(openApiVO.getMaxConnections());
        vo.setUserRemoteSubnets(openApiVO.getUserRemoteSubnets());
        vo.setServers(openApiVO.getServers());
        vo.setLocalIp(openApiVO.getLocalIp());
        vo.setServerNames(openApiVO.getServerNames());
        return vo;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getOmadacId() {
        return this.omadacId;
    }

    @Generated
    public String getSite() {
        return this.site;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public Integer getProtocol() {
        return this.protocol;
    }

    @Generated
    public Integer getClientMode() {
        return this.clientMode;
    }

    @Generated
    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    @Generated
    public List<IPSubnetsVO> getUserRemoteSubnets() {
        return this.userRemoteSubnets;
    }

    @Generated
    public List<String> getServers() {
        return this.servers;
    }

    @Generated
    public String getLocalIp() {
        return this.localIp;
    }

    @Generated
    public String getServerNames() {
        return this.serverNames;
    }

    @Generated
    public Boolean getExistLocalIp() {
        return this.existLocalIp;
    }

    @Generated
    public Boolean getExistProtocol() {
        return this.existProtocol;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setOmadacId(String omadacId) {
        this.omadacId = omadacId;
    }

    @Generated
    public void setSite(String site) {
        this.site = site;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setProtocol(Integer protocol) {
        this.protocol = protocol;
    }

    @Generated
    public void setClientMode(Integer clientMode) {
        this.clientMode = clientMode;
    }

    @Generated
    public void setMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
    }

    @Generated
    public void setUserRemoteSubnets(List<IPSubnetsVO> userRemoteSubnets) {
        this.userRemoteSubnets = userRemoteSubnets;
    }

    @Generated
    public void setServers(List<String> servers) {
        this.servers = servers;
    }

    @Generated
    public void setLocalIp(String localIp) {
        this.localIp = localIp;
    }

    @Generated
    public void setServerNames(String serverNames) {
        this.serverNames = serverNames;
    }

    @Generated
    public void setExistLocalIp(Boolean existLocalIp) {
        this.existLocalIp = existLocalIp;
    }

    @Generated
    public void setExistProtocol(Boolean existProtocol) {
        this.existProtocol = existProtocol;
    }

    @Generated
    public String toString() {
        return "VpnUserResponseOpenApiV2VO(id=" + this.getId() + ", omadacId=" + this.getOmadacId() + ", site=" + this.getSite() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", protocol=" + this.getProtocol() + ", clientMode=" + this.getClientMode() + ", maxConnections=" + this.getMaxConnections() + ", userRemoteSubnets=" + this.getUserRemoteSubnets() + ", servers=" + this.getServers() + ", localIp=" + this.getLocalIp() + ", serverNames=" + this.getServerNames() + ", existLocalIp=" + this.getExistLocalIp() + ", existProtocol=" + this.getExistProtocol() + ")";
    }

    @Generated
    public VpnUserResponseOpenApiV2VO(String id, String omadacId, String site, String username, String password, Integer protocol, Integer clientMode, Integer maxConnections, List<IPSubnetsVO> userRemoteSubnets, List<String> servers, String localIp, String serverNames, Boolean existLocalIp, Boolean existProtocol) {
        this.id = id;
        this.omadacId = omadacId;
        this.site = site;
        this.username = username;
        this.password = password;
        this.protocol = protocol;
        this.clientMode = clientMode;
        this.maxConnections = maxConnections;
        this.userRemoteSubnets = userRemoteSubnets;
        this.servers = servers;
        this.localIp = localIp;
        this.serverNames = serverNames;
        this.existLocalIp = existLocalIp;
        this.existProtocol = existProtocol;
    }

    @Generated
    public VpnUserResponseOpenApiV2VO() {
    }
}

