/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.vpn.vpn;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.profile.dto.embed.IPSubnetsVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.vpn.dto.VpnUserVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="VpnUserRequest")
public class VpnUserRequestOpenApiV2VO {
    @Schema(name="username", description="Username of the VPN user.")
    @PII(strategy=PIIMaskStrategy.HASH)
    @NotNull
    private String username;
    @Schema(name="password", description="Password of the VPN user.")
    @PII(strategy=PIIMaskStrategy.MASK)
    @NotNull
    private String password;
    @Schema(name="protocol", description="Protocol should be a value as follows: 0: L2TP or PPTP; 1: openVPN.")
    private Integer protocol;
    @Schema(name="clientMode", description="Client mode should be a value as follows: 0: Client-To-Site, 1: Site-To-Site.")
    private Integer clientMode;
    @Schema(name="maxConnections", description="Max connections should be within the range of 1\u2013100.")
    @Range(min=1L, max=100L, message="Value of maxConnections is from 1 to 100.")
    private @Range(min=1L, max=100L, message="Value of maxConnections is from 1 to 100.") Integer maxConnections;
    @Schema(name="userRemoteSubnets", description="User remote subnets of the VPN user.")
    private List<IPSubnetsVO> userRemoteSubnets;
    @Schema(name="servers", description="Servers of the VPN user. Server can be created using 'Create client-to-site VPN server' interface, and server ID can be obtained from 'Get client-to-site VPN server list' interface.")
    @NotEmpty(message="VPN user configuration requires VPN server configuration.")
    private @NotEmpty(message="VPN user configuration requires VPN server configuration.") List<String> servers;
    @Schema(name="localIp", description="Local IP of the VPN user")
    private String localIp;

    public static VpnUserRequestOpenApiV2VO toOpenApiVO(@Nonnull VpnUserVO vo) {
        VpnUserRequestOpenApiV2VO vpnUserRequestOpenApiV2VO = new VpnUserRequestOpenApiV2VO();
        vpnUserRequestOpenApiV2VO.setUsername(vo.getUsername());
        vpnUserRequestOpenApiV2VO.setPassword(vo.getPassword());
        vpnUserRequestOpenApiV2VO.setProtocol(vo.getProtocol());
        vpnUserRequestOpenApiV2VO.setClientMode(vo.getClientMode());
        vpnUserRequestOpenApiV2VO.setMaxConnections(vo.getMaxConnections());
        vpnUserRequestOpenApiV2VO.setUserRemoteSubnets(vo.getUserRemoteSubnets());
        vpnUserRequestOpenApiV2VO.setServers(vo.getServers());
        vpnUserRequestOpenApiV2VO.setLocalIp(vo.getLocalIp());
        return vpnUserRequestOpenApiV2VO;
    }

    public static List<VpnUserRequestOpenApiV2VO> toOpenApiListVO(@Nonnull List<VpnUserVO> voList) {
        return voList.stream().map(VpnUserRequestOpenApiV2VO::toOpenApiVO).collect(Collectors.toList());
    }

    public static GridVO<VpnUserRequestOpenApiV2VO> toOpenApiGridVO(@Nonnull GridVO<VpnUserVO> gridVO) {
        GridVO openApiGridVO = new GridVO();
        openApiGridVO.setTotalRows(gridVO.getTotalRows());
        openApiGridVO.setCurrentPage(gridVO.getCurrentPage());
        openApiGridVO.setCurrentSize(gridVO.getCurrentSize());
        openApiGridVO.setData(gridVO.getData().stream().map(VpnUserRequestOpenApiV2VO::toOpenApiVO).collect(Collectors.toList()));
        return openApiGridVO;
    }

    public static VpnUserVO toVO(VpnUserRequestOpenApiV2VO openApiVO) {
        VpnUserVO vo = new VpnUserVO();
        vo.setUsername(openApiVO.getUsername());
        vo.setPassword(openApiVO.getPassword());
        vo.setProtocol(openApiVO.getProtocol());
        vo.setClientMode(openApiVO.getClientMode());
        vo.setMaxConnections(openApiVO.getMaxConnections());
        vo.setUserRemoteSubnets(openApiVO.getUserRemoteSubnets());
        vo.setServers(openApiVO.getServers());
        vo.setLocalIp(openApiVO.getLocalIp());
        return vo;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public Integer getProtocol() {
        return this.protocol;
    }

    @Generated
    public Integer getClientMode() {
        return this.clientMode;
    }

    @Generated
    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    @Generated
    public List<IPSubnetsVO> getUserRemoteSubnets() {
        return this.userRemoteSubnets;
    }

    @Generated
    public List<String> getServers() {
        return this.servers;
    }

    @Generated
    public String getLocalIp() {
        return this.localIp;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setProtocol(Integer protocol) {
        this.protocol = protocol;
    }

    @Generated
    public void setClientMode(Integer clientMode) {
        this.clientMode = clientMode;
    }

    @Generated
    public void setMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
    }

    @Generated
    public void setUserRemoteSubnets(List<IPSubnetsVO> userRemoteSubnets) {
        this.userRemoteSubnets = userRemoteSubnets;
    }

    @Generated
    public void setServers(List<String> servers) {
        this.servers = servers;
    }

    @Generated
    public void setLocalIp(String localIp) {
        this.localIp = localIp;
    }

    @Generated
    public String toString() {
        return "VpnUserRequestOpenApiV2VO(username=" + this.getUsername() + ", password=" + this.getPassword() + ", protocol=" + this.getProtocol() + ", clientMode=" + this.getClientMode() + ", maxConnections=" + this.getMaxConnections() + ", userRemoteSubnets=" + this.getUserRemoteSubnets() + ", servers=" + this.getServers() + ", localIp=" + this.getLocalIp() + ")";
    }

    @Generated
    public VpnUserRequestOpenApiV2VO(String username, String password, Integer protocol, Integer clientMode, Integer maxConnections, List<IPSubnetsVO> userRemoteSubnets, List<String> servers, String localIp) {
        this.username = username;
        this.password = password;
        this.protocol = protocol;
        this.clientMode = clientMode;
        this.maxConnections = maxConnections;
        this.userRemoteSubnets = userRemoteSubnets;
        this.servers = servers;
        this.localIp = localIp;
    }

    @Generated
    public VpnUserRequestOpenApiV2VO() {
    }
}

