/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.vpn.vpn;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.vpn.grid.VpnOpenApiGridVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.vpn.vpn.VpnCertificateOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.profile.dto.embed.IPSubnetsVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.vpn.VpnGridVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.vpn.dto.VpnVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

@Schema(name="VPN")
public class VpnOpenApiVO {
    @Schema(name="id", description="ID of the VPN.")
    private String id;
    @Schema(name="name", description="Name should contain 1 to 63 characters.")
    @NotNull(message="VPN name should not be null")
    @Pattern(regexp="^[a-zA-Z0-9_]{1,63}$", message="VPN name should be 1~63 visible ASCII characters, and its format can only contain letters, _,and numbers.")
    private @NotNull(message="VPN name should not be null") @Pattern(regexp="^[a-zA-Z0-9_]{1,63}$", message="VPN name should be 1~63 visible ASCII characters, and its format can only contain letters, _,and numbers.") String name;
    @Schema(name="purpose", description="Purpose of the VPN.")
    @NotNull(message="VPN purpose should not be null")
    @Range(min=0L, max=1L)
    private @NotNull(message="VPN purpose should not be null") @Range(min=0L, max=1L) Integer purpose;
    @Schema(name="siteVpnType", description="Site VPN type of the VPN.")
    private Integer siteVpnType;
    @Schema(name="status", description="Status of the VPN.")
    private Boolean status;
    @Schema(name="accountAuth", description="Account auth of the VPN, only for server OpenVPN.")
    private Boolean accountAuth;
    @Schema(name="existAccountAuth", description="Whether Account Auth is configured.")
    private Boolean existAccountAuth;
    @Schema(name="remoteSite", description="Remote site of the VPN.")
    private String remoteSite;
    @Length(max=253, message="This length should be no more than 253.")
    @Schema(name="remoteIp", description="Remote IP of the VPN.")
    private @Length(max=253, message="This length should be no more than 253.") String remoteIp;
    @Schema(name="existOpenVpnDomain", description="Whether Open VPN Client Remote Server is Domain Name.")
    private Boolean existOpenVpnDomain;
    @Schema(name="remoteSubnet", description="Remote subnet of the VPN, only for Manual IPSec type.")
    private List<IPSubnetsVO> remoteSubnet;
    @Schema(name="networkType", description="Network type should be a value as follows: 0: network list; 1: custom networks.")
    private Integer networkType;
    @Schema(name="networkList", description="Network list of the VPN, only for Manual IPSec type. Network can be created using 'Create LAN network' interface, and network ID can be obtained from 'Get LAN network list' interface.")
    private List<String> networkList;
    @Schema(name="customNetwork", description="Custom networks of the VPN, only for Manual IPSec type.")
    private List<IPSubnetsVO> customNetwork;
    @Schema(name="existCustomNetwork", description="Whether Local Network Type is Custom.")
    private Boolean existCustomNetwork;
    @Schema(name="preSharedKey", description="Pre-shared key of the VPN.")
    private String preSharedKey;
    @Schema(name="wans", description="WAN list of the VPN, only for Manual IPSec type. WAN port ID can be obtained from 'Get internet basic info' interface.")
    private List<String> wans;
    @Schema(name="clientVpnType1", description="Client to Site VPN : 0:VPN Server 1:VPN Client.")
    @NotNull(message="VPN client VPN type should not be null")
    private @NotNull(message="VPN client VPN type should not be null") Integer clientVpnType1;
    @Schema(name="clientVpnType2", description="Client Vpn type should be a value as follows: 0: L2TP; 1: PPTP; 2: IPSec; 3: OpenVPN.")
    @NotNull(message="VPN client VPN type should not be null")
    private @NotNull(message="VPN client VPN type should not be null") Integer clientVpnType2;
    @Schema(name="existL2TP", description="Whether current VPN is L2TP type.")
    private Boolean existL2TP;
    @Schema(name="existIPsec", description="Whether current VPN is IPsec type.")
    private Boolean existIPsec;
    @Schema(name="openVpnTunnelMode", description="OpenVPN tunnel mode should be a value as follows: 0: split; 1: full.")
    private Integer openVpnTunnelMode;
    @Schema(name="existTunnelMode", description="OpenVPN tunnel mode is Full.")
    private Boolean existTunnelMode;
    @Schema(name="openVpnMode", description="OpenVPN mode should be a value as follows: 0: certification; 1: certification+account.")
    private Integer openVpnMode;
    @Schema(name="serviceType", description="Service type of the VPN.")
    private Integer serviceType;
    @Schema(name="servicePort", description="Service port should be within the range of 1\u201365535.")
    @Range(min=1L, max=65535L, message="Service port should range between 1 and 65535.")
    private @Range(min=1L, max=65535L, message="Service port should range between 1 and 65535.") Integer servicePort;
    @Schema(name="encryption", description="Encryption should be a value as follows: 0: Encrypted; 1: Unencrypted.")
    private Integer encryption;
    @Schema(name="ipPoolType", description="IP pool type should be a value as follows: 0: Ip Address/Mask; 1: Ip Address Range.")
    private Integer ipPoolType;
    @Schema(name="existIpRange", description="Whether IP pool type is Ip Address Range.")
    private Boolean existIpRange;
    @Schema(name="ipPoolStart", description="The start IP of the IP pool.")
    @PII(strategy=PIIMaskStrategy.HASH)
    private String ipPoolStart;
    @Schema(name="ipPoolEnd", description="The end IP of the IP pool.")
    @PII(strategy=PIIMaskStrategy.HASH)
    private String ipPoolEnd;
    @Schema(name="ipPool", description="IP pool of the VPN.")
    @NotNull(message="VPN IP pool should not be null")
    private @NotNull(message="VPN IP pool should not be null") IPSubnetsVO ipPool;
    @Schema(name="primaryDns", description="Primary DNS of the VPN.")
    private String primaryDns;
    @Schema(name="secondaryDns", description="Secondary DNS of the VPN.")
    private String secondaryDns;
    @Schema(name="existCustomDns", description="Whether custom DNS Server has been configured in current VPN.")
    private Boolean existCustomDns;
    @Schema(name="authMode", description="Authentication mode should be a value as follows: 0: Local; 1: LDAP.")
    private Integer authMode;
    @Schema(name="ldapProfile", description="Ldap Profile.")
    private String ldapProfile;
    @Schema(name="existLdap", description="Whether Auth Mode is LDAP.")
    private Boolean existLdap;
    @Schema(name="existServerOpenVpnGoogleLdap", description="Whether Auth Mode is Google LDAP.")
    private Boolean existServerOpenVpnGoogleLdap;
    @Schema(name="workingMode", description="Working Mode should be a value as follow: 0:NAT 1:Routing.")
    private Integer workingMode;
    @Schema(name="clientUserName", description="Client username of the VPN.")
    @PII(strategy=PIIMaskStrategy.HASH)
    private String clientUsername;
    @Schema(name="clientPassword", description="Client password of the VPN.")
    @PII(strategy=PIIMaskStrategy.MASK)
    private String clientPassword;
    @Schema(name="vpnConfiguration", description="VPN configuration of the VPN")
    private VpnCertificateOpenApiVO vpnConfiguration;
    @Schema(name="existPfs", description="Whether current VPN has configured none-default option: dh14 or dh15")
    private Boolean existPfs;
    @Schema(name="existPhase1Proposal1", description="Whether current VPN has configured none-default Proposal option for IKE negotiation phase-1: SHA384 or SHA512.")
    private Boolean existPhase1Proposal1;
    @Schema(name="existPhase2Proposal2", description="Whether current VPN has configured none-default Proposal option for IKE negotiation phase-2: SHA384 or SHA512.")
    private Boolean existPhase2Proposal2;

    public static VpnOpenApiVO toOpenApiVO(VpnVO vo) {
        if (vo == null) {
            return new VpnOpenApiVO();
        }
        VpnOpenApiVO vpnOpenApiVO = new VpnOpenApiVO();
        vpnOpenApiVO.setId(vo.getId());
        vpnOpenApiVO.setName(vo.getName());
        vpnOpenApiVO.setPurpose(vo.getPurpose());
        vpnOpenApiVO.setSiteVpnType(vo.getSiteVpnType());
        vpnOpenApiVO.setStatus(vo.getStatus());
        vpnOpenApiVO.setAccountAuth(vo.getAccountAuth());
        vpnOpenApiVO.setRemoteSite(vo.getRemoteSite());
        vpnOpenApiVO.setRemoteIp(vo.getRemoteIp());
        vpnOpenApiVO.setRemoteSubnet(vo.getRemoteSubnet());
        vpnOpenApiVO.setNetworkType(vo.getNetworkType());
        vpnOpenApiVO.setNetworkList(vo.getNetworkList());
        vpnOpenApiVO.setCustomNetwork(vo.getCustomNetwork());
        vpnOpenApiVO.setPreSharedKey(vo.getPreSharedKey());
        vpnOpenApiVO.setWans(vo.getWans());
        vpnOpenApiVO.setClientVpnType1(vo.getClientVpnType1());
        vpnOpenApiVO.setClientVpnType2(vo.getClientVpnType2());
        vpnOpenApiVO.setOpenVpnTunnelMode(vo.getOpenVpnTunnelMode());
        vpnOpenApiVO.setOpenVpnMode(vo.getOpenVpnMode());
        vpnOpenApiVO.setServiceType(vo.getServiceType());
        vpnOpenApiVO.setServicePort(vo.getServicePort());
        vpnOpenApiVO.setEncryption(vo.getEncryption());
        vpnOpenApiVO.setIpPoolType(vo.getIpPoolType());
        vpnOpenApiVO.setIpPoolStart(vo.getIpPoolStart());
        vpnOpenApiVO.setIpPoolEnd(vo.getIpPoolEnd());
        vpnOpenApiVO.setIpPool(vo.getIpPool());
        vpnOpenApiVO.setPrimaryDns(vo.getDns1());
        vpnOpenApiVO.setSecondaryDns(vo.getDns2());
        vpnOpenApiVO.setAuthMode(vo.getAuthType());
        vpnOpenApiVO.setLdapProfile(vo.getLdapProfile());
        vpnOpenApiVO.setWorkingMode(vo.getWorkingMode());
        vpnOpenApiVO.setClientUsername(vo.getClientUserName());
        vpnOpenApiVO.setClientPassword(vo.getClientPassword());
        vpnOpenApiVO.setVpnConfiguration(VpnCertificateOpenApiVO.toOpenApiVO(vo.getVpnConfiguration()));
        vpnOpenApiVO.setExistOpenVpnDomain(vo.getExistOpenVpnDomain());
        vpnOpenApiVO.setExistAccountAuth(vo.getAccountAuth());
        vpnOpenApiVO.setExistCustomDns(vo.getExistCustomDns());
        vpnOpenApiVO.setExistPfs(vo.getExistPfs());
        vpnOpenApiVO.setExistIpRange(vo.getExistIpRange());
        vpnOpenApiVO.setExistIPsec(vo.getExistIPsec());
        vpnOpenApiVO.setExistL2TP(vo.getExistL2TP());
        vpnOpenApiVO.setExistLdap(vo.getExistLdap());
        vpnOpenApiVO.setExistServerOpenVpnGoogleLdap(vo.getExistOpenVpnDomain());
        vpnOpenApiVO.setExistPhase1Proposal1(vo.getExistPhase1Proposal1());
        vpnOpenApiVO.setExistPhase2Proposal2(vo.getExistPhase2Proposal2());
        vpnOpenApiVO.setExistTunnelMode(vo.getExistTunnelMode());
        vpnOpenApiVO.setExistCustomNetwork(vo.getExistCustomNetwork());
        return vpnOpenApiVO;
    }

    public VpnOpenApiVO(String id, String name, Integer purpose, Integer siteVpnType, Boolean status, Boolean accountAuth, String remoteSite, String remoteIp, List<IPSubnetsVO> remoteSubnet, Integer networkType, List<String> networkList, List<IPSubnetsVO> customNetwork, String preSharedKey, List<String> wans, Integer clientVpnType1, Integer clientVpnType2, Integer openVpnTunnelMode, Integer openVpnMode, Integer serviceType, Integer servicePort, Integer encryption, Integer ipPoolType, String ipPoolStart, String ipPoolEnd, IPSubnetsVO ipPool, String primaryDns, String secondaryDns, Integer authMode, String ldapProfile, Integer workingMode, String clientUsername, String clientPassword, VpnCertificateOpenApiVO vpnConfiguration, Boolean existOpenVpnDomain, Boolean existAccountAuth, Boolean existCustomDns, Boolean existPfs, Boolean existIpRange, Boolean existIPsec, Boolean existL2TP, Boolean existLdap, Boolean existServerOpenVpnGoogleLdap, Boolean existPhase1Proposal1, Boolean existPhase2Proposal2, Boolean existTunnelMode, Boolean existCustomNetwork) {
        this.id = id;
        this.name = name;
        this.purpose = purpose;
        this.siteVpnType = siteVpnType;
        this.status = status;
        this.accountAuth = accountAuth;
        this.remoteSite = remoteSite;
        this.remoteIp = remoteIp;
        this.remoteSubnet = remoteSubnet;
        this.networkType = networkType;
        this.networkList = networkList;
        this.customNetwork = customNetwork;
        this.preSharedKey = preSharedKey;
        this.wans = wans;
        this.clientVpnType1 = clientVpnType1;
        this.clientVpnType2 = clientVpnType2;
        this.openVpnTunnelMode = openVpnTunnelMode;
        this.openVpnMode = openVpnMode;
        this.serviceType = serviceType;
        this.servicePort = servicePort;
        this.encryption = encryption;
        this.ipPoolType = ipPoolType;
        this.ipPoolStart = ipPoolStart;
        this.ipPoolEnd = ipPoolEnd;
        this.ipPool = ipPool;
        this.primaryDns = primaryDns;
        this.secondaryDns = secondaryDns;
        this.authMode = authMode;
        this.ldapProfile = ldapProfile;
        this.workingMode = workingMode;
        this.clientUsername = clientUsername;
        this.clientPassword = clientPassword;
        this.vpnConfiguration = vpnConfiguration;
        this.existOpenVpnDomain = existOpenVpnDomain;
        this.existAccountAuth = existAccountAuth;
        this.existCustomDns = existCustomDns;
        this.existPfs = existPfs;
        this.existIpRange = existIpRange;
        this.existIPsec = existIPsec;
        this.existL2TP = existL2TP;
        this.existLdap = existLdap;
        this.existServerOpenVpnGoogleLdap = existServerOpenVpnGoogleLdap;
        this.existPhase1Proposal1 = existPhase1Proposal1;
        this.existPhase2Proposal2 = existPhase2Proposal2;
        this.existTunnelMode = existTunnelMode;
        this.existCustomNetwork = existCustomNetwork;
    }

    public static List<VpnOpenApiVO> toOpenApiListVO(@Nonnull List<VpnVO> voList) {
        return voList.stream().map(VpnOpenApiVO::toOpenApiVO).collect(Collectors.toList());
    }

    public static VpnOpenApiGridVO<VpnOpenApiVO> toOpenApiGridVO(@Nonnull VpnGridVO<VpnVO> gridVO) {
        VpnOpenApiGridVO<VpnOpenApiVO> openApiVpnGridVO = new VpnOpenApiGridVO<VpnOpenApiVO>();
        openApiVpnGridVO.setTotalRows(gridVO.getTotalRows());
        openApiVpnGridVO.setCurrentPage(gridVO.getCurrentPage());
        openApiVpnGridVO.setCurrentSize(gridVO.getCurrentSize());
        openApiVpnGridVO.setSupportVpnUserTab(gridVO.getSupportVpnUserTab());
        openApiVpnGridVO.setSupportCustomDns(gridVO.getSupportCustomDns());
        openApiVpnGridVO.setSupportIpRange(gridVO.getSupportIpRange());
        openApiVpnGridVO.setSupportAccountAuth(gridVO.getSupportAccountAuth());
        openApiVpnGridVO.setSupportCustomNetwork(gridVO.getSupportCustomNetwork());
        openApiVpnGridVO.setSupportTunnelMode(gridVO.getSupportTunnelMode());
        openApiVpnGridVO.setSupportLdap(gridVO.getSupportLdap());
        openApiVpnGridVO.setSupportIPsec(gridVO.getSupportIPsec());
        openApiVpnGridVO.setSupportL2TP(gridVO.getSupportL2TP());
        openApiVpnGridVO.setPfsCap(gridVO.getPfsCap());
        openApiVpnGridVO.setSupportOpenVpnDomain(gridVO.getSupportOpenVpnDomain());
        openApiVpnGridVO.setSupportIpSNat(gridVO.getSupportIpSNat());
        openApiVpnGridVO.setPhase1Proposal1Cap(gridVO.getPhase1Proposal1Cap());
        openApiVpnGridVO.setPhase2Proposal2Cap(gridVO.getPhase2Proposal2Cap());
        openApiVpnGridVO.setData(gridVO.getData().stream().map(VpnOpenApiVO::toOpenApiVO).collect(Collectors.toList()));
        return openApiVpnGridVO;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getPurpose() {
        return this.purpose;
    }

    @Generated
    public Integer getSiteVpnType() {
        return this.siteVpnType;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public Boolean getAccountAuth() {
        return this.accountAuth;
    }

    @Generated
    public Boolean getExistAccountAuth() {
        return this.existAccountAuth;
    }

    @Generated
    public String getRemoteSite() {
        return this.remoteSite;
    }

    @Generated
    public String getRemoteIp() {
        return this.remoteIp;
    }

    @Generated
    public Boolean getExistOpenVpnDomain() {
        return this.existOpenVpnDomain;
    }

    @Generated
    public List<IPSubnetsVO> getRemoteSubnet() {
        return this.remoteSubnet;
    }

    @Generated
    public Integer getNetworkType() {
        return this.networkType;
    }

    @Generated
    public List<String> getNetworkList() {
        return this.networkList;
    }

    @Generated
    public List<IPSubnetsVO> getCustomNetwork() {
        return this.customNetwork;
    }

    @Generated
    public Boolean getExistCustomNetwork() {
        return this.existCustomNetwork;
    }

    @Generated
    public String getPreSharedKey() {
        return this.preSharedKey;
    }

    @Generated
    public List<String> getWans() {
        return this.wans;
    }

    @Generated
    public Integer getClientVpnType1() {
        return this.clientVpnType1;
    }

    @Generated
    public Integer getClientVpnType2() {
        return this.clientVpnType2;
    }

    @Generated
    public Boolean getExistL2TP() {
        return this.existL2TP;
    }

    @Generated
    public Boolean getExistIPsec() {
        return this.existIPsec;
    }

    @Generated
    public Integer getOpenVpnTunnelMode() {
        return this.openVpnTunnelMode;
    }

    @Generated
    public Boolean getExistTunnelMode() {
        return this.existTunnelMode;
    }

    @Generated
    public Integer getOpenVpnMode() {
        return this.openVpnMode;
    }

    @Generated
    public Integer getServiceType() {
        return this.serviceType;
    }

    @Generated
    public Integer getServicePort() {
        return this.servicePort;
    }

    @Generated
    public Integer getEncryption() {
        return this.encryption;
    }

    @Generated
    public Integer getIpPoolType() {
        return this.ipPoolType;
    }

    @Generated
    public Boolean getExistIpRange() {
        return this.existIpRange;
    }

    @Generated
    public String getIpPoolStart() {
        return this.ipPoolStart;
    }

    @Generated
    public String getIpPoolEnd() {
        return this.ipPoolEnd;
    }

    @Generated
    public IPSubnetsVO getIpPool() {
        return this.ipPool;
    }

    @Generated
    public String getPrimaryDns() {
        return this.primaryDns;
    }

    @Generated
    public String getSecondaryDns() {
        return this.secondaryDns;
    }

    @Generated
    public Boolean getExistCustomDns() {
        return this.existCustomDns;
    }

    @Generated
    public Integer getAuthMode() {
        return this.authMode;
    }

    @Generated
    public String getLdapProfile() {
        return this.ldapProfile;
    }

    @Generated
    public Boolean getExistLdap() {
        return this.existLdap;
    }

    @Generated
    public Boolean getExistServerOpenVpnGoogleLdap() {
        return this.existServerOpenVpnGoogleLdap;
    }

    @Generated
    public Integer getWorkingMode() {
        return this.workingMode;
    }

    @Generated
    public String getClientUsername() {
        return this.clientUsername;
    }

    @Generated
    public String getClientPassword() {
        return this.clientPassword;
    }

    @Generated
    public VpnCertificateOpenApiVO getVpnConfiguration() {
        return this.vpnConfiguration;
    }

    @Generated
    public Boolean getExistPfs() {
        return this.existPfs;
    }

    @Generated
    public Boolean getExistPhase1Proposal1() {
        return this.existPhase1Proposal1;
    }

    @Generated
    public Boolean getExistPhase2Proposal2() {
        return this.existPhase2Proposal2;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setPurpose(Integer purpose) {
        this.purpose = purpose;
    }

    @Generated
    public void setSiteVpnType(Integer siteVpnType) {
        this.siteVpnType = siteVpnType;
    }

    @Generated
    public void setStatus(Boolean status) {
        this.status = status;
    }

    @Generated
    public void setAccountAuth(Boolean accountAuth) {
        this.accountAuth = accountAuth;
    }

    @Generated
    public void setExistAccountAuth(Boolean existAccountAuth) {
        this.existAccountAuth = existAccountAuth;
    }

    @Generated
    public void setRemoteSite(String remoteSite) {
        this.remoteSite = remoteSite;
    }

    @Generated
    public void setRemoteIp(String remoteIp) {
        this.remoteIp = remoteIp;
    }

    @Generated
    public void setExistOpenVpnDomain(Boolean existOpenVpnDomain) {
        this.existOpenVpnDomain = existOpenVpnDomain;
    }

    @Generated
    public void setRemoteSubnet(List<IPSubnetsVO> remoteSubnet) {
        this.remoteSubnet = remoteSubnet;
    }

    @Generated
    public void setNetworkType(Integer networkType) {
        this.networkType = networkType;
    }

    @Generated
    public void setNetworkList(List<String> networkList) {
        this.networkList = networkList;
    }

    @Generated
    public void setCustomNetwork(List<IPSubnetsVO> customNetwork) {
        this.customNetwork = customNetwork;
    }

    @Generated
    public void setExistCustomNetwork(Boolean existCustomNetwork) {
        this.existCustomNetwork = existCustomNetwork;
    }

    @Generated
    public void setPreSharedKey(String preSharedKey) {
        this.preSharedKey = preSharedKey;
    }

    @Generated
    public void setWans(List<String> wans) {
        this.wans = wans;
    }

    @Generated
    public void setClientVpnType1(Integer clientVpnType1) {
        this.clientVpnType1 = clientVpnType1;
    }

    @Generated
    public void setClientVpnType2(Integer clientVpnType2) {
        this.clientVpnType2 = clientVpnType2;
    }

    @Generated
    public void setExistL2TP(Boolean existL2TP) {
        this.existL2TP = existL2TP;
    }

    @Generated
    public void setExistIPsec(Boolean existIPsec) {
        this.existIPsec = existIPsec;
    }

    @Generated
    public void setOpenVpnTunnelMode(Integer openVpnTunnelMode) {
        this.openVpnTunnelMode = openVpnTunnelMode;
    }

    @Generated
    public void setExistTunnelMode(Boolean existTunnelMode) {
        this.existTunnelMode = existTunnelMode;
    }

    @Generated
    public void setOpenVpnMode(Integer openVpnMode) {
        this.openVpnMode = openVpnMode;
    }

    @Generated
    public void setServiceType(Integer serviceType) {
        this.serviceType = serviceType;
    }

    @Generated
    public void setServicePort(Integer servicePort) {
        this.servicePort = servicePort;
    }

    @Generated
    public void setEncryption(Integer encryption) {
        this.encryption = encryption;
    }

    @Generated
    public void setIpPoolType(Integer ipPoolType) {
        this.ipPoolType = ipPoolType;
    }

    @Generated
    public void setExistIpRange(Boolean existIpRange) {
        this.existIpRange = existIpRange;
    }

    @Generated
    public void setIpPoolStart(String ipPoolStart) {
        this.ipPoolStart = ipPoolStart;
    }

    @Generated
    public void setIpPoolEnd(String ipPoolEnd) {
        this.ipPoolEnd = ipPoolEnd;
    }

    @Generated
    public void setIpPool(IPSubnetsVO ipPool) {
        this.ipPool = ipPool;
    }

    @Generated
    public void setPrimaryDns(String primaryDns) {
        this.primaryDns = primaryDns;
    }

    @Generated
    public void setSecondaryDns(String secondaryDns) {
        this.secondaryDns = secondaryDns;
    }

    @Generated
    public void setExistCustomDns(Boolean existCustomDns) {
        this.existCustomDns = existCustomDns;
    }

    @Generated
    public void setAuthMode(Integer authMode) {
        this.authMode = authMode;
    }

    @Generated
    public void setLdapProfile(String ldapProfile) {
        this.ldapProfile = ldapProfile;
    }

    @Generated
    public void setExistLdap(Boolean existLdap) {
        this.existLdap = existLdap;
    }

    @Generated
    public void setExistServerOpenVpnGoogleLdap(Boolean existServerOpenVpnGoogleLdap) {
        this.existServerOpenVpnGoogleLdap = existServerOpenVpnGoogleLdap;
    }

    @Generated
    public void setWorkingMode(Integer workingMode) {
        this.workingMode = workingMode;
    }

    @Generated
    public void setClientUsername(String clientUsername) {
        this.clientUsername = clientUsername;
    }

    @Generated
    public void setClientPassword(String clientPassword) {
        this.clientPassword = clientPassword;
    }

    @Generated
    public void setVpnConfiguration(VpnCertificateOpenApiVO vpnConfiguration) {
        this.vpnConfiguration = vpnConfiguration;
    }

    @Generated
    public void setExistPfs(Boolean existPfs) {
        this.existPfs = existPfs;
    }

    @Generated
    public void setExistPhase1Proposal1(Boolean existPhase1Proposal1) {
        this.existPhase1Proposal1 = existPhase1Proposal1;
    }

    @Generated
    public void setExistPhase2Proposal2(Boolean existPhase2Proposal2) {
        this.existPhase2Proposal2 = existPhase2Proposal2;
    }

    @Generated
    public String toString() {
        return "VpnOpenApiVO(id=" + this.getId() + ", name=" + this.getName() + ", purpose=" + this.getPurpose() + ", siteVpnType=" + this.getSiteVpnType() + ", status=" + this.getStatus() + ", accountAuth=" + this.getAccountAuth() + ", existAccountAuth=" + this.getExistAccountAuth() + ", remoteSite=" + this.getRemoteSite() + ", remoteIp=" + this.getRemoteIp() + ", existOpenVpnDomain=" + this.getExistOpenVpnDomain() + ", remoteSubnet=" + this.getRemoteSubnet() + ", networkType=" + this.getNetworkType() + ", networkList=" + this.getNetworkList() + ", customNetwork=" + this.getCustomNetwork() + ", existCustomNetwork=" + this.getExistCustomNetwork() + ", preSharedKey=" + this.getPreSharedKey() + ", wans=" + this.getWans() + ", clientVpnType1=" + this.getClientVpnType1() + ", clientVpnType2=" + this.getClientVpnType2() + ", existL2TP=" + this.getExistL2TP() + ", existIPsec=" + this.getExistIPsec() + ", openVpnTunnelMode=" + this.getOpenVpnTunnelMode() + ", existTunnelMode=" + this.getExistTunnelMode() + ", openVpnMode=" + this.getOpenVpnMode() + ", serviceType=" + this.getServiceType() + ", servicePort=" + this.getServicePort() + ", encryption=" + this.getEncryption() + ", ipPoolType=" + this.getIpPoolType() + ", existIpRange=" + this.getExistIpRange() + ", ipPoolStart=" + this.getIpPoolStart() + ", ipPoolEnd=" + this.getIpPoolEnd() + ", ipPool=" + this.getIpPool() + ", primaryDns=" + this.getPrimaryDns() + ", secondaryDns=" + this.getSecondaryDns() + ", existCustomDns=" + this.getExistCustomDns() + ", authMode=" + this.getAuthMode() + ", ldapProfile=" + this.getLdapProfile() + ", existLdap=" + this.getExistLdap() + ", existServerOpenVpnGoogleLdap=" + this.getExistServerOpenVpnGoogleLdap() + ", workingMode=" + this.getWorkingMode() + ", clientUsername=" + this.getClientUsername() + ", clientPassword=" + this.getClientPassword() + ", vpnConfiguration=" + this.getVpnConfiguration() + ", existPfs=" + this.getExistPfs() + ", existPhase1Proposal1=" + this.getExistPhase1Proposal1() + ", existPhase2Proposal2=" + this.getExistPhase2Proposal2() + ")";
    }

    @Generated
    public VpnOpenApiVO(String id, String name, Integer purpose, Integer siteVpnType, Boolean status, Boolean accountAuth, Boolean existAccountAuth, String remoteSite, String remoteIp, Boolean existOpenVpnDomain, List<IPSubnetsVO> remoteSubnet, Integer networkType, List<String> networkList, List<IPSubnetsVO> customNetwork, Boolean existCustomNetwork, String preSharedKey, List<String> wans, Integer clientVpnType1, Integer clientVpnType2, Boolean existL2TP, Boolean existIPsec, Integer openVpnTunnelMode, Boolean existTunnelMode, Integer openVpnMode, Integer serviceType, Integer servicePort, Integer encryption, Integer ipPoolType, Boolean existIpRange, String ipPoolStart, String ipPoolEnd, IPSubnetsVO ipPool, String primaryDns, String secondaryDns, Boolean existCustomDns, Integer authMode, String ldapProfile, Boolean existLdap, Boolean existServerOpenVpnGoogleLdap, Integer workingMode, String clientUsername, String clientPassword, VpnCertificateOpenApiVO vpnConfiguration, Boolean existPfs, Boolean existPhase1Proposal1, Boolean existPhase2Proposal2) {
        this.id = id;
        this.name = name;
        this.purpose = purpose;
        this.siteVpnType = siteVpnType;
        this.status = status;
        this.accountAuth = accountAuth;
        this.existAccountAuth = existAccountAuth;
        this.remoteSite = remoteSite;
        this.remoteIp = remoteIp;
        this.existOpenVpnDomain = existOpenVpnDomain;
        this.remoteSubnet = remoteSubnet;
        this.networkType = networkType;
        this.networkList = networkList;
        this.customNetwork = customNetwork;
        this.existCustomNetwork = existCustomNetwork;
        this.preSharedKey = preSharedKey;
        this.wans = wans;
        this.clientVpnType1 = clientVpnType1;
        this.clientVpnType2 = clientVpnType2;
        this.existL2TP = existL2TP;
        this.existIPsec = existIPsec;
        this.openVpnTunnelMode = openVpnTunnelMode;
        this.existTunnelMode = existTunnelMode;
        this.openVpnMode = openVpnMode;
        this.serviceType = serviceType;
        this.servicePort = servicePort;
        this.encryption = encryption;
        this.ipPoolType = ipPoolType;
        this.existIpRange = existIpRange;
        this.ipPoolStart = ipPoolStart;
        this.ipPoolEnd = ipPoolEnd;
        this.ipPool = ipPool;
        this.primaryDns = primaryDns;
        this.secondaryDns = secondaryDns;
        this.existCustomDns = existCustomDns;
        this.authMode = authMode;
        this.ldapProfile = ldapProfile;
        this.existLdap = existLdap;
        this.existServerOpenVpnGoogleLdap = existServerOpenVpnGoogleLdap;
        this.workingMode = workingMode;
        this.clientUsername = clientUsername;
        this.clientPassword = clientPassword;
        this.vpnConfiguration = vpnConfiguration;
        this.existPfs = existPfs;
        this.existPhase1Proposal1 = existPhase1Proposal1;
        this.existPhase2Proposal2 = existPhase2Proposal2;
    }

    @Generated
    public VpnOpenApiVO() {
    }
}

