/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.vpn.vpn;

import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.vpn.vpn.VpnAdvancedSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.profile.dto.embed.IPSubnetsVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.vpn.dto.VpnVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;

@Schema(name="SiteToSiteVpn")
public class SiteToSiteVpnOpenApiVO {
    @Schema(name="id", description="ID of the VPN.")
    private String id;
    @Schema(name="name", description="Name should contain 1 to 63 characters.")
    @NotNull(message="VPN name should not be null")
    @Pattern(regexp="^[a-zA-Z0-9_]{1,63}$", message="VPN name should be 1~63 visible ASCII characters, and its format can only contain letters, _,and numbers.")
    private @NotNull(message="VPN name should not be null") @Pattern(regexp="^[a-zA-Z0-9_]{1,63}$", message="VPN name should be 1~63 visible ASCII characters, and its format can only contain letters, _,and numbers.") String name;
    @Schema(name="siteVpnType", description="Site VPN type should be a value as follows: 0: Auto IPSec; 1: Manual IPSec.")
    @NotNull(message="VPN siteVpnType should not be null")
    private @NotNull(message="VPN siteVpnType should not be null") Integer siteVpnType;
    @Schema(name="status", description="Status of the VPN.")
    @NotNull(message="VPN status should not be null")
    private @NotNull(message="VPN status should not be null") Boolean status;
    @Schema(name="remoteSite", description="Remote site of the VPN, only for Auto IPSec type.")
    private String remoteSite;
    @Length(max=253, message="This length should be no more than 253.")
    @Schema(name="remoteIp", description="Remote IP of the VPN, only for Manual IPSec type.")
    private @Length(max=253, message="This length should be no more than 253.") String remoteIp;
    @Schema(name="remoteSubnet", description="Remote subnet of the VPN, only for Manual IPSec type.")
    private List<IPSubnetsVO> remoteSubnet;
    @Schema(name="networkType", description="Network type should be a value as follows: 0: network list; 1: custom networks.")
    private Integer networkType;
    @Schema(name="networkList", description="Network list of the VPN, only for Manual IPSec type. Network can be created using 'Create LAN network' interface, and network ID can be obtained from 'Get LAN network list' interface.")
    private List<String> networkList;
    @Schema(name="customNetwork", description="Custom networks of the VPN, only for Manual IPSec type.")
    private List<IPSubnetsVO> customNetwork;
    @Schema(name="preSharedKey", description="Pre-shared key of the VPN, only for Manual IPSec type.")
    private String preSharedKey;
    @Schema(name="wan", description="WAN list of the VPN, only for Manual IPSec type. WAN port ID can be obtained from 'Get internet basic info' interface.")
    private List<String> wan;
    @Schema(name="advancedSetting", description="Advanced setting list of the VPN, only for Manual IPSec type.")
    private VpnAdvancedSettingOpenApiVO advancedSetting;

    public static SiteToSiteVpnOpenApiVO toOpenApiVO(VpnVO vo) {
        if (vo == null) {
            return new SiteToSiteVpnOpenApiVO();
        }
        SiteToSiteVpnOpenApiVO openApiVO = new SiteToSiteVpnOpenApiVO();
        openApiVO.setId(vo.getId());
        openApiVO.setName(vo.getName());
        openApiVO.setSiteVpnType(vo.getSiteVpnType());
        openApiVO.setStatus(vo.getStatus());
        openApiVO.setRemoteSite(vo.getRemoteSite());
        openApiVO.setRemoteIp(vo.getRemoteIp());
        openApiVO.setRemoteSubnet(vo.getRemoteSubnet());
        openApiVO.setNetworkType(vo.getNetworkType());
        openApiVO.setNetworkList(vo.getNetworkList());
        openApiVO.setCustomNetwork(vo.getCustomNetwork());
        openApiVO.setPreSharedKey(vo.getPreSharedKey());
        openApiVO.setWan(vo.getWans());
        if (vo.getVpnAdvancedSetting() != null) {
            openApiVO.setAdvancedSetting(VpnAdvancedSettingOpenApiVO.toOpenApiVO(vo.getVpnAdvancedSetting()));
        }
        return openApiVO;
    }

    public static List<SiteToSiteVpnOpenApiVO> toOpenApiListVO(@Nonnull List<VpnVO> voList) {
        return voList.stream().map(SiteToSiteVpnOpenApiVO::toOpenApiVO).collect(Collectors.toList());
    }

    public static VpnVO toVO(SiteToSiteVpnOpenApiVO openApiVO) {
        VpnVO vo = new VpnVO();
        vo.setId(openApiVO.getId());
        vo.setName(openApiVO.getName());
        vo.setSiteVpnType(openApiVO.getSiteVpnType());
        vo.setStatus(openApiVO.getStatus());
        vo.setRemoteSite(openApiVO.getRemoteSite());
        vo.setRemoteIp(openApiVO.getRemoteIp());
        vo.setRemoteSubnet(openApiVO.getRemoteSubnet());
        vo.setNetworkType(openApiVO.getNetworkType());
        vo.setNetworkList(openApiVO.getNetworkList());
        vo.setCustomNetwork(openApiVO.getCustomNetwork());
        vo.setPreSharedKey(openApiVO.getPreSharedKey());
        vo.setWans(openApiVO.getWan());
        if (openApiVO.getAdvancedSetting() != null) {
            vo.setVpnAdvancedSetting(VpnAdvancedSettingOpenApiVO.toVO(openApiVO.getAdvancedSetting()));
        }
        return vo;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getSiteVpnType() {
        return this.siteVpnType;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public String getRemoteSite() {
        return this.remoteSite;
    }

    @Generated
    public String getRemoteIp() {
        return this.remoteIp;
    }

    @Generated
    public List<IPSubnetsVO> getRemoteSubnet() {
        return this.remoteSubnet;
    }

    @Generated
    public Integer getNetworkType() {
        return this.networkType;
    }

    @Generated
    public List<String> getNetworkList() {
        return this.networkList;
    }

    @Generated
    public List<IPSubnetsVO> getCustomNetwork() {
        return this.customNetwork;
    }

    @Generated
    public String getPreSharedKey() {
        return this.preSharedKey;
    }

    @Generated
    public List<String> getWan() {
        return this.wan;
    }

    @Generated
    public VpnAdvancedSettingOpenApiVO getAdvancedSetting() {
        return this.advancedSetting;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setSiteVpnType(Integer siteVpnType) {
        this.siteVpnType = siteVpnType;
    }

    @Generated
    public void setStatus(Boolean status) {
        this.status = status;
    }

    @Generated
    public void setRemoteSite(String remoteSite) {
        this.remoteSite = remoteSite;
    }

    @Generated
    public void setRemoteIp(String remoteIp) {
        this.remoteIp = remoteIp;
    }

    @Generated
    public void setRemoteSubnet(List<IPSubnetsVO> remoteSubnet) {
        this.remoteSubnet = remoteSubnet;
    }

    @Generated
    public void setNetworkType(Integer networkType) {
        this.networkType = networkType;
    }

    @Generated
    public void setNetworkList(List<String> networkList) {
        this.networkList = networkList;
    }

    @Generated
    public void setCustomNetwork(List<IPSubnetsVO> customNetwork) {
        this.customNetwork = customNetwork;
    }

    @Generated
    public void setPreSharedKey(String preSharedKey) {
        this.preSharedKey = preSharedKey;
    }

    @Generated
    public void setWan(List<String> wan) {
        this.wan = wan;
    }

    @Generated
    public void setAdvancedSetting(VpnAdvancedSettingOpenApiVO advancedSetting) {
        this.advancedSetting = advancedSetting;
    }

    @Generated
    public String toString() {
        return "SiteToSiteVpnOpenApiVO(id=" + this.getId() + ", name=" + this.getName() + ", siteVpnType=" + this.getSiteVpnType() + ", status=" + this.getStatus() + ", remoteSite=" + this.getRemoteSite() + ", remoteIp=" + this.getRemoteIp() + ", remoteSubnet=" + this.getRemoteSubnet() + ", networkType=" + this.getNetworkType() + ", networkList=" + this.getNetworkList() + ", customNetwork=" + this.getCustomNetwork() + ", preSharedKey=" + this.getPreSharedKey() + ", wan=" + this.getWan() + ", advancedSetting=" + this.getAdvancedSetting() + ")";
    }

    @Generated
    public SiteToSiteVpnOpenApiVO(String id, String name, Integer siteVpnType, Boolean status, String remoteSite, String remoteIp, List<IPSubnetsVO> remoteSubnet, Integer networkType, List<String> networkList, List<IPSubnetsVO> customNetwork, String preSharedKey, List<String> wan, VpnAdvancedSettingOpenApiVO advancedSetting) {
        this.id = id;
        this.name = name;
        this.siteVpnType = siteVpnType;
        this.status = status;
        this.remoteSite = remoteSite;
        this.remoteIp = remoteIp;
        this.remoteSubnet = remoteSubnet;
        this.networkType = networkType;
        this.networkList = networkList;
        this.customNetwork = customNetwork;
        this.preSharedKey = preSharedKey;
        this.wan = wan;
        this.advancedSetting = advancedSetting;
    }

    @Generated
    public SiteToSiteVpnOpenApiVO() {
    }
}

