/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.vpn.vpn;

import com.tplink.smb.omada.manager.configuration.api.web.site.vpn.dto.IPsecFailoverDetailVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="IPsecFailover")
public class IPsecFailoverDetailOpenApiVO {
    @Schema(name="id", description="ID of the IPSec failover.")
    private String id;
    @Schema(name="name", description="Name should contain 1 to 64 characters.")
    @NotNull(message="IPsec failover name should not be null")
    @Pattern(regexp="^[\\041-\\0176]$|^[\\041-\\0176][\\040-\\0176]{0,62}[\\041-\\0176]$", message="Parameter [name] should be 1~64 visible ASCII characters.")
    private @NotNull(message="IPsec failover name should not be null") @Pattern(regexp="^[\\041-\\0176]$|^[\\041-\\0176][\\040-\\0176]{0,62}[\\041-\\0176]$", message="Parameter [name] should be 1~64 visible ASCII characters.") String name;
    @Schema(name="primary", description="Primary of the IPSec failover. IPsec VPN can be created using 'Create site-to-site VPN' interface, and ID can be obtained from 'Get site-to-site VPN list' interface.")
    @NotNull(message="IPsec failover primary id should not be null")
    private @NotNull(message="IPsec failover primary id should not be null") String primary;
    @Schema(name="candidates", description="Candidates of the IPSec failover. IPsec VPN can be created using 'Create site-to-site VPN' interface, and ID can be obtained from 'Get site-to-site VPN list' interface.")
    @NotNull(message="IPsec failover candidates should not be null")
    private @NotNull(message="IPsec failover candidates should not be null") List<String> candidates;
    @Schema(name="failback", description="Failback of the IPSec failover.")
    private Boolean failback;
    @Schema(name="failbackTime", description="Failback time should be within the range of 10\u20133600s.")
    @Range(min=10L, max=3600L, message=" Auto failback should range between 10 and 3600")
    private @Range(min=10L, max=3600L, message=" Auto failback should range between 10 and 3600") Integer failbackTime;

    public static IPsecFailoverDetailOpenApiVO toOpenApiVO(@Nonnull IPsecFailoverDetailVO vo) {
        IPsecFailoverDetailOpenApiVO iPsecFailoverDetailOpenApiVO = new IPsecFailoverDetailOpenApiVO();
        iPsecFailoverDetailOpenApiVO.setId(vo.getId());
        iPsecFailoverDetailOpenApiVO.setName(vo.getName());
        iPsecFailoverDetailOpenApiVO.setPrimary(vo.getPrimary());
        iPsecFailoverDetailOpenApiVO.setCandidates(vo.getCandidates());
        iPsecFailoverDetailOpenApiVO.setFailback(vo.getFailback());
        iPsecFailoverDetailOpenApiVO.setFailbackTime(vo.getFailbackTime());
        return iPsecFailoverDetailOpenApiVO;
    }

    public static IPsecFailoverDetailVO toVO(IPsecFailoverDetailOpenApiVO openApiVO) {
        IPsecFailoverDetailVO vo = new IPsecFailoverDetailVO();
        vo.setId(openApiVO.getId());
        vo.setName(openApiVO.getName());
        vo.setPrimary(openApiVO.getPrimary());
        vo.setCandidates(openApiVO.getCandidates());
        vo.setFailback(openApiVO.getFailback());
        vo.setFailbackTime(openApiVO.getFailbackTime());
        return vo;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getPrimary() {
        return this.primary;
    }

    @Generated
    public List<String> getCandidates() {
        return this.candidates;
    }

    @Generated
    public Boolean getFailback() {
        return this.failback;
    }

    @Generated
    public Integer getFailbackTime() {
        return this.failbackTime;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setPrimary(String primary) {
        this.primary = primary;
    }

    @Generated
    public void setCandidates(List<String> candidates) {
        this.candidates = candidates;
    }

    @Generated
    public void setFailback(Boolean failback) {
        this.failback = failback;
    }

    @Generated
    public void setFailbackTime(Integer failbackTime) {
        this.failbackTime = failbackTime;
    }

    @Generated
    public String toString() {
        return "IPsecFailoverDetailOpenApiVO(id=" + this.getId() + ", name=" + this.getName() + ", primary=" + this.getPrimary() + ", candidates=" + this.getCandidates() + ", failback=" + this.getFailback() + ", failbackTime=" + this.getFailbackTime() + ")";
    }

    @Generated
    public IPsecFailoverDetailOpenApiVO(String id, String name, String primary, List<String> candidates, Boolean failback, Integer failbackTime) {
        this.id = id;
        this.name = name;
        this.primary = primary;
        this.candidates = candidates;
        this.failback = failback;
        this.failbackTime = failbackTime;
    }

    @Generated
    public IPsecFailoverDetailOpenApiVO() {
    }
}

