/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.vpn.vpn;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.vpn.vpn.VpnAdvancedSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.profile.dto.embed.IPSubnetsVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.vpn.dto.VpnVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

@Schema(name="ClientToSiteVpnServer")
public class ClientToSiteVpnServerOpenApiVO {
    @Schema(name="id", description="ID of the VPN.")
    private String id;
    @Schema(name="name", description="Name should contain 1 to 63 characters.")
    @NotNull(message="VPN name should not be null")
    @Pattern(regexp="^[a-zA-Z0-9_]{1,63}$", message="VPN name should be 1~63 visible ASCII characters, and its format can only contain letters, _,and numbers.")
    private @NotNull(message="VPN name should not be null") @Pattern(regexp="^[a-zA-Z0-9_]{1,63}$", message="VPN name should be 1~63 visible ASCII characters, and its format can only contain letters, _,and numbers.") String name;
    @Schema(name="status", description="Status of the VPN.")
    private Boolean status;
    @Schema(name="accountPassword", description="Account password of the VPN, only for server OpenVPN.")
    private Boolean accountPassword;
    @Schema(name="tunnelMode", description="Tunnel mode(only for server OpenVPN)should be a value as follows: 0: split; 1: full.")
    private Integer tunnelMode;
    @Schema(name="openVpnMode", description="OpenVPN mode should be a value as follows: 0: certification; 1: certification+account.")
    private Integer openVpnMode;
    @Length(max=253, message="This length should be no more than 253.")
    @Schema(name="remoteIp", description="Remote IP of the VPN")
    @PII(strategy=PIIMaskStrategy.HASH)
    private @Length(max=253, message="This length should be no more than 253.") String remoteIp;
    @Schema(name="networkType", description="Network type should be a value as follows: 0: network list; 1: custom networks.")
    private Integer networkType;
    @Schema(name="networkList", description="Network list of the VPN. Network can be created using 'Create LAN network' interface, and network ID can be obtained from 'Get LAN network list' interface.")
    private List<String> networkList;
    @Schema(name="customNetwork", description="Custom networks of the VPN.")
    private List<IPSubnetsVO> customNetwork;
    @Schema(name="preSharedKey", description="Pre-shared key of the VPN.")
    private String preSharedKey;
    @Schema(name="wan", description="WAN list of the VPN. WAN port ID can be obtained from 'Get internet basic info' interface.")
    @NotNull(message="VPN WAN should not be null")
    private @NotNull(message="VPN WAN should not be null") List<String> wan;
    @Schema(name="clientVpnType", description="Client Vpn type should be a value as follows: 0: L2TP; 1: PPTP; 2: IPSec; 3: OpenVPN.")
    @NotNull(message="VPN client VPN type should not be null")
    private @NotNull(message="VPN client VPN type should not be null") Integer clientVpnType;
    @Schema(name="encryption", description="Encryption should be a value as follows: 0: Encrypted; 1: Unencrypted.")
    private Integer encryption;
    @Schema(name="ipPoolType", description="IP pool type should be a value as follows: 0: Ip Address/Mask; 1: Ip Address Range.")
    private Integer ipPoolType;
    @Schema(name="ipPoolStart", description="The start IP of the IP pool.")
    @PII(strategy=PIIMaskStrategy.HASH)
    private String ipPoolStart;
    @Schema(name="ipPoolEnd", description="The end IP of the IP pool.")
    @PII(strategy=PIIMaskStrategy.HASH)
    private String ipPoolEnd;
    @Schema(name="ipPool", description="IP pool of the VPN.")
    @NotNull(message="VPN IP pool should not be null")
    private @NotNull(message="VPN IP pool should not be null") IPSubnetsVO ipPool;
    @Schema(name="primaryDns", description="Primary DNS of the VPN.")
    private String primaryDns;
    @Schema(name="secondaryDns", description="Secondary DNS of the VPN.")
    private String secondaryDns;
    @Schema(name="serviceType", description="Service type of the VPN.")
    private Integer serviceType;
    @Schema(name="servicePort", description="Service port should be within the range of 1\u201365535.")
    @Range(min=1L, max=65535L, message="Service port should range between 1 and 65535")
    private @Range(min=1L, max=65535L, message="Service port should range between 1 and 65535") Integer servicePort;
    @Schema(name="authMode", description="Authentication mode should be a value as follows: 0: Local; 1: LDAP.")
    private Integer authMode;
    @Schema(name="advancedSetting", description="Advanced setting list of the VPN, only for IPSec type.")
    private VpnAdvancedSettingOpenApiVO advancedSetting;

    public static ClientToSiteVpnServerOpenApiVO toOpenApiVO(VpnVO vo) {
        if (vo == null) {
            return new ClientToSiteVpnServerOpenApiVO();
        }
        ClientToSiteVpnServerOpenApiVO openApiVO = new ClientToSiteVpnServerOpenApiVO();
        openApiVO.setId(vo.getId());
        openApiVO.setName(vo.getName());
        openApiVO.setStatus(vo.getStatus());
        openApiVO.setAccountPassword(vo.getAccountAuth());
        openApiVO.setTunnelMode(vo.getOpenVpnTunnelMode());
        openApiVO.setOpenVpnMode(vo.getOpenVpnMode());
        openApiVO.setRemoteIp(vo.getRemoteIp());
        openApiVO.setNetworkType(vo.getNetworkType());
        openApiVO.setNetworkList(vo.getNetworkList());
        openApiVO.setPreSharedKey(vo.getPreSharedKey());
        openApiVO.setWan(vo.getWans());
        openApiVO.setClientVpnType(vo.getClientVpnType2());
        openApiVO.setEncryption(vo.getEncryption());
        openApiVO.setIpPoolType(vo.getIpPoolType());
        openApiVO.setIpPoolStart(vo.getIpPoolStart());
        openApiVO.setIpPoolEnd(vo.getIpPoolEnd());
        openApiVO.setPrimaryDns(vo.getDns1());
        openApiVO.setSecondaryDns(vo.getDns2());
        openApiVO.setServiceType(vo.getServiceType());
        openApiVO.setServicePort(vo.getServicePort());
        openApiVO.setAuthMode(vo.getAuthType());
        if (vo.getCustomNetwork() != null) {
            openApiVO.setCustomNetwork(vo.getCustomNetwork());
        }
        if (vo.getIpPool() != null) {
            openApiVO.setIpPool(vo.getIpPool());
        }
        if (vo.getVpnAdvancedSetting() != null) {
            openApiVO.setAdvancedSetting(VpnAdvancedSettingOpenApiVO.toOpenApiVO(vo.getVpnAdvancedSetting()));
        }
        return openApiVO;
    }

    public static List<ClientToSiteVpnServerOpenApiVO> toOpenApiListVO(@Nonnull List<VpnVO> voList) {
        return voList.stream().map(ClientToSiteVpnServerOpenApiVO::toOpenApiVO).collect(Collectors.toList());
    }

    public static VpnVO toVO(ClientToSiteVpnServerOpenApiVO openApiVO) {
        VpnVO vo = new VpnVO();
        vo.setId(openApiVO.getId());
        vo.setName(openApiVO.getName());
        vo.setStatus(openApiVO.getStatus());
        vo.setAccountAuth(openApiVO.getAccountPassword());
        vo.setOpenVpnTunnelMode(openApiVO.getTunnelMode());
        vo.setOpenVpnMode(openApiVO.getOpenVpnMode());
        vo.setRemoteIp(openApiVO.getRemoteIp());
        vo.setNetworkType(openApiVO.getNetworkType());
        vo.setNetworkList(openApiVO.getNetworkList());
        vo.setPreSharedKey(openApiVO.getPreSharedKey());
        vo.setWans(openApiVO.getWan());
        vo.setClientVpnType2(openApiVO.getClientVpnType());
        vo.setEncryption(openApiVO.getEncryption());
        vo.setIpPoolType(openApiVO.getIpPoolType());
        vo.setIpPoolStart(openApiVO.getIpPoolStart());
        vo.setIpPoolEnd(openApiVO.getIpPoolEnd());
        vo.setDns1(openApiVO.getPrimaryDns());
        vo.setDns2(openApiVO.getSecondaryDns());
        vo.setServiceType(openApiVO.getServiceType());
        vo.setServicePort(openApiVO.getServicePort());
        vo.setAuthType(openApiVO.getAuthMode());
        if (openApiVO.getCustomNetwork() != null) {
            vo.setCustomNetwork(openApiVO.getCustomNetwork());
        }
        if (openApiVO.getIpPool() != null) {
            vo.setIpPool(openApiVO.getIpPool());
        }
        if (openApiVO.getAdvancedSetting() != null) {
            vo.setVpnAdvancedSetting(VpnAdvancedSettingOpenApiVO.toVO(openApiVO.getAdvancedSetting()));
        }
        return vo;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public Boolean getAccountPassword() {
        return this.accountPassword;
    }

    @Generated
    public Integer getTunnelMode() {
        return this.tunnelMode;
    }

    @Generated
    public Integer getOpenVpnMode() {
        return this.openVpnMode;
    }

    @Generated
    public String getRemoteIp() {
        return this.remoteIp;
    }

    @Generated
    public Integer getNetworkType() {
        return this.networkType;
    }

    @Generated
    public List<String> getNetworkList() {
        return this.networkList;
    }

    @Generated
    public List<IPSubnetsVO> getCustomNetwork() {
        return this.customNetwork;
    }

    @Generated
    public String getPreSharedKey() {
        return this.preSharedKey;
    }

    @Generated
    public List<String> getWan() {
        return this.wan;
    }

    @Generated
    public Integer getClientVpnType() {
        return this.clientVpnType;
    }

    @Generated
    public Integer getEncryption() {
        return this.encryption;
    }

    @Generated
    public Integer getIpPoolType() {
        return this.ipPoolType;
    }

    @Generated
    public String getIpPoolStart() {
        return this.ipPoolStart;
    }

    @Generated
    public String getIpPoolEnd() {
        return this.ipPoolEnd;
    }

    @Generated
    public IPSubnetsVO getIpPool() {
        return this.ipPool;
    }

    @Generated
    public String getPrimaryDns() {
        return this.primaryDns;
    }

    @Generated
    public String getSecondaryDns() {
        return this.secondaryDns;
    }

    @Generated
    public Integer getServiceType() {
        return this.serviceType;
    }

    @Generated
    public Integer getServicePort() {
        return this.servicePort;
    }

    @Generated
    public Integer getAuthMode() {
        return this.authMode;
    }

    @Generated
    public VpnAdvancedSettingOpenApiVO getAdvancedSetting() {
        return this.advancedSetting;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setStatus(Boolean status) {
        this.status = status;
    }

    @Generated
    public void setAccountPassword(Boolean accountPassword) {
        this.accountPassword = accountPassword;
    }

    @Generated
    public void setTunnelMode(Integer tunnelMode) {
        this.tunnelMode = tunnelMode;
    }

    @Generated
    public void setOpenVpnMode(Integer openVpnMode) {
        this.openVpnMode = openVpnMode;
    }

    @Generated
    public void setRemoteIp(String remoteIp) {
        this.remoteIp = remoteIp;
    }

    @Generated
    public void setNetworkType(Integer networkType) {
        this.networkType = networkType;
    }

    @Generated
    public void setNetworkList(List<String> networkList) {
        this.networkList = networkList;
    }

    @Generated
    public void setCustomNetwork(List<IPSubnetsVO> customNetwork) {
        this.customNetwork = customNetwork;
    }

    @Generated
    public void setPreSharedKey(String preSharedKey) {
        this.preSharedKey = preSharedKey;
    }

    @Generated
    public void setWan(List<String> wan) {
        this.wan = wan;
    }

    @Generated
    public void setClientVpnType(Integer clientVpnType) {
        this.clientVpnType = clientVpnType;
    }

    @Generated
    public void setEncryption(Integer encryption) {
        this.encryption = encryption;
    }

    @Generated
    public void setIpPoolType(Integer ipPoolType) {
        this.ipPoolType = ipPoolType;
    }

    @Generated
    public void setIpPoolStart(String ipPoolStart) {
        this.ipPoolStart = ipPoolStart;
    }

    @Generated
    public void setIpPoolEnd(String ipPoolEnd) {
        this.ipPoolEnd = ipPoolEnd;
    }

    @Generated
    public void setIpPool(IPSubnetsVO ipPool) {
        this.ipPool = ipPool;
    }

    @Generated
    public void setPrimaryDns(String primaryDns) {
        this.primaryDns = primaryDns;
    }

    @Generated
    public void setSecondaryDns(String secondaryDns) {
        this.secondaryDns = secondaryDns;
    }

    @Generated
    public void setServiceType(Integer serviceType) {
        this.serviceType = serviceType;
    }

    @Generated
    public void setServicePort(Integer servicePort) {
        this.servicePort = servicePort;
    }

    @Generated
    public void setAuthMode(Integer authMode) {
        this.authMode = authMode;
    }

    @Generated
    public void setAdvancedSetting(VpnAdvancedSettingOpenApiVO advancedSetting) {
        this.advancedSetting = advancedSetting;
    }

    @Generated
    public String toString() {
        return "ClientToSiteVpnServerOpenApiVO(id=" + this.getId() + ", name=" + this.getName() + ", status=" + this.getStatus() + ", accountPassword=" + this.getAccountPassword() + ", tunnelMode=" + this.getTunnelMode() + ", openVpnMode=" + this.getOpenVpnMode() + ", remoteIp=" + this.getRemoteIp() + ", networkType=" + this.getNetworkType() + ", networkList=" + this.getNetworkList() + ", customNetwork=" + this.getCustomNetwork() + ", preSharedKey=" + this.getPreSharedKey() + ", wan=" + this.getWan() + ", clientVpnType=" + this.getClientVpnType() + ", encryption=" + this.getEncryption() + ", ipPoolType=" + this.getIpPoolType() + ", ipPoolStart=" + this.getIpPoolStart() + ", ipPoolEnd=" + this.getIpPoolEnd() + ", ipPool=" + this.getIpPool() + ", primaryDns=" + this.getPrimaryDns() + ", secondaryDns=" + this.getSecondaryDns() + ", serviceType=" + this.getServiceType() + ", servicePort=" + this.getServicePort() + ", authMode=" + this.getAuthMode() + ", advancedSetting=" + this.getAdvancedSetting() + ")";
    }

    @Generated
    public ClientToSiteVpnServerOpenApiVO(String id, String name, Boolean status, Boolean accountPassword, Integer tunnelMode, Integer openVpnMode, String remoteIp, Integer networkType, List<String> networkList, List<IPSubnetsVO> customNetwork, String preSharedKey, List<String> wan, Integer clientVpnType, Integer encryption, Integer ipPoolType, String ipPoolStart, String ipPoolEnd, IPSubnetsVO ipPool, String primaryDns, String secondaryDns, Integer serviceType, Integer servicePort, Integer authMode, VpnAdvancedSettingOpenApiVO advancedSetting) {
        this.id = id;
        this.name = name;
        this.status = status;
        this.accountPassword = accountPassword;
        this.tunnelMode = tunnelMode;
        this.openVpnMode = openVpnMode;
        this.remoteIp = remoteIp;
        this.networkType = networkType;
        this.networkList = networkList;
        this.customNetwork = customNetwork;
        this.preSharedKey = preSharedKey;
        this.wan = wan;
        this.clientVpnType = clientVpnType;
        this.encryption = encryption;
        this.ipPoolType = ipPoolType;
        this.ipPoolStart = ipPoolStart;
        this.ipPoolEnd = ipPoolEnd;
        this.ipPool = ipPool;
        this.primaryDns = primaryDns;
        this.secondaryDns = secondaryDns;
        this.serviceType = serviceType;
        this.servicePort = servicePort;
        this.authMode = authMode;
        this.advancedSetting = advancedSetting;
    }

    @Generated
    public ClientToSiteVpnServerOpenApiVO() {
    }
}

