/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.vpn.vpn;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.vpn.vpn.VpnCertificateOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.profile.dto.embed.IPSubnetsVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.vpn.dto.VpnVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

@Schema(name="ClientToSiteVpnClient")
public class ClientToSiteVpnClientOpenApiVO {
    @Schema(name="id", description="ID of the VPN.")
    private String id;
    @Schema(name="name", description="Name should contain 1 to 63 characters.")
    @NotNull(message="VPN name should not be null")
    @Pattern(regexp="^[a-zA-Z0-9_]{1,63}$", message="VPN name should be 1~63 visible ASCII characters, and its format can only contain letters, _,and numbers.")
    private @NotNull(message="VPN name should not be null") @Pattern(regexp="^[a-zA-Z0-9_]{1,63}$", message="VPN name should be 1~63 visible ASCII characters, and its format can only contain letters, _,and numbers.") String name;
    @Schema(name="status", description="Status of the VPN.")
    private Boolean status;
    @Schema(name="mode", description="Mode(only for server OpenVPN) should be a value as follows: 0: certification; 1: certification+account.")
    private Integer mode;
    @Schema(name="remoteSite", description="Remote site of the VPN.")
    private String remoteSite;
    @Length(max=253, message="This length should be no more than 253.")
    @Schema(name="remoteIp", description="Remote IP of the VPN. Get whether supports domain from interface 'Get client-to-site VPN client list'.")
    private @Length(max=253, message="This length should be no more than 253.") String remoteIp;
    @Schema(name="remoteSubnet", description="Remote subnet of the VPN.")
    private List<IPSubnetsVO> remoteSubnet;
    @Schema(name="networkType", description="Network type should be a value as follows: 0: network list; 1: custom networks.")
    private Integer networkType;
    @Schema(name="networkList", description="Network list of the VPN. Network can be created using 'Create LAN network' interface, and network ID can be obtained from 'Get LAN network list' interface.")
    private List<String> networkList;
    @Schema(name="customNetwork", description="Custom networks of the VPN.")
    private List<IPSubnetsVO> customNetwork;
    @Schema(name="preSharedKey", description="Pre-shared key of the VPN.")
    private String preSharedKey;
    @Schema(name="wan", description="WAN list of the VPN. WAN port ID can be obtained from 'Get internet basic info' interface.")
    @NotNull(message="VPN WAN should not be null")
    private @NotNull(message="VPN WAN should not be null") List<String> wan;
    @Schema(name="clientVpnType", description="Client Vpn type should be a value as follows: 0: L2TP; 1: PPTP; 2: IPSec; 3: OpenVPN.")
    @NotNull(message="VPN client VPN type should not be null")
    private @NotNull(message="VPN client VPN type should not be null") Integer clientVpnType;
    @Schema(name="openVpnTunnelMode", description="OpenVPN tunnel mode should be a value as follows: 0: split; 1: full.")
    private Integer openVpnTunnelMode;
    @Schema(name="openVpnMode", description="OpenVPN mode should be a value as follows: 0: certification; 1: certification+account.")
    private Integer openVpnMode;
    @Schema(name="serviceType", description="Service type should be a value as follows: 0: UDP; 1: TCP.")
    private Integer serviceType;
    @Schema(name="servicePort", description="Service port should be within the range of 1\u201365535.")
    @Range(min=1L, max=65535L, message="servicePort should range between 1 and 65535")
    private @Range(min=1L, max=65535L, message="servicePort should range between 1 and 65535") Integer servicePort;
    @Schema(name="encryption", description="Encryption should be a value as follows: 0: Encrypted; 1: Unencrypted.")
    private Integer encryption;
    @Schema(name="workingMode", description="Working mode should be a value as follows: 0: NAT; 1: Routing.")
    private Integer workingMode;
    @Schema(name="clientUserName", description="Client username should contain 1 to 64 characters.")
    @Size(min=1, max=64, message="Size of clientUsername is from 1 to 64.")
    @PII(strategy=PIIMaskStrategy.HASH)
    private @Size(min=1, max=64, message="Size of clientUsername is from 1 to 64.") String clientUsername;
    @Schema(name="clientPassword", description="Client password should contain 1 to 64 characters.")
    @Size(min=1, max=64, message="Size of clientPassword is from 1 to 64.")
    @PII(strategy=PIIMaskStrategy.MASK)
    private @Size(min=1, max=64, message="Size of clientPassword is from 1 to 64.") String clientPassword;
    @Schema(name="vpnConfiguration", description="VPN configuration of the VPN")
    private VpnCertificateOpenApiVO vpnConfiguration;

    public static ClientToSiteVpnClientOpenApiVO toOpenApiVO(VpnVO vo) {
        if (vo == null) {
            return new ClientToSiteVpnClientOpenApiVO();
        }
        ClientToSiteVpnClientOpenApiVO openApiVO = new ClientToSiteVpnClientOpenApiVO();
        openApiVO.setId(vo.getId());
        openApiVO.setName(vo.getName());
        openApiVO.setStatus(vo.getStatus());
        openApiVO.setMode(vo.getOpenVpnMode());
        openApiVO.setRemoteSite(vo.getRemoteSite());
        openApiVO.setRemoteIp(vo.getRemoteIp());
        openApiVO.setNetworkType(vo.getNetworkType());
        openApiVO.setNetworkList(vo.getNetworkList());
        openApiVO.setPreSharedKey(vo.getPreSharedKey());
        openApiVO.setWan(vo.getWans());
        openApiVO.setClientVpnType(vo.getClientVpnType2());
        openApiVO.setOpenVpnMode(vo.getOpenVpnMode());
        openApiVO.setServiceType(vo.getServiceType());
        openApiVO.setServicePort(vo.getServicePort());
        openApiVO.setEncryption(vo.getEncryption());
        openApiVO.setWorkingMode(vo.getWorkingMode());
        openApiVO.setClientUsername(vo.getClientUserName());
        openApiVO.setClientPassword(vo.getClientPassword());
        if (vo.getRemoteSubnet() != null) {
            openApiVO.setRemoteSubnet(vo.getRemoteSubnet());
        }
        if (vo.getCustomNetwork() != null) {
            openApiVO.setCustomNetwork(vo.getCustomNetwork());
        }
        if (vo.getVpnConfiguration() != null) {
            openApiVO.setVpnConfiguration(VpnCertificateOpenApiVO.toOpenApiVO(vo.getVpnConfiguration()));
        }
        return openApiVO;
    }

    public static List<ClientToSiteVpnClientOpenApiVO> toOpenApiListVO(@Nonnull List<VpnVO> voList) {
        return voList.stream().map(ClientToSiteVpnClientOpenApiVO::toOpenApiVO).collect(Collectors.toList());
    }

    public static VpnVO toVO(ClientToSiteVpnClientOpenApiVO openApiVO) {
        VpnVO vo = new VpnVO();
        vo.setId(openApiVO.getId());
        vo.setName(openApiVO.getName());
        vo.setStatus(openApiVO.getStatus());
        vo.setOpenVpnMode(openApiVO.getMode());
        vo.setRemoteSite(openApiVO.getRemoteSite());
        vo.setRemoteIp(openApiVO.getRemoteIp());
        vo.setNetworkType(openApiVO.getNetworkType());
        vo.setNetworkList(openApiVO.getNetworkList());
        vo.setPreSharedKey(openApiVO.getPreSharedKey());
        vo.setWans(openApiVO.getWan());
        vo.setClientVpnType2(openApiVO.getClientVpnType());
        vo.setOpenVpnMode(openApiVO.getOpenVpnMode());
        vo.setServiceType(openApiVO.getServiceType());
        vo.setServicePort(openApiVO.getServicePort());
        vo.setEncryption(openApiVO.getEncryption());
        vo.setWorkingMode(openApiVO.getWorkingMode());
        vo.setClientUserName(openApiVO.getClientUsername());
        vo.setClientPassword(openApiVO.getClientPassword());
        if (openApiVO.getRemoteSubnet() != null) {
            vo.setRemoteSubnet(openApiVO.getRemoteSubnet());
        }
        if (openApiVO.getCustomNetwork() != null) {
            vo.setCustomNetwork(openApiVO.getCustomNetwork());
        }
        if (openApiVO.getVpnConfiguration() != null) {
            vo.setVpnConfiguration(VpnCertificateOpenApiVO.toVO(openApiVO.getVpnConfiguration()));
        }
        return vo;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public Integer getMode() {
        return this.mode;
    }

    @Generated
    public String getRemoteSite() {
        return this.remoteSite;
    }

    @Generated
    public String getRemoteIp() {
        return this.remoteIp;
    }

    @Generated
    public List<IPSubnetsVO> getRemoteSubnet() {
        return this.remoteSubnet;
    }

    @Generated
    public Integer getNetworkType() {
        return this.networkType;
    }

    @Generated
    public List<String> getNetworkList() {
        return this.networkList;
    }

    @Generated
    public List<IPSubnetsVO> getCustomNetwork() {
        return this.customNetwork;
    }

    @Generated
    public String getPreSharedKey() {
        return this.preSharedKey;
    }

    @Generated
    public List<String> getWan() {
        return this.wan;
    }

    @Generated
    public Integer getClientVpnType() {
        return this.clientVpnType;
    }

    @Generated
    public Integer getOpenVpnTunnelMode() {
        return this.openVpnTunnelMode;
    }

    @Generated
    public Integer getOpenVpnMode() {
        return this.openVpnMode;
    }

    @Generated
    public Integer getServiceType() {
        return this.serviceType;
    }

    @Generated
    public Integer getServicePort() {
        return this.servicePort;
    }

    @Generated
    public Integer getEncryption() {
        return this.encryption;
    }

    @Generated
    public Integer getWorkingMode() {
        return this.workingMode;
    }

    @Generated
    public String getClientUsername() {
        return this.clientUsername;
    }

    @Generated
    public String getClientPassword() {
        return this.clientPassword;
    }

    @Generated
    public VpnCertificateOpenApiVO getVpnConfiguration() {
        return this.vpnConfiguration;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setStatus(Boolean status) {
        this.status = status;
    }

    @Generated
    public void setMode(Integer mode) {
        this.mode = mode;
    }

    @Generated
    public void setRemoteSite(String remoteSite) {
        this.remoteSite = remoteSite;
    }

    @Generated
    public void setRemoteIp(String remoteIp) {
        this.remoteIp = remoteIp;
    }

    @Generated
    public void setRemoteSubnet(List<IPSubnetsVO> remoteSubnet) {
        this.remoteSubnet = remoteSubnet;
    }

    @Generated
    public void setNetworkType(Integer networkType) {
        this.networkType = networkType;
    }

    @Generated
    public void setNetworkList(List<String> networkList) {
        this.networkList = networkList;
    }

    @Generated
    public void setCustomNetwork(List<IPSubnetsVO> customNetwork) {
        this.customNetwork = customNetwork;
    }

    @Generated
    public void setPreSharedKey(String preSharedKey) {
        this.preSharedKey = preSharedKey;
    }

    @Generated
    public void setWan(List<String> wan) {
        this.wan = wan;
    }

    @Generated
    public void setClientVpnType(Integer clientVpnType) {
        this.clientVpnType = clientVpnType;
    }

    @Generated
    public void setOpenVpnTunnelMode(Integer openVpnTunnelMode) {
        this.openVpnTunnelMode = openVpnTunnelMode;
    }

    @Generated
    public void setOpenVpnMode(Integer openVpnMode) {
        this.openVpnMode = openVpnMode;
    }

    @Generated
    public void setServiceType(Integer serviceType) {
        this.serviceType = serviceType;
    }

    @Generated
    public void setServicePort(Integer servicePort) {
        this.servicePort = servicePort;
    }

    @Generated
    public void setEncryption(Integer encryption) {
        this.encryption = encryption;
    }

    @Generated
    public void setWorkingMode(Integer workingMode) {
        this.workingMode = workingMode;
    }

    @Generated
    public void setClientUsername(String clientUsername) {
        this.clientUsername = clientUsername;
    }

    @Generated
    public void setClientPassword(String clientPassword) {
        this.clientPassword = clientPassword;
    }

    @Generated
    public void setVpnConfiguration(VpnCertificateOpenApiVO vpnConfiguration) {
        this.vpnConfiguration = vpnConfiguration;
    }

    @Generated
    public String toString() {
        return "ClientToSiteVpnClientOpenApiVO(id=" + this.getId() + ", name=" + this.getName() + ", status=" + this.getStatus() + ", mode=" + this.getMode() + ", remoteSite=" + this.getRemoteSite() + ", remoteIp=" + this.getRemoteIp() + ", remoteSubnet=" + this.getRemoteSubnet() + ", networkType=" + this.getNetworkType() + ", networkList=" + this.getNetworkList() + ", customNetwork=" + this.getCustomNetwork() + ", preSharedKey=" + this.getPreSharedKey() + ", wan=" + this.getWan() + ", clientVpnType=" + this.getClientVpnType() + ", openVpnTunnelMode=" + this.getOpenVpnTunnelMode() + ", openVpnMode=" + this.getOpenVpnMode() + ", serviceType=" + this.getServiceType() + ", servicePort=" + this.getServicePort() + ", encryption=" + this.getEncryption() + ", workingMode=" + this.getWorkingMode() + ", clientUsername=" + this.getClientUsername() + ", clientPassword=" + this.getClientPassword() + ", vpnConfiguration=" + this.getVpnConfiguration() + ")";
    }

    @Generated
    public ClientToSiteVpnClientOpenApiVO(String id, String name, Boolean status, Integer mode, String remoteSite, String remoteIp, List<IPSubnetsVO> remoteSubnet, Integer networkType, List<String> networkList, List<IPSubnetsVO> customNetwork, String preSharedKey, List<String> wan, Integer clientVpnType, Integer openVpnTunnelMode, Integer openVpnMode, Integer serviceType, Integer servicePort, Integer encryption, Integer workingMode, String clientUsername, String clientPassword, VpnCertificateOpenApiVO vpnConfiguration) {
        this.id = id;
        this.name = name;
        this.status = status;
        this.mode = mode;
        this.remoteSite = remoteSite;
        this.remoteIp = remoteIp;
        this.remoteSubnet = remoteSubnet;
        this.networkType = networkType;
        this.networkList = networkList;
        this.customNetwork = customNetwork;
        this.preSharedKey = preSharedKey;
        this.wan = wan;
        this.clientVpnType = clientVpnType;
        this.openVpnTunnelMode = openVpnTunnelMode;
        this.openVpnMode = openVpnMode;
        this.serviceType = serviceType;
        this.servicePort = servicePort;
        this.encryption = encryption;
        this.workingMode = workingMode;
        this.clientUsername = clientUsername;
        this.clientPassword = clientPassword;
        this.vpnConfiguration = vpnConfiguration;
    }

    @Generated
    public ClientToSiteVpnClientOpenApiVO() {
    }
}

