/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.vpn.sslvpn;

import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.vpn.grid.SslVpnUserOpenApiGridVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.sslvpn.user.SslVpnUerGridVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.sslvpn.user.SslVpnUserVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="SslVpnUserEntity")
public class SslVpnUserOpenApiVO {
    @Schema(name="id", description="ID of the SSL VPN user")
    private String id;
    @Schema(name="groupId", description="Group ID of the SSL VPN user. User group can be created using 'Create SSL VPN user group' interface, and User Group ID can be obtained from 'Get user group list for SSL VPN server' interface.")
    private String groupId;
    @Schema(name="groupName", description="Group name of the SSL VPN user")
    private String groupName;
    @Schema(name="name", description="Name of the SSL VPN user")
    @NotNull(message="SSL vpn user name should not be null")
    @Pattern(regexp="^[\\041-\\0176]$|^[\\041-\\0176][\\040-\\0176]{0,18}[\\041-\\0176]$", message="Parameter [name] should be 1~20 visible ASCII characters.")
    private @NotNull(message="SSL vpn user name should not be null") @Pattern(regexp="^[\\041-\\0176]$|^[\\041-\\0176][\\040-\\0176]{0,18}[\\041-\\0176]$", message="Parameter [name] should be 1~20 visible ASCII characters.") String name;
    @Schema(name="status", description="Status of the SSL VPN user")
    @NotNull(message="SSL vpn user status should not be null")
    private @NotNull(message="SSL vpn user status should not be null") Boolean status;
    @Schema(name="available", description="Available of the SSL VPN user")
    private Boolean available;
    @Schema(name="password", description="Password of the SSL VPN user")
    @NotNull(message="SSL vpn user password should not be null")
    @Pattern(regexp="^[\\041-\\0176]$|^[\\041-\\0176][\\040-\\0176]{0,62}[\\041-\\0176]$", message="Parameter [password] should be 1~64 visible ASCII characters.")
    private @NotNull(message="SSL vpn user password should not be null") @Pattern(regexp="^[\\041-\\0176]$|^[\\041-\\0176][\\040-\\0176]{0,62}[\\041-\\0176]$", message="Parameter [password] should be 1~64 visible ASCII characters.") String password;
    @Schema(name="validity", description="Validity of the SSL VPN user")
    @NotNull(message="SSL vpn user validity should not be null")
    private @NotNull(message="SSL vpn user validity should not be null") String validity;
    @Schema(name="concurrentNumber", description="Concurrent number of the SSL VPN user")
    @NotNull(message="SSL vpn user concurrent number should not be null")
    @Range(min=1L, max=100L, message="concurrent number should range between 1 and 100")
    private @NotNull(message="SSL vpn user concurrent number should not be null") @Range(min=1L, max=100L, message="concurrent number should range between 1 and 100") Integer concurrentNumber;

    public static SslVpnUserOpenApiVO toOpenApiVO(@Nonnull SslVpnUserVO vo) {
        SslVpnUserOpenApiVO sslVpnUserOpenApiVO = new SslVpnUserOpenApiVO();
        sslVpnUserOpenApiVO.setId(vo.getId());
        sslVpnUserOpenApiVO.setGroupId(vo.getGroupId());
        sslVpnUserOpenApiVO.setGroupName(vo.getGroupName());
        sslVpnUserOpenApiVO.setName(vo.getName());
        sslVpnUserOpenApiVO.setStatus(vo.getStatus());
        sslVpnUserOpenApiVO.setAvailable(vo.getAvailable());
        sslVpnUserOpenApiVO.setPassword(vo.getPassword());
        sslVpnUserOpenApiVO.setValidity(vo.getValidity());
        sslVpnUserOpenApiVO.setConcurrentNumber(vo.getConcurrentNum());
        return sslVpnUserOpenApiVO;
    }

    public static SslVpnUserOpenApiGridVO<SslVpnUserOpenApiVO> toOpenApiGridVO(@Nonnull SslVpnUerGridVO<SslVpnUserVO> gridVO) {
        SslVpnUserOpenApiGridVO<SslVpnUserOpenApiVO> openApiGridVO = new SslVpnUserOpenApiGridVO<SslVpnUserOpenApiVO>();
        openApiGridVO.setTotalRows(gridVO.getTotalRows());
        openApiGridVO.setCurrentPage(gridVO.getCurrentPage());
        openApiGridVO.setCurrentSize(gridVO.getCurrentSize());
        openApiGridVO.setData(gridVO.getData().stream().map(SslVpnUserOpenApiVO::toOpenApiVO).collect(Collectors.toList()));
        openApiGridVO.setTotal(gridVO.getTotal());
        return openApiGridVO;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getGroupName() {
        return this.groupName;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public Boolean getAvailable() {
        return this.available;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getValidity() {
        return this.validity;
    }

    @Generated
    public Integer getConcurrentNumber() {
        return this.concurrentNumber;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @Generated
    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setStatus(Boolean status) {
        this.status = status;
    }

    @Generated
    public void setAvailable(Boolean available) {
        this.available = available;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setValidity(String validity) {
        this.validity = validity;
    }

    @Generated
    public void setConcurrentNumber(Integer concurrentNumber) {
        this.concurrentNumber = concurrentNumber;
    }

    @Generated
    public String toString() {
        return "SslVpnUserOpenApiVO(id=" + this.getId() + ", groupId=" + this.getGroupId() + ", groupName=" + this.getGroupName() + ", name=" + this.getName() + ", status=" + this.getStatus() + ", available=" + this.getAvailable() + ", password=" + this.getPassword() + ", validity=" + this.getValidity() + ", concurrentNumber=" + this.getConcurrentNumber() + ")";
    }

    @Generated
    public SslVpnUserOpenApiVO(String id, String groupId, String groupName, String name, Boolean status, Boolean available, String password, String validity, Integer concurrentNumber) {
        this.id = id;
        this.groupId = groupId;
        this.groupName = groupName;
        this.name = name;
        this.status = status;
        this.available = available;
        this.password = password;
        this.validity = validity;
        this.concurrentNumber = concurrentNumber;
    }

    @Generated
    public SslVpnUserOpenApiVO() {
    }
}

