/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.vpn.sslvpn;

import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.vpn.sslvpn.SslVpnResourceGroupBriefOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.sslvpn.user.SslVpnUserGroupGridVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.sslvpn.user.SslVpnUserGroupVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

@Schema(name="SslVpnUserGroupEntity")
public class SslVpnUserGroupOpenApiVO {
    @Schema(name="id", description="ID of the SSL VPN user group")
    private String id;
    @Schema(name="name", description="Name of the SSL VPN user group")
    @NotNull(message="User group name should not be null")
    private @NotNull(message="User group name should not be null") String name;
    @Schema(name="radiusAttribute", description="Attribute value used for radius authentication")
    private String radiusAttribute;
    @Schema(name="LDAPAttribute", description="Attribute value used for LDAP authentication")
    private String ldapAttribute;
    @Schema(name="resourceGroupList", description="Resource group list of the SSL VPN user group")
    private List<SslVpnResourceGroupBriefOpenApiVO> resourceGroupList;
    @Schema(name="userList", description="User list of the SSL VPN user group")
    private List<String> userList;
    @Schema(name="userNumber", description="User number of the SSL VPN user group")
    private Integer userNumber;

    public static SslVpnUserGroupOpenApiVO toOpenApiVO(@Nonnull SslVpnUserGroupVO vo) {
        SslVpnUserGroupOpenApiVO sslVpnUserGroupOpenApiVO = new SslVpnUserGroupOpenApiVO();
        sslVpnUserGroupOpenApiVO.setId(vo.getId());
        sslVpnUserGroupOpenApiVO.setName(vo.getName());
        sslVpnUserGroupOpenApiVO.setResourceGroupList(SslVpnResourceGroupBriefOpenApiVO.toListOpenApiVO(vo.getResourceGroupList()));
        sslVpnUserGroupOpenApiVO.setRadiusAttribute(vo.getRadiusAttribute());
        sslVpnUserGroupOpenApiVO.setLdapAttribute(vo.getLdapAttribute());
        sslVpnUserGroupOpenApiVO.setUserList(vo.getUserList());
        sslVpnUserGroupOpenApiVO.setUserNumber(vo.getUserNums());
        return sslVpnUserGroupOpenApiVO;
    }

    public static GridVO<SslVpnUserGroupOpenApiVO> toOpenApiGridVO(@Nonnull SslVpnUserGroupGridVO<SslVpnUserGroupVO> gridVO) {
        GridVO openApiGridVO = new GridVO();
        openApiGridVO.setTotalRows(gridVO.getTotalRows());
        openApiGridVO.setCurrentPage(gridVO.getCurrentPage());
        openApiGridVO.setCurrentSize(gridVO.getCurrentSize());
        openApiGridVO.setData(gridVO.getData().stream().map(SslVpnUserGroupOpenApiVO::toOpenApiVO).collect(Collectors.toList()));
        return openApiGridVO;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getRadiusAttribute() {
        return this.radiusAttribute;
    }

    @Generated
    public String getLdapAttribute() {
        return this.ldapAttribute;
    }

    @Generated
    public List<SslVpnResourceGroupBriefOpenApiVO> getResourceGroupList() {
        return this.resourceGroupList;
    }

    @Generated
    public List<String> getUserList() {
        return this.userList;
    }

    @Generated
    public Integer getUserNumber() {
        return this.userNumber;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setRadiusAttribute(String radiusAttribute) {
        this.radiusAttribute = radiusAttribute;
    }

    @Generated
    public void setLdapAttribute(String ldapAttribute) {
        this.ldapAttribute = ldapAttribute;
    }

    @Generated
    public void setResourceGroupList(List<SslVpnResourceGroupBriefOpenApiVO> resourceGroupList) {
        this.resourceGroupList = resourceGroupList;
    }

    @Generated
    public void setUserList(List<String> userList) {
        this.userList = userList;
    }

    @Generated
    public void setUserNumber(Integer userNumber) {
        this.userNumber = userNumber;
    }

    @Generated
    public String toString() {
        return "SslVpnUserGroupOpenApiVO(id=" + this.getId() + ", name=" + this.getName() + ", radiusAttribute=" + this.getRadiusAttribute() + ", ldapAttribute=" + this.getLdapAttribute() + ", resourceGroupList=" + this.getResourceGroupList() + ", userList=" + this.getUserList() + ", userNumber=" + this.getUserNumber() + ")";
    }

    @Generated
    public SslVpnUserGroupOpenApiVO(String id, String name, String radiusAttribute, String ldapAttribute, List<SslVpnResourceGroupBriefOpenApiVO> resourceGroupList, List<String> userList, Integer userNumber) {
        this.id = id;
        this.name = name;
        this.radiusAttribute = radiusAttribute;
        this.ldapAttribute = ldapAttribute;
        this.resourceGroupList = resourceGroupList;
        this.userList = userList;
        this.userNumber = userNumber;
    }

    @Generated
    public SslVpnUserGroupOpenApiVO() {
    }
}

