/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.vpn.sslvpn;

import com.tplink.smb.omada.manager.configuration.api.web.site.sslvpn.resource.SslVpnResourceGroupBriefVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.sslvpn.user.SslVpnUserGroupVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class SslVpnUserGroupConfigOpenApiVO {
    @Schema(name="name", description="Name of the SSL VPN user group should contain 1 to 20 characters.")
    @NotNull(message="User group name should not be null")
    @Pattern(regexp="^[\\041-\\0176]$|^[\\041-\\0176][\\040-\\0176]{0,18}[\\041-\\0176]$", message="Parameter [name] should be 1~20 visible ASCII characters.")
    private @NotNull(message="User group name should not be null") @Pattern(regexp="^[\\041-\\0176]$|^[\\041-\\0176][\\040-\\0176]{0,18}[\\041-\\0176]$", message="Parameter [name] should be 1~20 visible ASCII characters.") String name;
    @Schema(name="radiusAttribute", description="Attribute value used for radius authentication. It should contain 1 to 20 characters.")
    private String radiusAttribute;
    @Schema(name="LDAPAttribute", description="Attribute value used for LDAP authentication. It should contain 1 to 20 characters.")
    private String ldapAttribute;
    @Schema(name="resourceGroupList", description="Resource group ID list of the SSL VPN user group. Resource group can be created using 'Create SSL VPN resource group' interface, and Resource group ID can be obtained from 'Get resource group list for SSL VPN server' interface.")
    private List<String> resourceGroupList;

    public static SslVpnUserGroupVO toWebVO(SslVpnUserGroupConfigOpenApiVO vo) {
        SslVpnUserGroupVO res = new SslVpnUserGroupVO();
        if (vo == null) {
            return res;
        }
        res.setName(vo.getName());
        res.setRadiusAttribute(vo.getRadiusAttribute());
        res.setLdapAttribute(vo.getLdapAttribute());
        ArrayList<SslVpnResourceGroupBriefVO> sslVpnResourceGroupBriefVOS = new ArrayList<SslVpnResourceGroupBriefVO>();
        for (String resourceId : vo.getResourceGroupList()) {
            sslVpnResourceGroupBriefVOS.add(new SslVpnResourceGroupBriefVO(resourceId, null));
        }
        res.setResourceGroupList(sslVpnResourceGroupBriefVOS);
        return res;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getRadiusAttribute() {
        return this.radiusAttribute;
    }

    @Generated
    public String getLdapAttribute() {
        return this.ldapAttribute;
    }

    @Generated
    public List<String> getResourceGroupList() {
        return this.resourceGroupList;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setRadiusAttribute(String radiusAttribute) {
        this.radiusAttribute = radiusAttribute;
    }

    @Generated
    public void setLdapAttribute(String ldapAttribute) {
        this.ldapAttribute = ldapAttribute;
    }

    @Generated
    public void setResourceGroupList(List<String> resourceGroupList) {
        this.resourceGroupList = resourceGroupList;
    }

    @Generated
    public String toString() {
        return "SslVpnUserGroupConfigOpenApiVO(name=" + this.getName() + ", radiusAttribute=" + this.getRadiusAttribute() + ", ldapAttribute=" + this.getLdapAttribute() + ", resourceGroupList=" + this.getResourceGroupList() + ")";
    }

    @Generated
    public SslVpnUserGroupConfigOpenApiVO(String name, String radiusAttribute, String ldapAttribute, List<String> resourceGroupList) {
        this.name = name;
        this.radiusAttribute = radiusAttribute;
        this.ldapAttribute = ldapAttribute;
        this.resourceGroupList = resourceGroupList;
    }

    @Generated
    public SslVpnUserGroupConfigOpenApiVO() {
    }
}

