/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.vpn.sslvpn;

import com.tplink.smb.omada.manager.configuration.api.web.site.sslvpn.user.SslVpnUserVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class SslVpnUserConfigOpenApiVO {
    @Schema(name="groupId", description="Group ID of the SSL VPN user. User group can be created using 'Create SSL VPN user group' interface, and User Group ID can be obtained from 'Get user group list for SSL VPN server' interface.")
    private String groupId;
    @Schema(name="name", description="Name of the SSL VPN user should contain 1 to 20 characters.")
    @NotNull(message="SSL vpn user name should not be null")
    @Pattern(regexp="^[\\041-\\0176]$|^[\\041-\\0176][\\040-\\0176]{0,18}[\\041-\\0176]$", message="Parameter [name] should be 1~20 visible ASCII characters.")
    private @NotNull(message="SSL vpn user name should not be null") @Pattern(regexp="^[\\041-\\0176]$|^[\\041-\\0176][\\040-\\0176]{0,18}[\\041-\\0176]$", message="Parameter [name] should be 1~20 visible ASCII characters.") String name;
    @Schema(name="status", description="Status of the SSL VPN user")
    @NotNull(message="SSL vpn user status should not be null")
    private @NotNull(message="SSL vpn user status should not be null") Boolean status;
    @Schema(name="password", description="Password of the SSL VPN user should contain 1 to 64 characters.")
    @NotNull(message="SSL vpn user password should not be null")
    @Pattern(regexp="^[\\041-\\0176]$|^[\\041-\\0176][\\040-\\0176]{0,62}[\\041-\\0176]$", message="Parameter [password] should be 1~64 visible ASCII characters.")
    private @NotNull(message="SSL vpn user password should not be null") @Pattern(regexp="^[\\041-\\0176]$|^[\\041-\\0176][\\040-\\0176]{0,62}[\\041-\\0176]$", message="Parameter [password] should be 1~64 visible ASCII characters.") String password;
    @Schema(name="validity", description="Validity of the SSL VPN user. The format is Month/Day/Year, for example 08/20/2022")
    @NotNull(message="SSL vpn user validity should not be null")
    private @NotNull(message="SSL vpn user validity should not be null") String validity;
    @Schema(name="concurrentNumber", description="Concurrent number of the SSL VPN user should be within the range of 1\u2013100")
    @NotNull(message="SSL vpn user concurrent number should not be null")
    @Range(min=1L, max=100L, message="concurrent number should range between 1 and 100")
    private @NotNull(message="SSL vpn user concurrent number should not be null") @Range(min=1L, max=100L, message="concurrent number should range between 1 and 100") Integer concurrentNumber;

    public static SslVpnUserVO toWebVO(SslVpnUserConfigOpenApiVO vo) {
        SslVpnUserVO res = new SslVpnUserVO();
        if (vo == null) {
            return res;
        }
        res.setGroupId(vo.getGroupId());
        res.setName(vo.getName());
        res.setStatus(vo.getStatus());
        res.setPassword(vo.getPassword());
        res.setValidity(vo.getValidity());
        res.setConcurrentNum(vo.getConcurrentNumber());
        return res;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getValidity() {
        return this.validity;
    }

    @Generated
    public Integer getConcurrentNumber() {
        return this.concurrentNumber;
    }

    @Generated
    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setStatus(Boolean status) {
        this.status = status;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setValidity(String validity) {
        this.validity = validity;
    }

    @Generated
    public void setConcurrentNumber(Integer concurrentNumber) {
        this.concurrentNumber = concurrentNumber;
    }

    @Generated
    public String toString() {
        return "SslVpnUserConfigOpenApiVO(groupId=" + this.getGroupId() + ", name=" + this.getName() + ", status=" + this.getStatus() + ", password=" + this.getPassword() + ", validity=" + this.getValidity() + ", concurrentNumber=" + this.getConcurrentNumber() + ")";
    }

    @Generated
    public SslVpnUserConfigOpenApiVO(String groupId, String name, Boolean status, String password, String validity, Integer concurrentNumber) {
        this.groupId = groupId;
        this.name = name;
        this.status = status;
        this.password = password;
        this.validity = validity;
        this.concurrentNumber = concurrentNumber;
    }

    @Generated
    public SslVpnUserConfigOpenApiVO() {
    }
}

