/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.vpn.sslvpn;

import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.vpn.grid.SslVpnTunnelOpenApiGridVO;
import com.tplink.smb.omada.manager.insight.api.web.sslvpn.insight.SslVpnTunnelGridVO;
import com.tplink.smb.omada.manager.insight.api.web.sslvpn.insight.SslVpnTunnelVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import java.util.stream.Collectors;
import lombok.Generated;

@Schema(name="SslVpnTunnelEntity")
public class SslVpnTunnelOpenApiVO {
    @Schema(name="id", description="ID of the SSL VPN tunnel")
    private Long id;
    @Schema(name="userName", description="Username of the SSL VPN tunnel")
    private String username;
    @Schema(name="loginIp", description="Login IP of the SSL VPN tunnel")
    private String loginIp;
    @Schema(name="virtualIp", description="Virtual IP of the SSL VPN tunnel")
    private String virtualIp;
    @Schema(name="upBytes", description="Up bytes(KB) of the SSL VPN tunnel")
    private Long upBytes;
    @Schema(name="downBytes", description="Down bytes(KB) of the SSL VPN tunnel")
    private Long downBytes;
    @Schema(name="loginTime", description="Login time of the SSL VPN tunnel")
    private String loginTime;
    @Schema(name="authType", description="Authentication type of the SSL VPN server should be a value as follows: 0: local; 1: radius; 2: LDAP.")
    private Integer authType;

    public static SslVpnTunnelOpenApiVO toOpenApiVO(@Nonnull SslVpnTunnelVO vo) {
        SslVpnTunnelOpenApiVO sslVpnTunnelOpenApiVO = new SslVpnTunnelOpenApiVO();
        sslVpnTunnelOpenApiVO.setId(vo.getId());
        sslVpnTunnelOpenApiVO.setUsername(vo.getUserName());
        sslVpnTunnelOpenApiVO.setLoginIp(vo.getLoginIp());
        sslVpnTunnelOpenApiVO.setVirtualIp(vo.getVirtualIp());
        sslVpnTunnelOpenApiVO.setUpBytes(vo.getUpBytes());
        sslVpnTunnelOpenApiVO.setDownBytes(vo.getDownBytes());
        sslVpnTunnelOpenApiVO.setLoginTime(vo.getLoginTime());
        sslVpnTunnelOpenApiVO.setAuthType(vo.getAuthType());
        return sslVpnTunnelOpenApiVO;
    }

    public static SslVpnTunnelOpenApiGridVO<SslVpnTunnelOpenApiVO> toOpenApiGridVO(@Nonnull SslVpnTunnelGridVO<SslVpnTunnelVO> gridVO) {
        SslVpnTunnelOpenApiGridVO<SslVpnTunnelOpenApiVO> openApiGridVO = new SslVpnTunnelOpenApiGridVO<SslVpnTunnelOpenApiVO>();
        openApiGridVO.setTotalRows(gridVO.getTotalRows());
        openApiGridVO.setCurrentPage(gridVO.getCurrentPage());
        openApiGridVO.setCurrentSize(gridVO.getCurrentSize());
        openApiGridVO.setData(gridVO.getData().stream().map(SslVpnTunnelOpenApiVO::toOpenApiVO).collect(Collectors.toList()));
        openApiGridVO.setLockStatus(gridVO.getLockStatus());
        return openApiGridVO;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getLoginIp() {
        return this.loginIp;
    }

    @Generated
    public String getVirtualIp() {
        return this.virtualIp;
    }

    @Generated
    public Long getUpBytes() {
        return this.upBytes;
    }

    @Generated
    public Long getDownBytes() {
        return this.downBytes;
    }

    @Generated
    public String getLoginTime() {
        return this.loginTime;
    }

    @Generated
    public Integer getAuthType() {
        return this.authType;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setLoginIp(String loginIp) {
        this.loginIp = loginIp;
    }

    @Generated
    public void setVirtualIp(String virtualIp) {
        this.virtualIp = virtualIp;
    }

    @Generated
    public void setUpBytes(Long upBytes) {
        this.upBytes = upBytes;
    }

    @Generated
    public void setDownBytes(Long downBytes) {
        this.downBytes = downBytes;
    }

    @Generated
    public void setLoginTime(String loginTime) {
        this.loginTime = loginTime;
    }

    @Generated
    public void setAuthType(Integer authType) {
        this.authType = authType;
    }

    @Generated
    public String toString() {
        return "SslVpnTunnelOpenApiVO(id=" + this.getId() + ", username=" + this.getUsername() + ", loginIp=" + this.getLoginIp() + ", virtualIp=" + this.getVirtualIp() + ", upBytes=" + this.getUpBytes() + ", downBytes=" + this.getDownBytes() + ", loginTime=" + this.getLoginTime() + ", authType=" + this.getAuthType() + ")";
    }

    @Generated
    public SslVpnTunnelOpenApiVO(Long id, String username, String loginIp, String virtualIp, Long upBytes, Long downBytes, String loginTime, Integer authType) {
        this.id = id;
        this.username = username;
        this.loginIp = loginIp;
        this.virtualIp = virtualIp;
        this.upBytes = upBytes;
        this.downBytes = downBytes;
        this.loginTime = loginTime;
        this.authType = authType;
    }

    @Generated
    public SslVpnTunnelOpenApiVO() {
    }
}

