/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.vpn.sslvpn;

import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.vpn.sslvpn.LdapSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.vpn.sslvpn.LockSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.vpn.sslvpn.RadiusSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.sslvpn.server.SslVpnServerVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="SslVpnServerSetting")
public class SslVpnServerSettingOpenApiVO {
    @Schema(name="id", description="ID of the SSL VPN server.")
    private String id;
    @Schema(name="status", description="Status of the SSL VPN server.")
    @NotNull(message="SSL VPN status should not be null")
    private @NotNull(message="SSL VPN status should not be null") Boolean status;
    @Schema(name="wanPort", description="WAN port of the SSL VPN server. WAN port ID can be obtained from 'Get internet basic info' interface")
    private String wanPort;
    @Schema(name="wanIp", description="WAP IP of the SSL VPN server.")
    @Pattern(regexp="((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6})", message="Invalid IP pool format.")
    private @Pattern(regexp="((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6})", message="Invalid IP pool format.") String wanIp;
    @Schema(name="ipPoolStart", description="The start IP of the IP pool.")
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid IP pool format.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid IP pool format.") String ipPoolStart;
    @Schema(name="ipPoolEnd", description="The end IP of the IP pool.")
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid IP pool format.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid IP pool format.") String ipPoolEnd;
    @Schema(name="primaryDns", description="Primary DNS Server of the SSL VPN server.")
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid Primary DNS Server.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid Primary DNS Server.") String primaryDns;
    @Schema(name="secondaryDns", description="Secondary DNS Server of the SSL VPN server.")
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid Secondary DNS Server.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid Secondary DNS Server.") String secondaryDns;
    @Schema(name="servicePort", description="Service port of the SSL VPN server should be within the range of 1\u201365535")
    @Range(min=1L, max=65535L, message="ServicePort should range between 1 and 65535")
    private @Range(min=1L, max=65535L, message="ServicePort should range between 1 and 65535") Integer servicePort;
    @Schema(name="authType", description="Authentication type of the SSL VPN server should be a value as follows: 0: local; 1: radius; 2: LDAP.")
    private Integer authType;
    @Schema(name="radiusSetting", description="It is required when parameter [authType] is 1.")
    private RadiusSettingOpenApiVO radiusSetting;
    @Schema(name="LDAPSetting", description="It is required when parameter [authType] is 2.")
    private LdapSettingOpenApiVO ldapSetting;
    @Schema(name="nameLockSetting", description="Name lock config.")
    private LockSettingOpenApiVO nameLockSetting;
    @Schema(name="ipLockSetting", description="IP lock config.")
    private LockSettingOpenApiVO ipLockSetting;
    @Schema(name="exitAtIdle", description="Whether to exit when idle")
    private Boolean exitAtIdle;
    @Schema(name="exitTime", description="Exit time should be within the range of 5\u20133600(s). It is required when parameter [exitAtIdle] is true.")
    private Integer exitTime;
    @Schema(name="totalTraffic", description="Whether to proxy all traffic.")
    private Boolean totalTraffic;
    @Schema(name="supportRadius", description="Whether the adopted gateway supports Radius.")
    private Boolean supportRadius;
    @Schema(name="existRadius", description="Whether Radius Authentication has been configured in SSL VPN Server.")
    private Boolean existRadius;
    @Schema(name="supportLDAP", description="Whether the adopted gateway supports LDAP.")
    private Boolean supportLdap;
    @Schema(name="existLdap", description="Whether LDAP Authentication has been configured in SSL VPN Server.")
    private Boolean existLdap;

    public static SslVpnServerSettingOpenApiVO toOpenApiVO(@Nonnull SslVpnServerVO serverVO) {
        SslVpnServerSettingOpenApiVO sslVpnServerSettingOpenApiVO = new SslVpnServerSettingOpenApiVO();
        sslVpnServerSettingOpenApiVO.setId(serverVO.getId());
        sslVpnServerSettingOpenApiVO.setStatus(serverVO.getStatus());
        sslVpnServerSettingOpenApiVO.setWanIp(serverVO.getWanIp());
        sslVpnServerSettingOpenApiVO.setWanPort(serverVO.getWanPort());
        sslVpnServerSettingOpenApiVO.setIpPoolStart(serverVO.getIpPoolStart());
        sslVpnServerSettingOpenApiVO.setIpPoolEnd(serverVO.getIpPoolEnd());
        sslVpnServerSettingOpenApiVO.setPrimaryDns(serverVO.getDns1());
        sslVpnServerSettingOpenApiVO.setSecondaryDns(serverVO.getDns2());
        sslVpnServerSettingOpenApiVO.setServicePort(serverVO.getServicePort());
        sslVpnServerSettingOpenApiVO.setAuthType(serverVO.getAuthType());
        sslVpnServerSettingOpenApiVO.setRadiusSetting(RadiusSettingOpenApiVO.fromWeb(serverVO.getRadiusSetting()));
        sslVpnServerSettingOpenApiVO.setLdapSetting(LdapSettingOpenApiVO.fromVO(serverVO.getLdapSetting()));
        sslVpnServerSettingOpenApiVO.setNameLockSetting(LockSettingOpenApiVO.fromWeb(serverVO.getNameLockSetting()));
        sslVpnServerSettingOpenApiVO.setIpLockSetting(LockSettingOpenApiVO.fromWeb(serverVO.getIpLockSetting()));
        sslVpnServerSettingOpenApiVO.setExitAtIdle(serverVO.getExitAtIdle());
        sslVpnServerSettingOpenApiVO.setExitTime(serverVO.getExitTime());
        sslVpnServerSettingOpenApiVO.setTotalTraffic(serverVO.getTotalTraffic());
        sslVpnServerSettingOpenApiVO.setSupportRadius(serverVO.getSupportRadius());
        sslVpnServerSettingOpenApiVO.setSupportLdap(serverVO.getSupportLdap());
        sslVpnServerSettingOpenApiVO.setExistLdap(serverVO.getExistLdap());
        sslVpnServerSettingOpenApiVO.setExistRadius(serverVO.getExistRadius());
        return sslVpnServerSettingOpenApiVO;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public String getWanPort() {
        return this.wanPort;
    }

    @Generated
    public String getWanIp() {
        return this.wanIp;
    }

    @Generated
    public String getIpPoolStart() {
        return this.ipPoolStart;
    }

    @Generated
    public String getIpPoolEnd() {
        return this.ipPoolEnd;
    }

    @Generated
    public String getPrimaryDns() {
        return this.primaryDns;
    }

    @Generated
    public String getSecondaryDns() {
        return this.secondaryDns;
    }

    @Generated
    public Integer getServicePort() {
        return this.servicePort;
    }

    @Generated
    public Integer getAuthType() {
        return this.authType;
    }

    @Generated
    public RadiusSettingOpenApiVO getRadiusSetting() {
        return this.radiusSetting;
    }

    @Generated
    public LdapSettingOpenApiVO getLdapSetting() {
        return this.ldapSetting;
    }

    @Generated
    public LockSettingOpenApiVO getNameLockSetting() {
        return this.nameLockSetting;
    }

    @Generated
    public LockSettingOpenApiVO getIpLockSetting() {
        return this.ipLockSetting;
    }

    @Generated
    public Boolean getExitAtIdle() {
        return this.exitAtIdle;
    }

    @Generated
    public Integer getExitTime() {
        return this.exitTime;
    }

    @Generated
    public Boolean getTotalTraffic() {
        return this.totalTraffic;
    }

    @Generated
    public Boolean getSupportRadius() {
        return this.supportRadius;
    }

    @Generated
    public Boolean getExistRadius() {
        return this.existRadius;
    }

    @Generated
    public Boolean getSupportLdap() {
        return this.supportLdap;
    }

    @Generated
    public Boolean getExistLdap() {
        return this.existLdap;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setStatus(Boolean status) {
        this.status = status;
    }

    @Generated
    public void setWanPort(String wanPort) {
        this.wanPort = wanPort;
    }

    @Generated
    public void setWanIp(String wanIp) {
        this.wanIp = wanIp;
    }

    @Generated
    public void setIpPoolStart(String ipPoolStart) {
        this.ipPoolStart = ipPoolStart;
    }

    @Generated
    public void setIpPoolEnd(String ipPoolEnd) {
        this.ipPoolEnd = ipPoolEnd;
    }

    @Generated
    public void setPrimaryDns(String primaryDns) {
        this.primaryDns = primaryDns;
    }

    @Generated
    public void setSecondaryDns(String secondaryDns) {
        this.secondaryDns = secondaryDns;
    }

    @Generated
    public void setServicePort(Integer servicePort) {
        this.servicePort = servicePort;
    }

    @Generated
    public void setAuthType(Integer authType) {
        this.authType = authType;
    }

    @Generated
    public void setRadiusSetting(RadiusSettingOpenApiVO radiusSetting) {
        this.radiusSetting = radiusSetting;
    }

    @Generated
    public void setLdapSetting(LdapSettingOpenApiVO ldapSetting) {
        this.ldapSetting = ldapSetting;
    }

    @Generated
    public void setNameLockSetting(LockSettingOpenApiVO nameLockSetting) {
        this.nameLockSetting = nameLockSetting;
    }

    @Generated
    public void setIpLockSetting(LockSettingOpenApiVO ipLockSetting) {
        this.ipLockSetting = ipLockSetting;
    }

    @Generated
    public void setExitAtIdle(Boolean exitAtIdle) {
        this.exitAtIdle = exitAtIdle;
    }

    @Generated
    public void setExitTime(Integer exitTime) {
        this.exitTime = exitTime;
    }

    @Generated
    public void setTotalTraffic(Boolean totalTraffic) {
        this.totalTraffic = totalTraffic;
    }

    @Generated
    public void setSupportRadius(Boolean supportRadius) {
        this.supportRadius = supportRadius;
    }

    @Generated
    public void setExistRadius(Boolean existRadius) {
        this.existRadius = existRadius;
    }

    @Generated
    public void setSupportLdap(Boolean supportLdap) {
        this.supportLdap = supportLdap;
    }

    @Generated
    public void setExistLdap(Boolean existLdap) {
        this.existLdap = existLdap;
    }

    @Generated
    public String toString() {
        return "SslVpnServerSettingOpenApiVO(id=" + this.getId() + ", status=" + this.getStatus() + ", wanPort=" + this.getWanPort() + ", wanIp=" + this.getWanIp() + ", ipPoolStart=" + this.getIpPoolStart() + ", ipPoolEnd=" + this.getIpPoolEnd() + ", primaryDns=" + this.getPrimaryDns() + ", secondaryDns=" + this.getSecondaryDns() + ", servicePort=" + this.getServicePort() + ", authType=" + this.getAuthType() + ", radiusSetting=" + this.getRadiusSetting() + ", ldapSetting=" + this.getLdapSetting() + ", nameLockSetting=" + this.getNameLockSetting() + ", ipLockSetting=" + this.getIpLockSetting() + ", exitAtIdle=" + this.getExitAtIdle() + ", exitTime=" + this.getExitTime() + ", totalTraffic=" + this.getTotalTraffic() + ", supportRadius=" + this.getSupportRadius() + ", existRadius=" + this.getExistRadius() + ", supportLdap=" + this.getSupportLdap() + ", existLdap=" + this.getExistLdap() + ")";
    }

    @Generated
    public SslVpnServerSettingOpenApiVO(String id, Boolean status, String wanPort, String wanIp, String ipPoolStart, String ipPoolEnd, String primaryDns, String secondaryDns, Integer servicePort, Integer authType, RadiusSettingOpenApiVO radiusSetting, LdapSettingOpenApiVO ldapSetting, LockSettingOpenApiVO nameLockSetting, LockSettingOpenApiVO ipLockSetting, Boolean exitAtIdle, Integer exitTime, Boolean totalTraffic, Boolean supportRadius, Boolean existRadius, Boolean supportLdap, Boolean existLdap) {
        this.id = id;
        this.status = status;
        this.wanPort = wanPort;
        this.wanIp = wanIp;
        this.ipPoolStart = ipPoolStart;
        this.ipPoolEnd = ipPoolEnd;
        this.primaryDns = primaryDns;
        this.secondaryDns = secondaryDns;
        this.servicePort = servicePort;
        this.authType = authType;
        this.radiusSetting = radiusSetting;
        this.ldapSetting = ldapSetting;
        this.nameLockSetting = nameLockSetting;
        this.ipLockSetting = ipLockSetting;
        this.exitAtIdle = exitAtIdle;
        this.exitTime = exitTime;
        this.totalTraffic = totalTraffic;
        this.supportRadius = supportRadius;
        this.existRadius = existRadius;
        this.supportLdap = supportLdap;
        this.existLdap = existLdap;
    }

    @Generated
    public SslVpnServerSettingOpenApiVO() {
    }
}

