/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.vpn.sslvpn;

import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.vpn.sslvpn.LdapSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.vpn.sslvpn.LockSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.vpn.sslvpn.RadiusSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.sslvpn.server.SslVpnServerVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class SslVpnServerConfigOpenApiVO {
    @Schema(name="status", description="Status of the SSL VPN server.")
    @NotNull(message="SSL VPN status should not be null")
    private @NotNull(message="SSL VPN status should not be null") Boolean status;
    @Schema(name="wanPort", description="WAN port ID of the SSL VPN server. It is required when parameter [status] is true. WAN port ID can be obtained from 'Get internet basic info' interface")
    private String wanPort;
    @Schema(name="ipPoolStart", description="The start IP of the IP pool. It is required when parameter [status] is true.")
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid IP pool format.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid IP pool format.") String ipPoolStart;
    @Schema(name="ipPoolEnd", description="The end IP of the IP pool. It is required when parameter [status] is true.")
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid IP pool format.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid IP pool format.") String ipPoolEnd;
    @Schema(name="primaryDns", description="Primary DNS Server of the SSL VPN server. It is required when parameter [status] is true.")
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid Primary DNS Server.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid Primary DNS Server.") String primaryDns;
    @Schema(name="secondaryDns", description="Secondary DNS Server of the SSL VPN server.")
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid Secondary DNS Server.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid Secondary DNS Server.") String secondaryDns;
    @Schema(name="servicePort", description="Service port of the SSL VPN server. Default value is 1194. It is required when parameter [status] is true, and it should be within the range of 1\u201365535")
    @Range(min=1L, max=65535L, message="ServicePort should range between 1 and 65535")
    private @Range(min=1L, max=65535L, message="ServicePort should range between 1 and 65535") Integer servicePort;
    @Schema(name="authType", description="Authentication type of the SSL VPN server should be a value as follows: 0: local; 1: radius; 2: LDAP. It is required when parameter [status] is true.")
    private Integer authType;
    @Schema(name="radiusSetting", description="It is required when parameter [authType] is 1.")
    private RadiusSettingOpenApiVO radiusSetting;
    @Schema(name="LDAPSetting", description="It is required when parameter [authType] is 2.")
    private LdapSettingOpenApiVO ldapSetting;
    @Schema(name="nameLockSetting", description="Name lock config. It is required when parameter [status] is true.")
    private LockSettingOpenApiVO nameLockSetting;
    @Schema(name="ipLockSetting", description="IP lock config. It is required when parameter [status] is true.")
    private LockSettingOpenApiVO ipLockSetting;
    @Schema(name="exitAtIdle", description="Whether to exit when idle.  It is required when parameter [status] is true.")
    private Boolean exitAtIdle;
    @Schema(name="exitTime", description="Exit time should be within the range of 5\u20133600(s). It is required when parameter [exitAtIdle] is true.")
    private Integer exitTime;
    @Schema(name="totalTraffic", description="Whether to proxy all traffic. It is required when parameter [status] is true.")
    private Boolean totalTraffic;

    public static SslVpnServerVO towebVO(@Nonnull SslVpnServerConfigOpenApiVO serverVO) {
        return SslVpnServerVO.builder().status(serverVO.getStatus()).wanPort(serverVO.getWanPort()).ipPoolStart(serverVO.getIpPoolStart()).ipPoolEnd(serverVO.getIpPoolEnd()).dns1(serverVO.getPrimaryDns()).dns2(serverVO.getSecondaryDns()).servicePort(serverVO.getServicePort()).authType(serverVO.getAuthType()).radiusSetting(RadiusSettingOpenApiVO.toWeb(serverVO.getRadiusSetting())).ldapSetting(LdapSettingOpenApiVO.fromOpenApiVO(serverVO.getLdapSetting())).nameLockSetting(LockSettingOpenApiVO.toWeb(serverVO.getNameLockSetting())).ipLockSetting(LockSettingOpenApiVO.toWeb(serverVO.getIpLockSetting())).exitAtIdle(serverVO.getExitAtIdle()).exitTime(serverVO.getExitTime()).totalTraffic(serverVO.getTotalTraffic()).build();
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public String getWanPort() {
        return this.wanPort;
    }

    @Generated
    public String getIpPoolStart() {
        return this.ipPoolStart;
    }

    @Generated
    public String getIpPoolEnd() {
        return this.ipPoolEnd;
    }

    @Generated
    public String getPrimaryDns() {
        return this.primaryDns;
    }

    @Generated
    public String getSecondaryDns() {
        return this.secondaryDns;
    }

    @Generated
    public Integer getServicePort() {
        return this.servicePort;
    }

    @Generated
    public Integer getAuthType() {
        return this.authType;
    }

    @Generated
    public RadiusSettingOpenApiVO getRadiusSetting() {
        return this.radiusSetting;
    }

    @Generated
    public LdapSettingOpenApiVO getLdapSetting() {
        return this.ldapSetting;
    }

    @Generated
    public LockSettingOpenApiVO getNameLockSetting() {
        return this.nameLockSetting;
    }

    @Generated
    public LockSettingOpenApiVO getIpLockSetting() {
        return this.ipLockSetting;
    }

    @Generated
    public Boolean getExitAtIdle() {
        return this.exitAtIdle;
    }

    @Generated
    public Integer getExitTime() {
        return this.exitTime;
    }

    @Generated
    public Boolean getTotalTraffic() {
        return this.totalTraffic;
    }

    @Generated
    public void setStatus(Boolean status) {
        this.status = status;
    }

    @Generated
    public void setWanPort(String wanPort) {
        this.wanPort = wanPort;
    }

    @Generated
    public void setIpPoolStart(String ipPoolStart) {
        this.ipPoolStart = ipPoolStart;
    }

    @Generated
    public void setIpPoolEnd(String ipPoolEnd) {
        this.ipPoolEnd = ipPoolEnd;
    }

    @Generated
    public void setPrimaryDns(String primaryDns) {
        this.primaryDns = primaryDns;
    }

    @Generated
    public void setSecondaryDns(String secondaryDns) {
        this.secondaryDns = secondaryDns;
    }

    @Generated
    public void setServicePort(Integer servicePort) {
        this.servicePort = servicePort;
    }

    @Generated
    public void setAuthType(Integer authType) {
        this.authType = authType;
    }

    @Generated
    public void setRadiusSetting(RadiusSettingOpenApiVO radiusSetting) {
        this.radiusSetting = radiusSetting;
    }

    @Generated
    public void setLdapSetting(LdapSettingOpenApiVO ldapSetting) {
        this.ldapSetting = ldapSetting;
    }

    @Generated
    public void setNameLockSetting(LockSettingOpenApiVO nameLockSetting) {
        this.nameLockSetting = nameLockSetting;
    }

    @Generated
    public void setIpLockSetting(LockSettingOpenApiVO ipLockSetting) {
        this.ipLockSetting = ipLockSetting;
    }

    @Generated
    public void setExitAtIdle(Boolean exitAtIdle) {
        this.exitAtIdle = exitAtIdle;
    }

    @Generated
    public void setExitTime(Integer exitTime) {
        this.exitTime = exitTime;
    }

    @Generated
    public void setTotalTraffic(Boolean totalTraffic) {
        this.totalTraffic = totalTraffic;
    }

    @Generated
    public String toString() {
        return "SslVpnServerConfigOpenApiVO(status=" + this.getStatus() + ", wanPort=" + this.getWanPort() + ", ipPoolStart=" + this.getIpPoolStart() + ", ipPoolEnd=" + this.getIpPoolEnd() + ", primaryDns=" + this.getPrimaryDns() + ", secondaryDns=" + this.getSecondaryDns() + ", servicePort=" + this.getServicePort() + ", authType=" + this.getAuthType() + ", radiusSetting=" + this.getRadiusSetting() + ", ldapSetting=" + this.getLdapSetting() + ", nameLockSetting=" + this.getNameLockSetting() + ", ipLockSetting=" + this.getIpLockSetting() + ", exitAtIdle=" + this.getExitAtIdle() + ", exitTime=" + this.getExitTime() + ", totalTraffic=" + this.getTotalTraffic() + ")";
    }

    @Generated
    public SslVpnServerConfigOpenApiVO(Boolean status, String wanPort, String ipPoolStart, String ipPoolEnd, String primaryDns, String secondaryDns, Integer servicePort, Integer authType, RadiusSettingOpenApiVO radiusSetting, LdapSettingOpenApiVO ldapSetting, LockSettingOpenApiVO nameLockSetting, LockSettingOpenApiVO ipLockSetting, Boolean exitAtIdle, Integer exitTime, Boolean totalTraffic) {
        this.status = status;
        this.wanPort = wanPort;
        this.ipPoolStart = ipPoolStart;
        this.ipPoolEnd = ipPoolEnd;
        this.primaryDns = primaryDns;
        this.secondaryDns = secondaryDns;
        this.servicePort = servicePort;
        this.authType = authType;
        this.radiusSetting = radiusSetting;
        this.ldapSetting = ldapSetting;
        this.nameLockSetting = nameLockSetting;
        this.ipLockSetting = ipLockSetting;
        this.exitAtIdle = exitAtIdle;
        this.exitTime = exitTime;
        this.totalTraffic = totalTraffic;
    }

    @Generated
    public SslVpnServerConfigOpenApiVO() {
    }
}

