/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.vpn.sslvpn;

import com.tplink.smb.omada.manager.configuration.api.web.site.sslvpn.resource.SslVpnResourceBriefVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.sslvpn.resource.SslVpnResourceGroupVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class SslVpnResourceGroupConfigOpenApiVO {
    @Schema(name="name", description="Name of the SSL VPN resource group should contain 1 to 20 characters.")
    @NotNull(message="Resource group name should not be null")
    @Pattern(regexp="^[\\041-\\0176]$|^[\\041-\\0176][\\040-\\0176]{0,18}[\\041-\\0176]$", message="Parameter [name] should be 1~20 visible ASCII characters.")
    private @NotNull(message="Resource group name should not be null") @Pattern(regexp="^[\\041-\\0176]$|^[\\041-\\0176][\\040-\\0176]{0,18}[\\041-\\0176]$", message="Parameter [name] should be 1~20 visible ASCII characters.") String name;
    @Schema(name="resourcesList", description="Resources ID list of the SSL VPN resource group")
    private List<String> resourcesList;

    public static SslVpnResourceGroupVO toWebVO(SslVpnResourceGroupConfigOpenApiVO vo) {
        SslVpnResourceGroupVO res = new SslVpnResourceGroupVO();
        if (vo == null) {
            return res;
        }
        res.setName(vo.getName());
        ArrayList<SslVpnResourceBriefVO> sslVpnResourceBriefVOS = new ArrayList<SslVpnResourceBriefVO>();
        for (String resourceId : vo.getResourcesList()) {
            sslVpnResourceBriefVOS.add(new SslVpnResourceBriefVO(resourceId, null));
        }
        res.setResourcesList(sslVpnResourceBriefVOS);
        return res;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<String> getResourcesList() {
        return this.resourcesList;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setResourcesList(List<String> resourcesList) {
        this.resourcesList = resourcesList;
    }

    @Generated
    public String toString() {
        return "SslVpnResourceGroupConfigOpenApiVO(name=" + this.getName() + ", resourcesList=" + this.getResourcesList() + ")";
    }

    @Generated
    public SslVpnResourceGroupConfigOpenApiVO(String name, List<String> resourcesList) {
        this.name = name;
        this.resourcesList = resourcesList;
    }

    @Generated
    public SslVpnResourceGroupConfigOpenApiVO() {
    }
}

