/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.vpn.sslvpn;

import com.tplink.smb.omada.manager.configuration.api.web.site.sslvpn.resource.SslVpnResourceVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class SslVpnResourceConfigOpenApiVO {
    @Schema(name="name", description="Name of the SSL VPN resource should contain 1 to 20 characters.")
    @NotNull(message="SSL vpn resource name should not be null.")
    @Pattern(regexp="^[\\041-\\0176]$|^[\\041-\\0176][\\040-\\0176]{0,18}[\\041-\\0176]$", message="Parameter [name] should be 1~20 visible ASCII characters.")
    private @NotNull(message="SSL vpn resource name should not be null.") @Pattern(regexp="^[\\041-\\0176]$|^[\\041-\\0176][\\040-\\0176]{0,18}[\\041-\\0176]$", message="Parameter [name] should be 1~20 visible ASCII characters.") String name;
    @Schema(name="type", description="Type of the SSL VPN resource should be a value as follows: 0: IP; 1: domain.")
    @NotNull(message="SSL vpn resource type should not be null.")
    private @NotNull(message="SSL vpn resource type should not be null.") Integer type;
    @Schema(name="ip", description="IP of the SSL VPN resource, exists when type is 0.")
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid IP format.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid IP format.") String ip;
    @Schema(name="mask", description="Mask of the SSL VPN resource, exists when type is 0.")
    private String mask;
    @Schema(name="domain", description="Domain of the SSL VPN resource, exists when type is 1.")
    private String domain;
    @Schema(name="protocol", description="Protocol of the SSL VPN resource should be a value as follows: 0:All; 1:TCP; 2:UDP; 3:TCP/UDP; 4:ICMP; 5:Other")
    @Range(min=0L, max=5L, message="Protocol should range between 0 and 5.")
    private @Range(min=0L, max=5L, message="Protocol should range between 0 and 5.") Integer protocol;
    @Schema(name="srcPortStart", description="Start source port of the SSL VPN resource, exists when protocol is TCP or UDP. It should be within the range of 0\u201365535")
    @Range(min=0L, max=65535L, message="Port should range between 0 and 65535.")
    private @Range(min=0L, max=65535L, message="Port should range between 0 and 65535.") Integer srcPortStart;
    @Schema(name="srcPortEnd", description="End source port of the SSL VPN resource, exists when protocol is TCP or UDP. It should be within the range of 0\u201365535")
    @Range(min=0L, max=65535L, message="Port should range between 0 and 65535.")
    private @Range(min=0L, max=65535L, message="Port should range between 0 and 65535.") Integer srcPortEnd;
    @Schema(name="dstPortStart", description="Start destination port of the SSL VPN resource, exists when protocol is TCP or UDP. It should be within the range of 0\u201365535")
    @Range(min=0L, max=65535L, message="Port should range between 0 and 65535.")
    private @Range(min=0L, max=65535L, message="Port should range between 0 and 65535.") Integer dstPortStart;
    @Schema(name="dstPortEnd", description="End destination port of the SSL VPN resource, exists when protocol is TCP or UDP. It should be within the range of 0\u201365535")
    @Range(min=0L, max=65535L, message="Port should range between 0 and 65535.")
    private @Range(min=0L, max=65535L, message="Port should range between 0 and 65535.") Integer dstPortEnd;
    @Schema(name="icmpType", description="ICMP type of the SSL VPN resource, exists when protocol is ICMP. It should be within the range of 0\u2013255")
    @Range(min=0L, max=255L, message="Type should range between 0 and 255.")
    private @Range(min=0L, max=255L, message="Type should range between 0 and 255.") Integer icmpType;
    @Schema(name="icmpCode", description="ICMP code of the SSL VPN resource, exists when protocol is ICMP. It should be within the range of 0\u2013255")
    @Range(min=0L, max=255L, message="Code should range between 0 and 255.")
    private @Range(min=0L, max=255L, message="Code should range between 0 and 255.") Integer icmpCode;
    @Schema(name="otherProtocol", description="Other protocol of the SSL VPN resource. It should be within the range of 1\u2013255.")
    @Range(min=1L, max=255L, message="Protocol should range between 1 and 255.")
    private @Range(min=1L, max=255L, message="Protocol should range between 1 and 255.") Integer otherProtocol;

    public static SslVpnResourceVO toWebVO(SslVpnResourceConfigOpenApiVO vo) {
        SslVpnResourceVO res = new SslVpnResourceVO();
        if (vo == null) {
            return res;
        }
        res.setName(vo.getName());
        res.setType(vo.getType());
        if (res.getType() == 0) {
            res.setIp(vo.getIp());
            res.setMask(vo.getMask());
        } else {
            res.setDomain(vo.getDomain());
        }
        res.setProtocol(vo.getProtocol());
        res.setSrcPortStart(vo.getSrcPortStart());
        res.setSrcPortEnd(vo.getSrcPortEnd());
        res.setDstPortStart(vo.getDstPortStart());
        res.setDstPortEnd(vo.getDstPortEnd());
        res.setIcmpType(vo.getIcmpType());
        res.setIcmpCode(vo.getIcmpCode());
        res.setOtherProtocol(vo.getOtherProtocol());
        return res;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public String getMask() {
        return this.mask;
    }

    @Generated
    public String getDomain() {
        return this.domain;
    }

    @Generated
    public Integer getProtocol() {
        return this.protocol;
    }

    @Generated
    public Integer getSrcPortStart() {
        return this.srcPortStart;
    }

    @Generated
    public Integer getSrcPortEnd() {
        return this.srcPortEnd;
    }

    @Generated
    public Integer getDstPortStart() {
        return this.dstPortStart;
    }

    @Generated
    public Integer getDstPortEnd() {
        return this.dstPortEnd;
    }

    @Generated
    public Integer getIcmpType() {
        return this.icmpType;
    }

    @Generated
    public Integer getIcmpCode() {
        return this.icmpCode;
    }

    @Generated
    public Integer getOtherProtocol() {
        return this.otherProtocol;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setType(Integer type) {
        this.type = type;
    }

    @Generated
    public void setIp(String ip) {
        this.ip = ip;
    }

    @Generated
    public void setMask(String mask) {
        this.mask = mask;
    }

    @Generated
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Generated
    public void setProtocol(Integer protocol) {
        this.protocol = protocol;
    }

    @Generated
    public void setSrcPortStart(Integer srcPortStart) {
        this.srcPortStart = srcPortStart;
    }

    @Generated
    public void setSrcPortEnd(Integer srcPortEnd) {
        this.srcPortEnd = srcPortEnd;
    }

    @Generated
    public void setDstPortStart(Integer dstPortStart) {
        this.dstPortStart = dstPortStart;
    }

    @Generated
    public void setDstPortEnd(Integer dstPortEnd) {
        this.dstPortEnd = dstPortEnd;
    }

    @Generated
    public void setIcmpType(Integer icmpType) {
        this.icmpType = icmpType;
    }

    @Generated
    public void setIcmpCode(Integer icmpCode) {
        this.icmpCode = icmpCode;
    }

    @Generated
    public void setOtherProtocol(Integer otherProtocol) {
        this.otherProtocol = otherProtocol;
    }

    @Generated
    public String toString() {
        return "SslVpnResourceConfigOpenApiVO(name=" + this.getName() + ", type=" + this.getType() + ", ip=" + this.getIp() + ", mask=" + this.getMask() + ", domain=" + this.getDomain() + ", protocol=" + this.getProtocol() + ", srcPortStart=" + this.getSrcPortStart() + ", srcPortEnd=" + this.getSrcPortEnd() + ", dstPortStart=" + this.getDstPortStart() + ", dstPortEnd=" + this.getDstPortEnd() + ", icmpType=" + this.getIcmpType() + ", icmpCode=" + this.getIcmpCode() + ", otherProtocol=" + this.getOtherProtocol() + ")";
    }

    @Generated
    public SslVpnResourceConfigOpenApiVO(String name, Integer type, String ip, String mask, String domain, Integer protocol, Integer srcPortStart, Integer srcPortEnd, Integer dstPortStart, Integer dstPortEnd, Integer icmpType, Integer icmpCode, Integer otherProtocol) {
        this.name = name;
        this.type = type;
        this.ip = ip;
        this.mask = mask;
        this.domain = domain;
        this.protocol = protocol;
        this.srcPortStart = srcPortStart;
        this.srcPortEnd = srcPortEnd;
        this.dstPortStart = dstPortStart;
        this.dstPortEnd = dstPortEnd;
        this.icmpType = icmpType;
        this.icmpCode = icmpCode;
        this.otherProtocol = otherProtocol;
    }

    @Generated
    public SslVpnResourceConfigOpenApiVO() {
    }
}

