/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.vpn.sslvpn;

import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.sslvpn.lock.SslVpnLockVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.validation.constraints.NotNull;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="SSL VPN lock entity")
public class SslVpnLockOpenApiVO {
    @Schema(name="id", description="ID of the SSL VPN lock")
    private String id;
    @Schema(name="username", description="Username of the SSL VPN lock")
    private String username;
    @Schema(name="ip", description="IP of the SSL VPN lock")
    private String ip;
    @Schema(name="type", description="Type of the SSL VPN lock should be a value as follows: 0:username; 1:IP")
    @NotNull(message="SSL vpn lock type should not be null")
    @Range(min=0L, max=1L, message="Lock type should be IP or userName")
    private @NotNull(message="SSL vpn lock type should not be null") @Range(min=0L, max=1L, message="Lock type should be IP or userName") Integer type;
    @Schema(name="totalLockTime", description="Total lock time of the SSL VPN lock should be within the range of 1\u20131080(min).")
    @NotNull(message="SSL vpn total lock time should not be null")
    @Range(min=0L, max=1080L, message="Total lock time should range between 1 and 1080")
    private @NotNull(message="SSL vpn total lock time should not be null") @Range(min=0L, max=1080L, message="Total lock time should range between 1 and 1080") Integer totalLockTime;
    @Schema(name="leftLockTime", description="Left lock time(min) of the SSL VPN lock.")
    private Integer leftLockTime;

    public static SslVpnLockOpenApiVO toOpenApiVO(@Nonnull SslVpnLockVO vo) {
        SslVpnLockOpenApiVO sslVpnLockOpenApiVO = new SslVpnLockOpenApiVO();
        sslVpnLockOpenApiVO.setId(vo.getId());
        sslVpnLockOpenApiVO.setUsername(vo.getUserName());
        sslVpnLockOpenApiVO.setIp(vo.getIp());
        sslVpnLockOpenApiVO.setType(vo.getType());
        sslVpnLockOpenApiVO.setTotalLockTime(vo.getTotalLockTime());
        sslVpnLockOpenApiVO.setLeftLockTime(vo.getLeftLockTime());
        return sslVpnLockOpenApiVO;
    }

    public static GridVO<SslVpnLockOpenApiVO> toOpenApiGridVO(@Nonnull GridVO<SslVpnLockVO> gridVO) {
        GridVO openApiGridVO = new GridVO();
        openApiGridVO.setTotalRows(gridVO.getTotalRows());
        openApiGridVO.setCurrentPage(gridVO.getCurrentPage());
        openApiGridVO.setCurrentSize(gridVO.getCurrentSize());
        openApiGridVO.setData(gridVO.getData().stream().map(SslVpnLockOpenApiVO::toOpenApiVO).collect(Collectors.toList()));
        return openApiGridVO;
    }

    public static SslVpnLockVO toWebVO(@Nonnull SslVpnLockOpenApiVO openApiVO) {
        SslVpnLockVO res = new SslVpnLockVO();
        res.setId(openApiVO.getId());
        res.setIp(openApiVO.getIp());
        res.setType(openApiVO.getType());
        res.setLeftLockTime(openApiVO.getLeftLockTime());
        res.setUserName(openApiVO.getUsername());
        res.setTotalLockTime(openApiVO.getTotalLockTime());
        return res;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public Integer getTotalLockTime() {
        return this.totalLockTime;
    }

    @Generated
    public Integer getLeftLockTime() {
        return this.leftLockTime;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setIp(String ip) {
        this.ip = ip;
    }

    @Generated
    public void setType(Integer type) {
        this.type = type;
    }

    @Generated
    public void setTotalLockTime(Integer totalLockTime) {
        this.totalLockTime = totalLockTime;
    }

    @Generated
    public void setLeftLockTime(Integer leftLockTime) {
        this.leftLockTime = leftLockTime;
    }

    @Generated
    public String toString() {
        return "SslVpnLockOpenApiVO(id=" + this.getId() + ", username=" + this.getUsername() + ", ip=" + this.getIp() + ", type=" + this.getType() + ", totalLockTime=" + this.getTotalLockTime() + ", leftLockTime=" + this.getLeftLockTime() + ")";
    }

    @Generated
    public SslVpnLockOpenApiVO(String id, String username, String ip, Integer type, Integer totalLockTime, Integer leftLockTime) {
        this.id = id;
        this.username = username;
        this.ip = ip;
        this.type = type;
        this.totalLockTime = totalLockTime;
        this.leftLockTime = leftLockTime;
    }

    @Generated
    public SslVpnLockOpenApiVO() {
    }
}

