/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.vpn.sslvpn;

import com.tplink.smb.omada.manager.configuration.api.web.site.sslvpn.lock.SslVpnLockVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class SslVpnLockModifyOpenApiVO {
    @Schema(name="type", description="Type of the SSL VPN lock should be a value as follows: 0:username, 1:IP. It can not be modified.")
    @NotNull(message="SSL vpn lock type should not be null")
    @Range(min=0L, max=1L, message="Lock type should be ip or userName")
    private @NotNull(message="SSL vpn lock type should not be null") @Range(min=0L, max=1L, message="Lock type should be ip or userName") Integer type;
    @Schema(name="username", description="Username of the SSL VPN lock. It is required when parameter [type] is 0.")
    @Pattern(regexp="^[\\041-\\0176]$|^[\\041-\\0176][\\040-\\0176]{0,18}[\\041-\\0176]$", message="Parameter [name] should be 1~20 visible ASCII characters.")
    private @Pattern(regexp="^[\\041-\\0176]$|^[\\041-\\0176][\\040-\\0176]{0,18}[\\041-\\0176]$", message="Parameter [name] should be 1~20 visible ASCII characters.") String username;
    @Schema(name="ip", description="IP of the SSL VPN lock. It is required when parameter [type] is 1.")
    private String ip;
    @Schema(name="totalLockTime", description="Total lock time of the SSL VPN lock should be within the range of 1\u20131080(min).")
    @NotNull(message="SSL vpn total lock time should not be null")
    @Range(min=1L, max=1080L, message="Total lock time should range between 1 and 1080")
    private @NotNull(message="SSL vpn total lock time should not be null") @Range(min=1L, max=1080L, message="Total lock time should range between 1 and 1080") Integer totalLockTime;

    public static SslVpnLockVO toWebVO(SslVpnLockModifyOpenApiVO vo) {
        SslVpnLockVO res = new SslVpnLockVO();
        if (vo == null) {
            return res;
        }
        res.setType(vo.getType());
        if (res.getType() == 0) {
            res.setUserName(vo.getUsername());
        } else {
            res.setIp(vo.getIp());
        }
        res.setTotalLockTime(vo.getTotalLockTime());
        return res;
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public Integer getTotalLockTime() {
        return this.totalLockTime;
    }

    @Generated
    public void setType(Integer type) {
        this.type = type;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setIp(String ip) {
        this.ip = ip;
    }

    @Generated
    public void setTotalLockTime(Integer totalLockTime) {
        this.totalLockTime = totalLockTime;
    }

    @Generated
    public String toString() {
        return "SslVpnLockModifyOpenApiVO(type=" + this.getType() + ", username=" + this.getUsername() + ", ip=" + this.getIp() + ", totalLockTime=" + this.getTotalLockTime() + ")";
    }

    @Generated
    public SslVpnLockModifyOpenApiVO(Integer type, String username, String ip, Integer totalLockTime) {
        this.type = type;
        this.username = username;
        this.ip = ip;
        this.totalLockTime = totalLockTime;
    }

    @Generated
    public SslVpnLockModifyOpenApiVO() {
    }
}

