/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.vpn.sslvpn;

import com.tplink.smb.omada.manager.configuration.api.web.site.sslvpn.server.RadiusSettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class RadiusSettingOpenApiVO {
    @NotNull
    @Schema(name="radiusProfile", description="Radius profile ID. Radius profile can be created using 'Create a new Radius profile' interface, and Radius profile ID can be obtained from 'Get Radius profile list' interface.")
    private String radiusProfile;
    @NotNull
    @Schema(name="defaultGroup", description="Default user group ID for the user on the radius server. User group can be created using 'Create SSL VPN user group' interface, and user group ID can be obtained from 'Get user group list for SSL VPN server' interface.")
    private String defaultGroup;
    @NotNull
    @Schema(name="authType", description="Authtype should be a value as follows: 0\uff1aPAP; 1:CHAP")
    @Range(min=0L, max=1L, message="AuthType should range between 0 and 1")
    private @NotNull @Range(min=0L, max=1L, message="AuthType should range between 0 and 1") Integer authType;
    @Range(min=1L, max=10L, message="RepeatTime should range between 1 and 10")
    @NotNull
    @Schema(name="repeatTime", description="Repeat time should be within the range of 1\u201310")
    private @Range(min=1L, max=10L, message="RepeatTime should range between 1 and 10") @NotNull Integer repeatTime;
    @Range(min=1L, max=60L, message="OverTime should be within the range of 1\u201360(s)")
    @NotNull
    @Schema(name="overTime", description="Request Timeout, 1~60(s).")
    private @Range(min=1L, max=60L, message="OverTime should be within the range of 1\u201360(s)") @NotNull Integer overTime;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid nas IP.")
    @Schema(name="nasIp", description="NAS IP")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid nas IP.") String nasIp;

    public static RadiusSettingOpenApiVO fromWeb(RadiusSettingVO vo) {
        RadiusSettingOpenApiVO res = new RadiusSettingOpenApiVO();
        if (vo == null) {
            return null;
        }
        res.setRadiusProfile(vo.getRadiusProfile());
        res.setDefaultGroup(vo.getDefaultGroup());
        res.setAuthType(vo.getAuthType());
        res.setRepeatTime(vo.getRepeatTime());
        res.setOverTime(vo.getOverTime());
        res.setNasIp(vo.getNasIp());
        return res;
    }

    public static RadiusSettingVO toWeb(RadiusSettingOpenApiVO vo) {
        RadiusSettingVO res = new RadiusSettingVO();
        if (vo == null) {
            return null;
        }
        res.setRadiusProfile(vo.getRadiusProfile());
        res.setDefaultGroup(vo.getDefaultGroup());
        res.setAuthType(vo.getAuthType());
        res.setRepeatTime(vo.getRepeatTime());
        res.setOverTime(vo.getOverTime());
        res.setNasIp(vo.getNasIp());
        return res;
    }

    @Generated
    public String getRadiusProfile() {
        return this.radiusProfile;
    }

    @Generated
    public String getDefaultGroup() {
        return this.defaultGroup;
    }

    @Generated
    public Integer getAuthType() {
        return this.authType;
    }

    @Generated
    public Integer getRepeatTime() {
        return this.repeatTime;
    }

    @Generated
    public Integer getOverTime() {
        return this.overTime;
    }

    @Generated
    public String getNasIp() {
        return this.nasIp;
    }

    @Generated
    public void setRadiusProfile(String radiusProfile) {
        this.radiusProfile = radiusProfile;
    }

    @Generated
    public void setDefaultGroup(String defaultGroup) {
        this.defaultGroup = defaultGroup;
    }

    @Generated
    public void setAuthType(Integer authType) {
        this.authType = authType;
    }

    @Generated
    public void setRepeatTime(Integer repeatTime) {
        this.repeatTime = repeatTime;
    }

    @Generated
    public void setOverTime(Integer overTime) {
        this.overTime = overTime;
    }

    @Generated
    public void setNasIp(String nasIp) {
        this.nasIp = nasIp;
    }

    @Generated
    public String toString() {
        return "RadiusSettingOpenApiVO(radiusProfile=" + this.getRadiusProfile() + ", defaultGroup=" + this.getDefaultGroup() + ", authType=" + this.getAuthType() + ", repeatTime=" + this.getRepeatTime() + ", overTime=" + this.getOverTime() + ", nasIp=" + this.getNasIp() + ")";
    }
}

