/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.vpn.sslvpn;

import com.tplink.smb.omada.manager.configuration.api.web.site.sslvpn.server.LockSettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Range
public class LockSettingOpenApiVO {
    @NotNull
    @Schema(name="status", description="Status of the SSL VPN server name lock or IP lock.")
    private Boolean status;
    @Schema(name="times", description="The number of login failures that trigger the lock. It is required when parameter [status] is true, and it should be within the range of 1\u201310")
    @Range(min=1L, max=10L, message="lockTimes should range between 1 and 10")
    private @Range(min=1L, max=10L, message="lockTimes should range between 1 and 10") Integer times;
    @Range(min=1L, max=1080L, message="lockDuration should range between 1 and 1080(min). It is required when parameter [status] is true.")
    @Schema(name="duration", description="Lock duration should be within the range of 1\u20131080(min).")
    private @Range(min=1L, max=1080L, message="lockDuration should range between 1 and 1080(min). It is required when parameter [status] is true.") Integer duration;

    public static LockSettingOpenApiVO fromWeb(LockSettingVO vo) {
        LockSettingOpenApiVO res = new LockSettingOpenApiVO();
        if (vo == null) {
            return res;
        }
        res.setStatus(vo.getStatus());
        res.setTimes(vo.getTimes());
        res.setDuration(vo.getDuration());
        return res;
    }

    public static LockSettingVO toWeb(LockSettingOpenApiVO vo) {
        LockSettingVO res = new LockSettingVO();
        if (vo == null) {
            return res;
        }
        res.setStatus(vo.getStatus());
        res.setTimes(vo.getTimes());
        res.setDuration(vo.getDuration());
        return res;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public Integer getTimes() {
        return this.times;
    }

    @Generated
    public Integer getDuration() {
        return this.duration;
    }

    @Generated
    public void setStatus(Boolean status) {
        this.status = status;
    }

    @Generated
    public void setTimes(Integer times) {
        this.times = times;
    }

    @Generated
    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    @Generated
    public String toString() {
        return "LockSettingOpenApiVO(status=" + this.getStatus() + ", times=" + this.getTimes() + ", duration=" + this.getDuration() + ")";
    }
}

