/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.voip.voicemail;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.tplink.smb.omada.manager.configuration.api.web.site.voip.dto.voicemail.VoiceMailSettingRequestVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="VoiceMailSettingRequest")
public class VoiceMailSettingRequestOpenApiVO {
    @Schema(name="omadacId", description="Omadac ID.")
    private String omadacId;
    @Schema(name="siteId", description="Site ID.")
    private String siteId;
    @NotNull
    @JsonProperty(value="enable")
    @Schema(name="enable", description="Whether to enable voice mail settings.")
    private Boolean voiceMailEnable;
    @Range(min=5L, max=60L, message="noAnswerTime should be from 5 to 60")
    @Schema(name="noAnswerTime", description="The no answer time of telephone number. Parameter [noAnswerTime] should be from 5 to 60")
    private @Range(min=5L, max=60L, message="noAnswerTime should be from 5 to 60") Integer noAnswerTime;
    @JsonProperty(value="remoteAccessEnable")
    @Schema(name="remoteAccessEnable", description="Whether voice mail allows remote access.")
    private Boolean remoteAccessToVoiceMail;
    @Pattern(regexp="^\\d{4,8}$", message="Parameter [remoteAccessPin] Invalid.")
    @Schema(name="remoteAccessPin", description="Remote access pin.")
    private @Pattern(regexp="^\\d{4,8}$", message="Parameter [remoteAccessPin] Invalid.") String remoteAccessPin;
    @Schema(name="voiceMailInUsb", description="Whether voice mail is in USB.")
    private Boolean voiceMailInUsb;
    @Range(min=0L, max=1L, message="greetingForVoiceMailMode should be 0 or 1")
    @Schema(name="greetingForVoiceMailMode", description="Parameter [greetingForVoiceMailMode] should be 0 or 1. 0: Default, 1: Custom.")
    private @Range(min=0L, max=1L, message="greetingForVoiceMailMode should be 0 or 1") Integer greetingForVoiceMailMode;
    @Schema(name="greetingName", description="Greeting name.")
    private String greetingName;
    @Range(min=20L, max=120L, message="duration should be from 20 to 120")
    @JsonProperty(value="duration")
    @Schema(name="duration", description="Parameter [duration] should be from 20 to 120.")
    private @Range(min=20L, max=120L, message="duration should be from 20 to 120") Integer voiceMailDuration;
    @Schema(name="usbUuid", description="USB UUID.")
    private String usbUuid;
    @Schema(name="voiceMailCapacity", description="The capacity of voice mail.")
    private Integer voiceMailCapacity;

    public static VoiceMailSettingRequestVO buildWebVO(VoiceMailSettingRequestOpenApiVO openApiVO) {
        if (openApiVO == null) {
            return null;
        }
        VoiceMailSettingRequestVO vo = new VoiceMailSettingRequestVO();
        vo.setOmadacId(openApiVO.getOmadacId());
        vo.setSiteId(openApiVO.getSiteId());
        vo.setVoiceMailEnable(openApiVO.getVoiceMailEnable());
        vo.setNoAnswerTime(openApiVO.getNoAnswerTime());
        vo.setRemoteAccessToVoiceMail(openApiVO.getRemoteAccessToVoiceMail());
        vo.setRemoteAccessPin(openApiVO.getRemoteAccessPin());
        vo.setVoiceMailInUsb(openApiVO.getVoiceMailInUsb());
        vo.setGreetingForVoiceMailMode(openApiVO.getGreetingForVoiceMailMode());
        vo.setGreetingName(openApiVO.getGreetingName());
        vo.setVoiceMailDuration(openApiVO.getVoiceMailDuration());
        vo.setUsbUuid(openApiVO.getUsbUuid());
        vo.setVoiceMailCapacity(openApiVO.getVoiceMailCapacity());
        return vo;
    }

    @Generated
    public String getOmadacId() {
        return this.omadacId;
    }

    @Generated
    public String getSiteId() {
        return this.siteId;
    }

    @Generated
    public Boolean getVoiceMailEnable() {
        return this.voiceMailEnable;
    }

    @Generated
    public Integer getNoAnswerTime() {
        return this.noAnswerTime;
    }

    @Generated
    public Boolean getRemoteAccessToVoiceMail() {
        return this.remoteAccessToVoiceMail;
    }

    @Generated
    public String getRemoteAccessPin() {
        return this.remoteAccessPin;
    }

    @Generated
    public Boolean getVoiceMailInUsb() {
        return this.voiceMailInUsb;
    }

    @Generated
    public Integer getGreetingForVoiceMailMode() {
        return this.greetingForVoiceMailMode;
    }

    @Generated
    public String getGreetingName() {
        return this.greetingName;
    }

    @Generated
    public Integer getVoiceMailDuration() {
        return this.voiceMailDuration;
    }

    @Generated
    public String getUsbUuid() {
        return this.usbUuid;
    }

    @Generated
    public Integer getVoiceMailCapacity() {
        return this.voiceMailCapacity;
    }

    @Generated
    public void setOmadacId(String omadacId) {
        this.omadacId = omadacId;
    }

    @Generated
    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    @JsonProperty(value="enable")
    @Generated
    public void setVoiceMailEnable(Boolean voiceMailEnable) {
        this.voiceMailEnable = voiceMailEnable;
    }

    @Generated
    public void setNoAnswerTime(Integer noAnswerTime) {
        this.noAnswerTime = noAnswerTime;
    }

    @JsonProperty(value="remoteAccessEnable")
    @Generated
    public void setRemoteAccessToVoiceMail(Boolean remoteAccessToVoiceMail) {
        this.remoteAccessToVoiceMail = remoteAccessToVoiceMail;
    }

    @Generated
    public void setRemoteAccessPin(String remoteAccessPin) {
        this.remoteAccessPin = remoteAccessPin;
    }

    @Generated
    public void setVoiceMailInUsb(Boolean voiceMailInUsb) {
        this.voiceMailInUsb = voiceMailInUsb;
    }

    @Generated
    public void setGreetingForVoiceMailMode(Integer greetingForVoiceMailMode) {
        this.greetingForVoiceMailMode = greetingForVoiceMailMode;
    }

    @Generated
    public void setGreetingName(String greetingName) {
        this.greetingName = greetingName;
    }

    @JsonProperty(value="duration")
    @Generated
    public void setVoiceMailDuration(Integer voiceMailDuration) {
        this.voiceMailDuration = voiceMailDuration;
    }

    @Generated
    public void setUsbUuid(String usbUuid) {
        this.usbUuid = usbUuid;
    }

    @Generated
    public void setVoiceMailCapacity(Integer voiceMailCapacity) {
        this.voiceMailCapacity = voiceMailCapacity;
    }

    @Generated
    public String toString() {
        return "VoiceMailSettingRequestOpenApiVO(omadacId=" + this.getOmadacId() + ", siteId=" + this.getSiteId() + ", voiceMailEnable=" + this.getVoiceMailEnable() + ", noAnswerTime=" + this.getNoAnswerTime() + ", remoteAccessToVoiceMail=" + this.getRemoteAccessToVoiceMail() + ", remoteAccessPin=" + this.getRemoteAccessPin() + ", voiceMailInUsb=" + this.getVoiceMailInUsb() + ", greetingForVoiceMailMode=" + this.getGreetingForVoiceMailMode() + ", greetingName=" + this.getGreetingName() + ", voiceMailDuration=" + this.getVoiceMailDuration() + ", usbUuid=" + this.getUsbUuid() + ", voiceMailCapacity=" + this.getVoiceMailCapacity() + ")";
    }

    @Generated
    public VoiceMailSettingRequestOpenApiVO(String omadacId, String siteId, Boolean voiceMailEnable, Integer noAnswerTime, Boolean remoteAccessToVoiceMail, String remoteAccessPin, Boolean voiceMailInUsb, Integer greetingForVoiceMailMode, String greetingName, Integer voiceMailDuration, String usbUuid, Integer voiceMailCapacity) {
        this.omadacId = omadacId;
        this.siteId = siteId;
        this.voiceMailEnable = voiceMailEnable;
        this.noAnswerTime = noAnswerTime;
        this.remoteAccessToVoiceMail = remoteAccessToVoiceMail;
        this.remoteAccessPin = remoteAccessPin;
        this.voiceMailInUsb = voiceMailInUsb;
        this.greetingForVoiceMailMode = greetingForVoiceMailMode;
        this.greetingName = greetingName;
        this.voiceMailDuration = voiceMailDuration;
        this.usbUuid = usbUuid;
        this.voiceMailCapacity = voiceMailCapacity;
    }

    @Generated
    public VoiceMailSettingRequestOpenApiVO() {
    }
}

