/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.voip.dto;

import com.tplink.smb.omada.manager.configuration.api.web.site.voip.VoipTelephoneBookVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="VoipContactPersonSettings")
public class VoipContactPersonOpenApiVO {
    @Pattern(regexp="^[A-Za-z0-9]{0,64}$", message="Parameter [firstName] should be letters or numbers.")
    @Schema(name="firstName", description="The firstName of contact person. It should contain 0 to 64 characters.")
    private @Pattern(regexp="^[A-Za-z0-9]{0,64}$", message="Parameter [firstName] should be letters or numbers.") String firstName;
    @Pattern(regexp="^[A-Za-z0-9]{0,64}$", message="Parameter [lastName] should be letters or numbers.")
    @Schema(name="lastName", description="The lastName of contact person. It should contain 0 to 64 characters.")
    private @Pattern(regexp="^[A-Za-z0-9]{0,64}$", message="Parameter [lastName] should be letters or numbers.") String lastName;
    @Schema(name="privatePhoneNumber", description="The privatePhoneNumber of contact person.")
    private String privatePhoneNumber;
    @Schema(name="workPhoneNumber", description="The workPhoneNumber of contact person.")
    private String workPhoneNumber;
    @Schema(name="mobilePhoneNumber", description="The mobilePhoneNumber of contact person.")
    private String mobilePhoneNumber;
    @Schema(name="speedDialEnable", description="Whether to enable the speedDial.")
    private Boolean speedDialEnable;
    @Range(min=0L, max=2L)
    @Schema(name="speedDialNumberType", description="speedDialNumberType should be a value as follows: 0: Private Phone Number; 1: Work Phone Number; 2: Mobile Phone Number.")
    private @Range(min=0L, max=2L) Integer speedDialNumberType;
    @Schema(name="speedDialNumber", description="The speedDialNumber of contact person.")
    private String speedDialNumber;

    public static VoipTelephoneBookVO toWebVO(VoipContactPersonOpenApiVO vo) {
        VoipTelephoneBookVO voipTelephoneBookVO = new VoipTelephoneBookVO();
        if (vo == null) {
            return voipTelephoneBookVO;
        }
        voipTelephoneBookVO.setFirstName(vo.getFirstName());
        voipTelephoneBookVO.setLastName(vo.getLastName());
        voipTelephoneBookVO.setPrivatePhoneNumber(vo.getPrivatePhoneNumber());
        voipTelephoneBookVO.setWorkPhoneNumber(vo.getWorkPhoneNumber());
        voipTelephoneBookVO.setMobilePhoneNumber(vo.getMobilePhoneNumber());
        voipTelephoneBookVO.setSpeedDialEnable(vo.getSpeedDialEnable());
        voipTelephoneBookVO.setSpeedDialNumberType(vo.getSpeedDialNumberType());
        voipTelephoneBookVO.setSpeedDialNumber(vo.getSpeedDialNumber());
        return voipTelephoneBookVO;
    }

    @Generated
    protected VoipContactPersonOpenApiVO(VoipContactPersonOpenApiVOBuilder<?, ?> b2) {
        this.firstName = b2.firstName;
        this.lastName = b2.lastName;
        this.privatePhoneNumber = b2.privatePhoneNumber;
        this.workPhoneNumber = b2.workPhoneNumber;
        this.mobilePhoneNumber = b2.mobilePhoneNumber;
        this.speedDialEnable = b2.speedDialEnable;
        this.speedDialNumberType = b2.speedDialNumberType;
        this.speedDialNumber = b2.speedDialNumber;
    }

    @Generated
    public static VoipContactPersonOpenApiVOBuilder<?, ?> builder() {
        return new VoipContactPersonOpenApiVOBuilderImpl();
    }

    @Generated
    public String getFirstName() {
        return this.firstName;
    }

    @Generated
    public String getLastName() {
        return this.lastName;
    }

    @Generated
    public String getPrivatePhoneNumber() {
        return this.privatePhoneNumber;
    }

    @Generated
    public String getWorkPhoneNumber() {
        return this.workPhoneNumber;
    }

    @Generated
    public String getMobilePhoneNumber() {
        return this.mobilePhoneNumber;
    }

    @Generated
    public Boolean getSpeedDialEnable() {
        return this.speedDialEnable;
    }

    @Generated
    public Integer getSpeedDialNumberType() {
        return this.speedDialNumberType;
    }

    @Generated
    public String getSpeedDialNumber() {
        return this.speedDialNumber;
    }

    @Generated
    public VoipContactPersonOpenApiVO setFirstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @Generated
    public VoipContactPersonOpenApiVO setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @Generated
    public VoipContactPersonOpenApiVO setPrivatePhoneNumber(String privatePhoneNumber) {
        this.privatePhoneNumber = privatePhoneNumber;
        return this;
    }

    @Generated
    public VoipContactPersonOpenApiVO setWorkPhoneNumber(String workPhoneNumber) {
        this.workPhoneNumber = workPhoneNumber;
        return this;
    }

    @Generated
    public VoipContactPersonOpenApiVO setMobilePhoneNumber(String mobilePhoneNumber) {
        this.mobilePhoneNumber = mobilePhoneNumber;
        return this;
    }

    @Generated
    public VoipContactPersonOpenApiVO setSpeedDialEnable(Boolean speedDialEnable) {
        this.speedDialEnable = speedDialEnable;
        return this;
    }

    @Generated
    public VoipContactPersonOpenApiVO setSpeedDialNumberType(Integer speedDialNumberType) {
        this.speedDialNumberType = speedDialNumberType;
        return this;
    }

    @Generated
    public VoipContactPersonOpenApiVO setSpeedDialNumber(String speedDialNumber) {
        this.speedDialNumber = speedDialNumber;
        return this;
    }

    @Generated
    public String toString() {
        return "VoipContactPersonOpenApiVO(firstName=" + this.getFirstName() + ", lastName=" + this.getLastName() + ", privatePhoneNumber=" + this.getPrivatePhoneNumber() + ", workPhoneNumber=" + this.getWorkPhoneNumber() + ", mobilePhoneNumber=" + this.getMobilePhoneNumber() + ", speedDialEnable=" + this.getSpeedDialEnable() + ", speedDialNumberType=" + this.getSpeedDialNumberType() + ", speedDialNumber=" + this.getSpeedDialNumber() + ")";
    }

    @Generated
    public VoipContactPersonOpenApiVO(String firstName, String lastName, String privatePhoneNumber, String workPhoneNumber, String mobilePhoneNumber, Boolean speedDialEnable, Integer speedDialNumberType, String speedDialNumber) {
        this.firstName = firstName;
        this.lastName = lastName;
        this.privatePhoneNumber = privatePhoneNumber;
        this.workPhoneNumber = workPhoneNumber;
        this.mobilePhoneNumber = mobilePhoneNumber;
        this.speedDialEnable = speedDialEnable;
        this.speedDialNumberType = speedDialNumberType;
        this.speedDialNumber = speedDialNumber;
    }

    @Generated
    public VoipContactPersonOpenApiVO() {
    }

    @Generated
    public static abstract class VoipContactPersonOpenApiVOBuilder<C extends VoipContactPersonOpenApiVO, B extends VoipContactPersonOpenApiVOBuilder<C, B>> {
        @Generated
        private String firstName;
        @Generated
        private String lastName;
        @Generated
        private String privatePhoneNumber;
        @Generated
        private String workPhoneNumber;
        @Generated
        private String mobilePhoneNumber;
        @Generated
        private Boolean speedDialEnable;
        @Generated
        private Integer speedDialNumberType;
        @Generated
        private String speedDialNumber;

        @Generated
        public B firstName(String firstName) {
            this.firstName = firstName;
            return this.self();
        }

        @Generated
        public B lastName(String lastName) {
            this.lastName = lastName;
            return this.self();
        }

        @Generated
        public B privatePhoneNumber(String privatePhoneNumber) {
            this.privatePhoneNumber = privatePhoneNumber;
            return this.self();
        }

        @Generated
        public B workPhoneNumber(String workPhoneNumber) {
            this.workPhoneNumber = workPhoneNumber;
            return this.self();
        }

        @Generated
        public B mobilePhoneNumber(String mobilePhoneNumber) {
            this.mobilePhoneNumber = mobilePhoneNumber;
            return this.self();
        }

        @Generated
        public B speedDialEnable(Boolean speedDialEnable) {
            this.speedDialEnable = speedDialEnable;
            return this.self();
        }

        @Generated
        public B speedDialNumberType(Integer speedDialNumberType) {
            this.speedDialNumberType = speedDialNumberType;
            return this.self();
        }

        @Generated
        public B speedDialNumber(String speedDialNumber) {
            this.speedDialNumber = speedDialNumber;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "VoipContactPersonOpenApiVO.VoipContactPersonOpenApiVOBuilder(firstName=" + this.firstName + ", lastName=" + this.lastName + ", privatePhoneNumber=" + this.privatePhoneNumber + ", workPhoneNumber=" + this.workPhoneNumber + ", mobilePhoneNumber=" + this.mobilePhoneNumber + ", speedDialEnable=" + this.speedDialEnable + ", speedDialNumberType=" + this.speedDialNumberType + ", speedDialNumber=" + this.speedDialNumber + ")";
        }
    }

    @Generated
    private static final class VoipContactPersonOpenApiVOBuilderImpl
    extends VoipContactPersonOpenApiVOBuilder<VoipContactPersonOpenApiVO, VoipContactPersonOpenApiVOBuilderImpl> {
        @Generated
        private VoipContactPersonOpenApiVOBuilderImpl() {
        }

        @Override
        @Generated
        protected VoipContactPersonOpenApiVOBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public VoipContactPersonOpenApiVO build() {
            return new VoipContactPersonOpenApiVO(this);
        }
    }
}

