/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.voip.dto;

import com.tplink.smb.omada.manager.configuration.api.web.site.voip.dto.callforwarding.a.b;
import com.tplink.smb.omada.manager.configuration.api.web.site.voip.dto.callforwarding.embed.CallForwardingRuleVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

@Schema(name="CallForwardingRule")
public class CallForwardingRuleOpenApiVO {
    @Schema(name="omadacId", description="Omadac ID")
    private String omadacId;
    @Schema(name="siteId", description="Site ID")
    private String siteId;
    @Schema(name="ruleId", description="Call Forwarding rule id.")
    private String ruleId;
    @Schema(name="enable", description="enable")
    @NotNull
    private Boolean enable;
    @Schema(name="condition", description="Condition of call forwarding. 0- no answer, 1- unconditional.")
    @NotNull
    private Integer condition;
    @Schema(name="type", description="The type of calls to be forwarded. 0- All Incoming Calls, 1- Calls to the Telephone Number, 2- Calls to the Phone, 3- Calls from a Person in the Telephone Book, 4- Calls from the Telephone Number.")
    @NotNull
    private Integer type;
    @Schema(name="toNumbers", description="Ids of selected numbers. if type = 1, any incoming calls to these numbers will be forwarded.")
    private List<String> toNumbers;
    private List<Integer> toDevices;
    private List<String> fromPersons;
    private List<String> fromNumbers;
    @Schema(name="forwardVia", description="\"Auto\" by default.")
    private String forwardVia;
    @Schema(name="destNumber", description="Destination Telephone Number that incoming calls will be redirected to.")
    @NotNull
    private String destNumber;

    public static CallForwardingRuleOpenApiVO buildFromWebVO(CallForwardingRuleVO vo) {
        if (Objects.isNull(vo)) {
            return null;
        }
        CallForwardingRuleOpenApiVO openApiVO = new CallForwardingRuleOpenApiVO();
        openApiVO.setOmadacId(vo.getOmadacId());
        openApiVO.setSiteId(vo.getSiteId());
        openApiVO.setRuleId(vo.getRuleId());
        openApiVO.setEnable(vo.getEnable());
        openApiVO.setCondition(vo.getCondition());
        openApiVO.setType(vo.getType());
        b typeEnum = b.a((Integer)vo.getType());
        if (typeEnum == null) {
            return null;
        }
        switch (typeEnum) {
            case b: {
                openApiVO.setToNumbers(new ArrayList<String>(vo.getToNumbers()));
                break;
            }
            case c: {
                openApiVO.setToDevices(new ArrayList<Integer>(vo.getToDevices()));
                break;
            }
            case d: {
                openApiVO.setFromPersons(new ArrayList<String>(vo.getFromPersons()));
                break;
            }
            case e: {
                openApiVO.setFromNumbers(new ArrayList<String>(vo.getFromNumbers()));
                break;
            }
        }
        openApiVO.setForwardVia(vo.getForwardVia());
        openApiVO.setDestNumber(vo.getDestNumber());
        return openApiVO;
    }

    @Generated
    protected CallForwardingRuleOpenApiVO(CallForwardingRuleOpenApiVOBuilder<?, ?> b2) {
        this.omadacId = b2.omadacId;
        this.siteId = b2.siteId;
        this.ruleId = b2.ruleId;
        this.enable = b2.enable;
        this.condition = b2.condition;
        this.type = b2.type;
        this.toNumbers = b2.toNumbers;
        this.toDevices = b2.toDevices;
        this.fromPersons = b2.fromPersons;
        this.fromNumbers = b2.fromNumbers;
        this.forwardVia = b2.forwardVia;
        this.destNumber = b2.destNumber;
    }

    @Generated
    public static CallForwardingRuleOpenApiVOBuilder<?, ?> builder() {
        return new CallForwardingRuleOpenApiVOBuilderImpl();
    }

    @Generated
    public String getOmadacId() {
        return this.omadacId;
    }

    @Generated
    public String getSiteId() {
        return this.siteId;
    }

    @Generated
    public String getRuleId() {
        return this.ruleId;
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public Integer getCondition() {
        return this.condition;
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public List<String> getToNumbers() {
        return this.toNumbers;
    }

    @Generated
    public List<Integer> getToDevices() {
        return this.toDevices;
    }

    @Generated
    public List<String> getFromPersons() {
        return this.fromPersons;
    }

    @Generated
    public List<String> getFromNumbers() {
        return this.fromNumbers;
    }

    @Generated
    public String getForwardVia() {
        return this.forwardVia;
    }

    @Generated
    public String getDestNumber() {
        return this.destNumber;
    }

    @Generated
    public CallForwardingRuleOpenApiVO setOmadacId(String omadacId) {
        this.omadacId = omadacId;
        return this;
    }

    @Generated
    public CallForwardingRuleOpenApiVO setSiteId(String siteId) {
        this.siteId = siteId;
        return this;
    }

    @Generated
    public CallForwardingRuleOpenApiVO setRuleId(String ruleId) {
        this.ruleId = ruleId;
        return this;
    }

    @Generated
    public CallForwardingRuleOpenApiVO setEnable(Boolean enable) {
        this.enable = enable;
        return this;
    }

    @Generated
    public CallForwardingRuleOpenApiVO setCondition(Integer condition) {
        this.condition = condition;
        return this;
    }

    @Generated
    public CallForwardingRuleOpenApiVO setType(Integer type) {
        this.type = type;
        return this;
    }

    @Generated
    public CallForwardingRuleOpenApiVO setToNumbers(List<String> toNumbers) {
        this.toNumbers = toNumbers;
        return this;
    }

    @Generated
    public CallForwardingRuleOpenApiVO setToDevices(List<Integer> toDevices) {
        this.toDevices = toDevices;
        return this;
    }

    @Generated
    public CallForwardingRuleOpenApiVO setFromPersons(List<String> fromPersons) {
        this.fromPersons = fromPersons;
        return this;
    }

    @Generated
    public CallForwardingRuleOpenApiVO setFromNumbers(List<String> fromNumbers) {
        this.fromNumbers = fromNumbers;
        return this;
    }

    @Generated
    public CallForwardingRuleOpenApiVO setForwardVia(String forwardVia) {
        this.forwardVia = forwardVia;
        return this;
    }

    @Generated
    public CallForwardingRuleOpenApiVO setDestNumber(String destNumber) {
        this.destNumber = destNumber;
        return this;
    }

    @Generated
    public String toString() {
        return "CallForwardingRuleOpenApiVO(omadacId=" + this.getOmadacId() + ", siteId=" + this.getSiteId() + ", ruleId=" + this.getRuleId() + ", enable=" + this.getEnable() + ", condition=" + this.getCondition() + ", type=" + this.getType() + ", toNumbers=" + this.getToNumbers() + ", toDevices=" + this.getToDevices() + ", fromPersons=" + this.getFromPersons() + ", fromNumbers=" + this.getFromNumbers() + ", forwardVia=" + this.getForwardVia() + ", destNumber=" + this.getDestNumber() + ")";
    }

    @Generated
    public CallForwardingRuleOpenApiVO(String omadacId, String siteId, String ruleId, Boolean enable, Integer condition, Integer type, List<String> toNumbers, List<Integer> toDevices, List<String> fromPersons, List<String> fromNumbers, String forwardVia, String destNumber) {
        this.omadacId = omadacId;
        this.siteId = siteId;
        this.ruleId = ruleId;
        this.enable = enable;
        this.condition = condition;
        this.type = type;
        this.toNumbers = toNumbers;
        this.toDevices = toDevices;
        this.fromPersons = fromPersons;
        this.fromNumbers = fromNumbers;
        this.forwardVia = forwardVia;
        this.destNumber = destNumber;
    }

    @Generated
    public CallForwardingRuleOpenApiVO() {
    }

    @Generated
    public static abstract class CallForwardingRuleOpenApiVOBuilder<C extends CallForwardingRuleOpenApiVO, B extends CallForwardingRuleOpenApiVOBuilder<C, B>> {
        @Generated
        private String omadacId;
        @Generated
        private String siteId;
        @Generated
        private String ruleId;
        @Generated
        private Boolean enable;
        @Generated
        private Integer condition;
        @Generated
        private Integer type;
        @Generated
        private List<String> toNumbers;
        @Generated
        private List<Integer> toDevices;
        @Generated
        private List<String> fromPersons;
        @Generated
        private List<String> fromNumbers;
        @Generated
        private String forwardVia;
        @Generated
        private String destNumber;

        @Generated
        public B omadacId(String omadacId) {
            this.omadacId = omadacId;
            return this.self();
        }

        @Generated
        public B siteId(String siteId) {
            this.siteId = siteId;
            return this.self();
        }

        @Generated
        public B ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this.self();
        }

        @Generated
        public B enable(Boolean enable) {
            this.enable = enable;
            return this.self();
        }

        @Generated
        public B condition(Integer condition) {
            this.condition = condition;
            return this.self();
        }

        @Generated
        public B type(Integer type) {
            this.type = type;
            return this.self();
        }

        @Generated
        public B toNumbers(List<String> toNumbers) {
            this.toNumbers = toNumbers;
            return this.self();
        }

        @Generated
        public B toDevices(List<Integer> toDevices) {
            this.toDevices = toDevices;
            return this.self();
        }

        @Generated
        public B fromPersons(List<String> fromPersons) {
            this.fromPersons = fromPersons;
            return this.self();
        }

        @Generated
        public B fromNumbers(List<String> fromNumbers) {
            this.fromNumbers = fromNumbers;
            return this.self();
        }

        @Generated
        public B forwardVia(String forwardVia) {
            this.forwardVia = forwardVia;
            return this.self();
        }

        @Generated
        public B destNumber(String destNumber) {
            this.destNumber = destNumber;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "CallForwardingRuleOpenApiVO.CallForwardingRuleOpenApiVOBuilder(omadacId=" + this.omadacId + ", siteId=" + this.siteId + ", ruleId=" + this.ruleId + ", enable=" + this.enable + ", condition=" + this.condition + ", type=" + this.type + ", toNumbers=" + this.toNumbers + ", toDevices=" + this.toDevices + ", fromPersons=" + this.fromPersons + ", fromNumbers=" + this.fromNumbers + ", forwardVia=" + this.forwardVia + ", destNumber=" + this.destNumber + ")";
        }
    }

    @Generated
    private static final class CallForwardingRuleOpenApiVOBuilderImpl
    extends CallForwardingRuleOpenApiVOBuilder<CallForwardingRuleOpenApiVO, CallForwardingRuleOpenApiVOBuilderImpl> {
        @Generated
        private CallForwardingRuleOpenApiVOBuilderImpl() {
        }

        @Override
        @Generated
        protected CallForwardingRuleOpenApiVOBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public CallForwardingRuleOpenApiVO build() {
            return new CallForwardingRuleOpenApiVO(this);
        }
    }
}

