/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.voip;

import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.configuration.api.web.site.voip.dto.callsettings.DndSettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="DndSettingEntity")
public class DndSettingOpenApiVO {
    @Schema(name="omadacId", description="Omadac ID")
    private String omadacId;
    @Schema(name="siteId", description="Site ID")
    private String siteId;
    @NotNull
    @Schema(name="enable", description="Enable DND or not")
    private Boolean enable;
    @Schema(name="dayMode", description="The days you want to block the incoming calls. 1-daily\uff0c2-weekend\uff0c3-weekday")
    @NumberSet(value={1, 2, 3})
    private Integer dayMode;
    @Schema(name="timeBegin", description="The start time of the DND period you want to block incoming calls. It should be an integer value between 0 and 1438.")
    @Range(min=0L, max=1438L)
    private @Range(min=0L, max=1438L) Integer timeBegin;
    @Schema(name="timeEnd", description="The end time of the DND period you want to block incoming calls. It should be an integer value between 1 and 1439.")
    @Range(min=1L, max=1439L)
    private @Range(min=1L, max=1439L) Integer timeEnd;

    public static DndSettingOpenApiVO fromWebVO(DndSettingVO vo) {
        if (Objects.isNull(vo)) {
            return null;
        }
        DndSettingOpenApiVO dndSettingOpenApiVO = new DndSettingOpenApiVO();
        dndSettingOpenApiVO.setOmadacId(vo.getOmadacId());
        dndSettingOpenApiVO.setSiteId(vo.getSiteId());
        dndSettingOpenApiVO.setEnable(vo.getEnable());
        dndSettingOpenApiVO.setDayMode(vo.getDayMode());
        dndSettingOpenApiVO.setTimeBegin(vo.getTimeBegin());
        dndSettingOpenApiVO.setTimeEnd(vo.getTimeEnd());
        return dndSettingOpenApiVO;
    }

    public DndSettingVO toWebVO() {
        return DndSettingVO.builder().omadacId(this.omadacId).siteId(this.siteId).enable(this.enable).dayMode(this.dayMode).timeBegin(this.timeBegin).timeEnd(this.timeEnd).build();
    }

    @Generated
    public String getOmadacId() {
        return this.omadacId;
    }

    @Generated
    public String getSiteId() {
        return this.siteId;
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public Integer getDayMode() {
        return this.dayMode;
    }

    @Generated
    public Integer getTimeBegin() {
        return this.timeBegin;
    }

    @Generated
    public Integer getTimeEnd() {
        return this.timeEnd;
    }

    @Generated
    public void setOmadacId(String omadacId) {
        this.omadacId = omadacId;
    }

    @Generated
    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    @Generated
    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    @Generated
    public void setDayMode(Integer dayMode) {
        this.dayMode = dayMode;
    }

    @Generated
    public void setTimeBegin(Integer timeBegin) {
        this.timeBegin = timeBegin;
    }

    @Generated
    public void setTimeEnd(Integer timeEnd) {
        this.timeEnd = timeEnd;
    }

    @Generated
    public String toString() {
        return "DndSettingOpenApiVO(omadacId=" + this.getOmadacId() + ", siteId=" + this.getSiteId() + ", enable=" + this.getEnable() + ", dayMode=" + this.getDayMode() + ", timeBegin=" + this.getTimeBegin() + ", timeEnd=" + this.getTimeEnd() + ")";
    }

    @Generated
    public DndSettingOpenApiVO(String omadacId, String siteId, Boolean enable, Integer dayMode, Integer timeBegin, Integer timeEnd) {
        this.omadacId = omadacId;
        this.siteId = siteId;
        this.enable = enable;
        this.dayMode = dayMode;
        this.timeBegin = timeBegin;
        this.timeEnd = timeEnd;
    }

    @Generated
    public DndSettingOpenApiVO() {
    }
}

