/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.transmission.sessionlimit;

import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.dto.SessionLimitRuleVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class SessionLimitRuleTemplateOpenApiVO {
    @Schema(name="name", description="Name should contain 1 to 64 characters.")
    @NotNull(message="SessionLimitRule parameter [name] should not be null")
    @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be visible ASCII, between 1 and 64 characters.")
    private @NotNull(message="SessionLimitRule parameter [name] should not be null") @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be visible ASCII, between 1 and 64 characters.") String name;
    @Schema(name="status", description="Status of the session limit rule.")
    @NotNull(message="SessionLimitRule parameter [status] should not be null")
    private @NotNull(message="SessionLimitRule parameter [status] should not be null") Boolean status;
    @Schema(name="sourceType", description="Source type should be a value as follows: 0: network; 1: IP group; 2: IP.")
    @NotNull(message="SessionLimitRule parameter [sourceType] should not be null")
    @Range(min=0L, max=2L)
    private @NotNull(message="SessionLimitRule parameter [sourceType] should not be null") @Range(min=0L, max=2L) Integer sourceType;
    @Schema(name="sourceIds", description="Source IDs of the session limit rule, only for network and IP group type.Network can be created using 'Create LAN network template' interface, and network ID can be obtained from 'Get LAN network template list' interface. IP group can be created using 'Create a new group profile template' interface, and IP group ID can be obtained from 'Get group profile template list' interface.")
    private List<String> sourceIds;
    @Schema(name="ip", description="IP of the session limit rule.")
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="SessionLimitRule parameter [ip] should be a valid IP address.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="SessionLimitRule parameter [ip] should be a valid IP address.") String ip;
    @Schema(name="maxSession", description="Max sessions should be within the range of 1\u2013999999.")
    @NotNull(message="SessionLimitRule parameter [maxSession] should not be null")
    @Range(min=1L, max=999999L, message="Value of Max Sessions is from 1 to 999999.")
    private @NotNull(message="SessionLimitRule parameter [maxSession] should not be null") @Range(min=1L, max=999999L, message="Value of Max Sessions is from 1 to 999999.") Integer maxSession;

    public static SessionLimitRuleVO toVO(SessionLimitRuleTemplateOpenApiVO openApiVO) {
        SessionLimitRuleVO vo = new SessionLimitRuleVO();
        vo.setName(openApiVO.getName());
        vo.setStatus(openApiVO.getStatus());
        vo.setSourceType(openApiVO.getSourceType());
        vo.setSourceIds(openApiVO.getSourceIds());
        vo.setIp(openApiVO.getIp());
        vo.setMaxSession(openApiVO.getMaxSession());
        return vo;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public Integer getSourceType() {
        return this.sourceType;
    }

    @Generated
    public List<String> getSourceIds() {
        return this.sourceIds;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public Integer getMaxSession() {
        return this.maxSession;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setStatus(Boolean status) {
        this.status = status;
    }

    @Generated
    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    @Generated
    public void setSourceIds(List<String> sourceIds) {
        this.sourceIds = sourceIds;
    }

    @Generated
    public void setIp(String ip) {
        this.ip = ip;
    }

    @Generated
    public void setMaxSession(Integer maxSession) {
        this.maxSession = maxSession;
    }

    @Generated
    public String toString() {
        return "SessionLimitRuleTemplateOpenApiVO(name=" + this.getName() + ", status=" + this.getStatus() + ", sourceType=" + this.getSourceType() + ", sourceIds=" + this.getSourceIds() + ", ip=" + this.getIp() + ", maxSession=" + this.getMaxSession() + ")";
    }

    @Generated
    public SessionLimitRuleTemplateOpenApiVO(String name, Boolean status, Integer sourceType, List<String> sourceIds, String ip, Integer maxSession) {
        this.name = name;
        this.status = status;
        this.sourceType = sourceType;
        this.sourceIds = sourceIds;
        this.ip = ip;
        this.maxSession = maxSession;
    }

    @Generated
    public SessionLimitRuleTemplateOpenApiVO() {
    }
}

