/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.transmission.sessionlimit;

import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.dto.SessionLimitRuleVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class QuerySessionLimitRuleOpenApiVO {
    @Schema(name="id", description="ID of the session limit rule.")
    private String id;
    @Schema(name="index", description="Index of the session limit rule. When the [sourceType] is 0 or 1, the index is counted in order, when the sourceType is 2, the index is always -1")
    private Integer index;
    @Schema(name="name", description="Name should contain 1 to 64 characters.")
    @NotNull(message="SessionLimitRule parameter [name] should not be null")
    @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be visible ASCII, between 1 and 64 characters.")
    private @NotNull(message="SessionLimitRule parameter [name] should not be null") @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be visible ASCII, between 1 and 64 characters.") String name;
    @Schema(name="status", description="Status of the session limit rule.")
    @NotNull(message="SessionLimitRule parameter [status] should not be null")
    private @NotNull(message="SessionLimitRule parameter [status] should not be null") Boolean status;
    @Schema(name="sourceType", description="Source type should be a value as follows: 0: network; 1: IP group; 2: IP.")
    @NotNull(message="SessionLimitRule parameter [sourceType] should not be null")
    @Range(min=0L, max=2L)
    private @NotNull(message="SessionLimitRule parameter [sourceType] should not be null") @Range(min=0L, max=2L) Integer sourceType;
    @Schema(name="sourceIds", description="Source IDs of the session limit rule, only for network and IP group type.Network can be created using 'Create LAN network' interface, and network ID can be obtained from 'Get LAN network list' interface. IP group can be created using 'Create a new group profile' interface, and IP group ID can be obtained from 'Get group profile list' interface.")
    private List<String> sourceIds;
    @Schema(name="ip", description="IP of the session limit rule.")
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="SessionLimitRule parameter [ip] should be a valid IP address.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="SessionLimitRule parameter [ip] should be a valid IP address.") String ip;
    @Schema(name="maxSession", description="Max sessions should be within the range of 1\u2013999999.")
    @NotNull(message="SessionLimitRule parameter [maxSession] should not be null")
    @Range(min=1L, max=999999L, message="Value of Max Sessions is from 1 to 999999.")
    private @NotNull(message="SessionLimitRule parameter [maxSession] should not be null") @Range(min=1L, max=999999L, message="Value of Max Sessions is from 1 to 999999.") Integer maxSession;
    @Schema(name="existIpAddress", description="Whether Source Type of Current Session Limit rule is IP Address.")
    private Boolean existIpAddress;

    public static QuerySessionLimitRuleOpenApiVO toOpenApiVO(SessionLimitRuleVO vo) {
        if (vo == null) {
            return new QuerySessionLimitRuleOpenApiVO();
        }
        QuerySessionLimitRuleOpenApiVO querySessionLimitRuleOpenApiVO = new QuerySessionLimitRuleOpenApiVO();
        querySessionLimitRuleOpenApiVO.setId(vo.getId());
        querySessionLimitRuleOpenApiVO.setIndex(vo.getIndex());
        querySessionLimitRuleOpenApiVO.setName(vo.getName());
        querySessionLimitRuleOpenApiVO.setStatus(vo.getStatus());
        querySessionLimitRuleOpenApiVO.setSourceType(vo.getSourceType());
        querySessionLimitRuleOpenApiVO.setSourceIds(vo.getSourceIds());
        querySessionLimitRuleOpenApiVO.setIp(vo.getIp());
        querySessionLimitRuleOpenApiVO.setMaxSession(vo.getMaxSession());
        querySessionLimitRuleOpenApiVO.setExistIpAddress(vo.getExistIpSession());
        return querySessionLimitRuleOpenApiVO;
    }

    public static GridVO<QuerySessionLimitRuleOpenApiVO> toOpenApiGridVO(@Nonnull GridVO<SessionLimitRuleVO> gridVO) {
        GridVO openApiGridVO = new GridVO();
        openApiGridVO.setTotalRows(gridVO.getTotalRows());
        openApiGridVO.setCurrentPage(gridVO.getCurrentPage());
        openApiGridVO.setCurrentSize(gridVO.getCurrentSize());
        openApiGridVO.setData(gridVO.getData().stream().map(QuerySessionLimitRuleOpenApiVO::toOpenApiVO).collect(Collectors.toList()));
        return openApiGridVO;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Integer getIndex() {
        return this.index;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public Integer getSourceType() {
        return this.sourceType;
    }

    @Generated
    public List<String> getSourceIds() {
        return this.sourceIds;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public Integer getMaxSession() {
        return this.maxSession;
    }

    @Generated
    public Boolean getExistIpAddress() {
        return this.existIpAddress;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setIndex(Integer index) {
        this.index = index;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setStatus(Boolean status) {
        this.status = status;
    }

    @Generated
    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    @Generated
    public void setSourceIds(List<String> sourceIds) {
        this.sourceIds = sourceIds;
    }

    @Generated
    public void setIp(String ip) {
        this.ip = ip;
    }

    @Generated
    public void setMaxSession(Integer maxSession) {
        this.maxSession = maxSession;
    }

    @Generated
    public void setExistIpAddress(Boolean existIpAddress) {
        this.existIpAddress = existIpAddress;
    }

    @Generated
    public String toString() {
        return "QuerySessionLimitRuleOpenApiVO(id=" + this.getId() + ", index=" + this.getIndex() + ", name=" + this.getName() + ", status=" + this.getStatus() + ", sourceType=" + this.getSourceType() + ", sourceIds=" + this.getSourceIds() + ", ip=" + this.getIp() + ", maxSession=" + this.getMaxSession() + ", existIpAddress=" + this.getExistIpAddress() + ")";
    }

    @Generated
    public QuerySessionLimitRuleOpenApiVO(String id, Integer index, String name, Boolean status, Integer sourceType, List<String> sourceIds, String ip, Integer maxSession, Boolean existIpAddress) {
        this.id = id;
        this.index = index;
        this.name = name;
        this.status = status;
        this.sourceType = sourceType;
        this.sourceIds = sourceIds;
        this.ip = ip;
        this.maxSession = maxSession;
        this.existIpAddress = existIpAddress;
    }

    @Generated
    public QuerySessionLimitRuleOpenApiVO() {
    }
}

