/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.transmission.bandwidthctrl;

import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.dto.BandwidthPortSettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="BandwidthPortSetting")
public class BandwidthPortSettingOpenApiVO {
    @Schema(name="portUuid", description="Port uuid.")
    @NotNull(message="BandwidthPortSetting parameter [portUuid] should not be null")
    private @NotNull(message="BandwidthPortSetting parameter [portUuid] should not be null") String portUuid;
    @Schema(name="upstreamBandwidth", description="Upstream bandwidth should be within the range of 1\u20139999999.")
    @Range(min=1L, max=9999999L, message="Parameter [upstreamBandwidth] should between 1 and 9999999.")
    private @Range(min=1L, max=9999999L, message="Parameter [upstreamBandwidth] should between 1 and 9999999.") Integer upstreamBandwidth;
    @Schema(name="upstreamBandwidthUnit", description="Upstream bandwidth unit should be a value as follows: 1: Kbps, 2: Mbps.")
    @NumberSet(value={1, 2})
    private Integer upstreamBandwidthUnit;
    @Schema(name="downstreamBandwidth", description="Downstream bandwidth should be within the range of 1\u20139999999.")
    @Range(min=1L, max=9999999L, message="Parameter [downstreamBandwidth] should between 1 and 9999999.")
    private @Range(min=1L, max=9999999L, message="Parameter [downstreamBandwidth] should between 1 and 9999999.") Integer downstreamBandwidth;
    @Schema(name="downstreamBandwidthUnit", description="Downstream bandwidth unit should be a value as follows: 1: Kbps, 2: Mbps.")
    @NumberSet(value={1, 2})
    private Integer downstreamBandwidthUnit;

    public static BandwidthPortSettingOpenApiVO toOpenApiVO(BandwidthPortSettingVO vo) {
        if (vo == null) {
            return new BandwidthPortSettingOpenApiVO();
        }
        BandwidthPortSettingOpenApiVO bandwidthPortSettingOpenApiVO = new BandwidthPortSettingOpenApiVO();
        bandwidthPortSettingOpenApiVO.setPortUuid(vo.getPortUuid());
        bandwidthPortSettingOpenApiVO.setUpstreamBandwidth(vo.getUpstreamBandwidth());
        bandwidthPortSettingOpenApiVO.setUpstreamBandwidthUnit(vo.getUpstreamBandwidthUnit());
        bandwidthPortSettingOpenApiVO.setDownstreamBandwidth(vo.getDownstreamBandwidth());
        bandwidthPortSettingOpenApiVO.setDownstreamBandwidthUnit(vo.getDownstreamBandwidthUnit());
        return bandwidthPortSettingOpenApiVO;
    }

    public static BandwidthPortSettingVO toVO(BandwidthPortSettingOpenApiVO openApiVO) {
        BandwidthPortSettingVO vo = new BandwidthPortSettingVO();
        vo.setPortUuid(openApiVO.getPortUuid());
        vo.setUpstreamBandwidth(openApiVO.getUpstreamBandwidth());
        vo.setUpstreamBandwidthUnit(openApiVO.getUpstreamBandwidthUnit());
        vo.setDownstreamBandwidth(openApiVO.getDownstreamBandwidth());
        vo.setDownstreamBandwidthUnit(openApiVO.getDownstreamBandwidthUnit());
        return vo;
    }

    @Generated
    public String getPortUuid() {
        return this.portUuid;
    }

    @Generated
    public Integer getUpstreamBandwidth() {
        return this.upstreamBandwidth;
    }

    @Generated
    public Integer getUpstreamBandwidthUnit() {
        return this.upstreamBandwidthUnit;
    }

    @Generated
    public Integer getDownstreamBandwidth() {
        return this.downstreamBandwidth;
    }

    @Generated
    public Integer getDownstreamBandwidthUnit() {
        return this.downstreamBandwidthUnit;
    }

    @Generated
    public void setPortUuid(String portUuid) {
        this.portUuid = portUuid;
    }

    @Generated
    public void setUpstreamBandwidth(Integer upstreamBandwidth) {
        this.upstreamBandwidth = upstreamBandwidth;
    }

    @Generated
    public void setUpstreamBandwidthUnit(Integer upstreamBandwidthUnit) {
        this.upstreamBandwidthUnit = upstreamBandwidthUnit;
    }

    @Generated
    public void setDownstreamBandwidth(Integer downstreamBandwidth) {
        this.downstreamBandwidth = downstreamBandwidth;
    }

    @Generated
    public void setDownstreamBandwidthUnit(Integer downstreamBandwidthUnit) {
        this.downstreamBandwidthUnit = downstreamBandwidthUnit;
    }

    @Generated
    public String toString() {
        return "BandwidthPortSettingOpenApiVO(portUuid=" + this.getPortUuid() + ", upstreamBandwidth=" + this.getUpstreamBandwidth() + ", upstreamBandwidthUnit=" + this.getUpstreamBandwidthUnit() + ", downstreamBandwidth=" + this.getDownstreamBandwidth() + ", downstreamBandwidthUnit=" + this.getDownstreamBandwidthUnit() + ")";
    }

    @Generated
    public BandwidthPortSettingOpenApiVO(String portUuid, Integer upstreamBandwidth, Integer upstreamBandwidthUnit, Integer downstreamBandwidth, Integer downstreamBandwidthUnit) {
        this.portUuid = portUuid;
        this.upstreamBandwidth = upstreamBandwidth;
        this.upstreamBandwidthUnit = upstreamBandwidthUnit;
        this.downstreamBandwidth = downstreamBandwidth;
        this.downstreamBandwidthUnit = downstreamBandwidthUnit;
    }

    @Generated
    public BandwidthPortSettingOpenApiVO() {
    }
}

