/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.transmission.bandwidthctrl;

import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.dto.BandwidthCtrlRuleVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="BandwidthControlRule")
public class BandwidthCtrlRuleOpenApiVO {
    @Schema(name="id", description="ID of the bandwidth control rule.")
    private String id;
    @Schema(name="name", description="Name should contain 1 to 64 characters.")
    @NotNull(message="BandwidthCtrlRule parameter [name] should not be null")
    @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be visible ASCII, between 1 and 64 characters.")
    private @NotNull(message="BandwidthCtrlRule parameter [name] should not be null") @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be visible ASCII, between 1 and 64 characters.") String name;
    @Schema(name="index", description="Index of the bandwidth control rule.")
    private Integer index;
    @Schema(name="status", description="Status of the bandwidth control rule.")
    @NotNull(message="BandwidthCtrlRule parameter [status] should not be null")
    private @NotNull(message="BandwidthCtrlRule parameter [status] should not be null") Boolean status;
    @Schema(name="sourceType", description="Source type should be a value as follows: 0: network; 1: IP group.")
    @NumberSet(value={0, 1})
    private Integer sourceType;
    @Schema(name="sourceIds", description="Source IDs of the bandwidth control rule. Network can be created using 'Create LAN network' interface, and network ID can be obtained from 'Get LAN network list' interface. IP group can be created using 'Create a new group profile' interface, and IP group ID can be obtained from 'Get group profile list' interface.")
    @NotNull(message="BandwidthCtrlRule parameter [sourceIds] should not be null")
    private @NotNull(message="BandwidthCtrlRule parameter [sourceIds] should not be null") List<String> sourceIds;
    @Schema(name="wanPortIds", description="WAN port IDs of the bandwidth control rule.WAN port ID can be obtained from 'Get internet basic info' interface.")
    @NotNull(message="BandwidthCtrlRule parameter [wanPortIds] should not be null")
    private @NotNull(message="BandwidthCtrlRule parameter [wanPortIds] should not be null") List<String> wanPortIds;
    @Schema(name="upstreamBandwidth", description="Upstream bandwidth should be within the range of 1\u20139999999.")
    @NotNull(message="BandwidthCtrlRule parameter [upstreamBandwidth] should not be null")
    @Range(min=1L, max=9999999L, message="Parameter [UpstreamBandwidth] should between 1 and 9999999.")
    private @NotNull(message="BandwidthCtrlRule parameter [upstreamBandwidth] should not be null") @Range(min=1L, max=9999999L, message="Parameter [UpstreamBandwidth] should between 1 and 9999999.") Integer upstreamBandwidth;
    @Schema(name="upstreamBandwidthUnit", description="Upstream bandwidth unit should be a value as follows: 1: Kbps, 2: Mbps.")
    @NotNull(message="BandwidthCtrlRule parameter [upstreamBandwidthUnit] should not be null")
    @NumberSet(value={1, 2})
    private @NotNull(message="BandwidthCtrlRule parameter [upstreamBandwidthUnit] should not be null") Integer upstreamBandwidthUnit;
    @Schema(name="downstreamBandwidth", description="Downstream bandwidth should be within the range of 1\u20139999999.")
    @NotNull(message="BandwidthCtrlRule parameter [downstreamBandwidth] should not be null")
    @Range(min=1L, max=9999999L, message="Parameter [DownstreamBandwidth] should between 1 and 9999999.")
    private @NotNull(message="BandwidthCtrlRule parameter [downstreamBandwidth] should not be null") @Range(min=1L, max=9999999L, message="Parameter [DownstreamBandwidth] should between 1 and 9999999.") Integer downstreamBandwidth;
    @Schema(name="downstreamBandwidthUnit", description="Downstream bandwidth unit should be a value as follows: 1: Kbps, 2: Mbps.")
    @NotNull(message="BandwidthCtrlRule parameter [downstreamBandwidthUnit] should not be null")
    @NumberSet(value={1, 2})
    private @NotNull(message="BandwidthCtrlRule parameter [downstreamBandwidthUnit] should not be null") Integer downstreamBandwidthUnit;
    @Schema(name="mode", description="Mode should be a value as follows: 0: share; 1: individual.")
    @NotNull(message="BandwidthCtrlRule parameter [mode] should not be null")
    @NumberSet(value={0, 1})
    private @NotNull(message="BandwidthCtrlRule parameter [mode] should not be null") Integer mode;

    public static BandwidthCtrlRuleOpenApiVO toOpenApiVO(BandwidthCtrlRuleVO vo) {
        if (vo == null) {
            return new BandwidthCtrlRuleOpenApiVO();
        }
        BandwidthCtrlRuleOpenApiVO bandwidthCtrlRuleOpenApiVO = new BandwidthCtrlRuleOpenApiVO();
        bandwidthCtrlRuleOpenApiVO.setId(vo.getId());
        bandwidthCtrlRuleOpenApiVO.setIndex(vo.getIndex());
        bandwidthCtrlRuleOpenApiVO.setName(vo.getName());
        bandwidthCtrlRuleOpenApiVO.setStatus(vo.getStatus());
        bandwidthCtrlRuleOpenApiVO.setSourceType(vo.getSourceType());
        bandwidthCtrlRuleOpenApiVO.setSourceIds(vo.getSourceIds());
        bandwidthCtrlRuleOpenApiVO.setWanPortIds(vo.getWanPortIds());
        bandwidthCtrlRuleOpenApiVO.setUpstreamBandwidth(vo.getUpstreamBandwidth());
        bandwidthCtrlRuleOpenApiVO.setUpstreamBandwidthUnit(vo.getUpstreamBandwidthUnit());
        bandwidthCtrlRuleOpenApiVO.setDownstreamBandwidth(vo.getDownstreamBandwidth());
        bandwidthCtrlRuleOpenApiVO.setDownstreamBandwidthUnit(vo.getDownstreamBandwidthUnit());
        bandwidthCtrlRuleOpenApiVO.setMode(vo.getMode());
        return bandwidthCtrlRuleOpenApiVO;
    }

    public static GridVO<BandwidthCtrlRuleOpenApiVO> toOpenApiGridVO(@Nonnull GridVO<BandwidthCtrlRuleVO> gridVO) {
        GridVO openApiGridVO = new GridVO();
        openApiGridVO.setTotalRows(gridVO.getTotalRows());
        openApiGridVO.setCurrentPage(gridVO.getCurrentPage());
        openApiGridVO.setCurrentSize(gridVO.getCurrentSize());
        openApiGridVO.setData(gridVO.getData().stream().map(BandwidthCtrlRuleOpenApiVO::toOpenApiVO).collect(Collectors.toList()));
        return openApiGridVO;
    }

    public static BandwidthCtrlRuleVO toVO(BandwidthCtrlRuleOpenApiVO openApiVO) {
        BandwidthCtrlRuleVO vo = new BandwidthCtrlRuleVO();
        vo.setId(openApiVO.getId());
        vo.setIndex(openApiVO.getIndex());
        vo.setName(openApiVO.getName());
        vo.setStatus(openApiVO.getStatus());
        vo.setSourceType(openApiVO.getSourceType());
        vo.setSourceIds(openApiVO.getSourceIds());
        vo.setWanPortIds(openApiVO.getWanPortIds());
        vo.setUpstreamBandwidth(openApiVO.getUpstreamBandwidth());
        vo.setUpstreamBandwidthUnit(openApiVO.getUpstreamBandwidthUnit());
        vo.setDownstreamBandwidth(openApiVO.getDownstreamBandwidth());
        vo.setDownstreamBandwidthUnit(openApiVO.getDownstreamBandwidthUnit());
        vo.setMode(openApiVO.getMode());
        return vo;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getIndex() {
        return this.index;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public Integer getSourceType() {
        return this.sourceType;
    }

    @Generated
    public List<String> getSourceIds() {
        return this.sourceIds;
    }

    @Generated
    public List<String> getWanPortIds() {
        return this.wanPortIds;
    }

    @Generated
    public Integer getUpstreamBandwidth() {
        return this.upstreamBandwidth;
    }

    @Generated
    public Integer getUpstreamBandwidthUnit() {
        return this.upstreamBandwidthUnit;
    }

    @Generated
    public Integer getDownstreamBandwidth() {
        return this.downstreamBandwidth;
    }

    @Generated
    public Integer getDownstreamBandwidthUnit() {
        return this.downstreamBandwidthUnit;
    }

    @Generated
    public Integer getMode() {
        return this.mode;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setIndex(Integer index) {
        this.index = index;
    }

    @Generated
    public void setStatus(Boolean status) {
        this.status = status;
    }

    @Generated
    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    @Generated
    public void setSourceIds(List<String> sourceIds) {
        this.sourceIds = sourceIds;
    }

    @Generated
    public void setWanPortIds(List<String> wanPortIds) {
        this.wanPortIds = wanPortIds;
    }

    @Generated
    public void setUpstreamBandwidth(Integer upstreamBandwidth) {
        this.upstreamBandwidth = upstreamBandwidth;
    }

    @Generated
    public void setUpstreamBandwidthUnit(Integer upstreamBandwidthUnit) {
        this.upstreamBandwidthUnit = upstreamBandwidthUnit;
    }

    @Generated
    public void setDownstreamBandwidth(Integer downstreamBandwidth) {
        this.downstreamBandwidth = downstreamBandwidth;
    }

    @Generated
    public void setDownstreamBandwidthUnit(Integer downstreamBandwidthUnit) {
        this.downstreamBandwidthUnit = downstreamBandwidthUnit;
    }

    @Generated
    public void setMode(Integer mode) {
        this.mode = mode;
    }

    @Generated
    public String toString() {
        return "BandwidthCtrlRuleOpenApiVO(id=" + this.getId() + ", name=" + this.getName() + ", index=" + this.getIndex() + ", status=" + this.getStatus() + ", sourceType=" + this.getSourceType() + ", sourceIds=" + this.getSourceIds() + ", wanPortIds=" + this.getWanPortIds() + ", upstreamBandwidth=" + this.getUpstreamBandwidth() + ", upstreamBandwidthUnit=" + this.getUpstreamBandwidthUnit() + ", downstreamBandwidth=" + this.getDownstreamBandwidth() + ", downstreamBandwidthUnit=" + this.getDownstreamBandwidthUnit() + ", mode=" + this.getMode() + ")";
    }

    @Generated
    public BandwidthCtrlRuleOpenApiVO(String id, String name, Integer index, Boolean status, Integer sourceType, List<String> sourceIds, List<String> wanPortIds, Integer upstreamBandwidth, Integer upstreamBandwidthUnit, Integer downstreamBandwidth, Integer downstreamBandwidthUnit, Integer mode) {
        this.id = id;
        this.name = name;
        this.index = index;
        this.status = status;
        this.sourceType = sourceType;
        this.sourceIds = sourceIds;
        this.wanPortIds = wanPortIds;
        this.upstreamBandwidth = upstreamBandwidth;
        this.upstreamBandwidthUnit = upstreamBandwidthUnit;
        this.downstreamBandwidth = downstreamBandwidth;
        this.downstreamBandwidthUnit = downstreamBandwidthUnit;
        this.mode = mode;
    }

    @Generated
    public BandwidthCtrlRuleOpenApiVO() {
    }
}

