/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.transmission.bandwidthctrl;

import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.transmission.bandwidthctrl.BandwidthPortSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.dto.BandwidthCtrlVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="BandwidthControl")
public class BandwidthCtrlOpenApiVO {
    @NotNull(message="BandwidthCtrl parameter [enable] should not be null")
    @Schema(name="enable", description="Enable the bandwidth control.")
    private @NotNull(message="BandwidthCtrl parameter [enable] should not be null") Boolean enable;
    @Schema(name="thresholdControlEnable", description="Enable the threshold control of the bandwidth control.")
    private Boolean thresholdControlEnable;
    @Schema(name="thresholdValue", description="Threshold value should be within the range of 1\u2013100. Threshold value must be entered when threshold control is enable.")
    @Range(min=0L, max=100L, message="Parameter [thresholdValue] should between 0 and 100 %.")
    private @Range(min=0L, max=100L, message="Parameter [thresholdValue] should between 0 and 100 %.") Integer thresholdValue;
    @Schema(name="bandwidthPortSettings", description="Bandwidth port settings of the bandwidth control.")
    private List<BandwidthPortSettingOpenApiVO> bandwidthPortSettings;

    public static BandwidthCtrlOpenApiVO toOpenApiVO(BandwidthCtrlVO vo) {
        if (vo == null) {
            return new BandwidthCtrlOpenApiVO();
        }
        BandwidthCtrlOpenApiVO openApiVO = new BandwidthCtrlOpenApiVO();
        openApiVO.setEnable(vo.getBandwidthControlEnable());
        openApiVO.setThresholdControlEnable(vo.getThresholdControlEnable());
        openApiVO.setThresholdValue(vo.getThresholdValue());
        if (vo.getBandwidthPortSettings() != null) {
            openApiVO.setBandwidthPortSettings(vo.getBandwidthPortSettings().stream().map(BandwidthPortSettingOpenApiVO::toOpenApiVO).collect(Collectors.toList()));
        }
        return openApiVO;
    }

    public static BandwidthCtrlVO toVO(BandwidthCtrlOpenApiVO openApiVO) {
        BandwidthCtrlVO vo = new BandwidthCtrlVO();
        vo.setBandwidthControlEnable(openApiVO.getEnable());
        vo.setThresholdControlEnable(openApiVO.getThresholdControlEnable());
        vo.setThresholdValue(openApiVO.getThresholdValue());
        if (openApiVO.getBandwidthPortSettings() != null) {
            vo.setBandwidthPortSettings(openApiVO.getBandwidthPortSettings().stream().map(BandwidthPortSettingOpenApiVO::toVO).collect(Collectors.toList()));
        }
        return vo;
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public Boolean getThresholdControlEnable() {
        return this.thresholdControlEnable;
    }

    @Generated
    public Integer getThresholdValue() {
        return this.thresholdValue;
    }

    @Generated
    public List<BandwidthPortSettingOpenApiVO> getBandwidthPortSettings() {
        return this.bandwidthPortSettings;
    }

    @Generated
    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    @Generated
    public void setThresholdControlEnable(Boolean thresholdControlEnable) {
        this.thresholdControlEnable = thresholdControlEnable;
    }

    @Generated
    public void setThresholdValue(Integer thresholdValue) {
        this.thresholdValue = thresholdValue;
    }

    @Generated
    public void setBandwidthPortSettings(List<BandwidthPortSettingOpenApiVO> bandwidthPortSettings) {
        this.bandwidthPortSettings = bandwidthPortSettings;
    }

    @Generated
    public String toString() {
        return "BandwidthCtrlOpenApiVO(enable=" + this.getEnable() + ", thresholdControlEnable=" + this.getThresholdControlEnable() + ", thresholdValue=" + this.getThresholdValue() + ", bandwidthPortSettings=" + this.getBandwidthPortSettings() + ")";
    }

    @Generated
    public BandwidthCtrlOpenApiVO(Boolean enable, Boolean thresholdControlEnable, Integer thresholdValue, List<BandwidthPortSettingOpenApiVO> bandwidthPortSettings) {
        this.enable = enable;
        this.thresholdControlEnable = thresholdControlEnable;
        this.thresholdValue = thresholdValue;
        this.bandwidthPortSettings = bandwidthPortSettings;
    }

    @Generated
    public BandwidthCtrlOpenApiVO() {
    }
}

