/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.sim.dto.smssettings;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.manager.configuration.api.web.site.sim.dto.sms.setting.routercommand.AccessItemVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import lombok.Generated;

@Schema(name="AccessItem")
public class AccessItemOpenApiVO {
    @Size(min=2, max=2, message="Value of countryCode is 2.")
    @Schema(name="countryCode", description="Country code should contain 2 characters. Country code must be entered when entering the calling code. For the values of Country code, refer to section 5.4.1 of the Open API Access Guide.")
    private @Size(min=2, max=2, message="Value of countryCode is 2.") String countryCode;
    @Pattern(regexp="\\+\\d{1,4}", message="Parameter [callingCode] Invalid.")
    @Schema(name="callingCode", description="Calling code should contain 2 to 5 characters. Calling code must be entered when entering the country code. For the values of Calling code, refer to section 5.4.1 of the Open API Access Guide.")
    private @Pattern(regexp="\\+\\d{1,4}", message="Parameter [callingCode] Invalid.") String callingCode;
    @NotNull(message="Access parameter [phone] should not be null.")
    @Pattern(regexp="\\d{1,20}", message="Parameter [phone] Invalid.")
    @PII(strategy=PIIMaskStrategy.HASH)
    @Schema(name="phone", description="Allowed phone numbers.")
    private @NotNull(message="Access parameter [phone] should not be null.") @Pattern(regexp="\\d{1,20}", message="Parameter [phone] Invalid.") String phone;

    public static AccessItemOpenApiVO fromVO(AccessItemVO vo) {
        if (vo == null) {
            return null;
        }
        AccessItemOpenApiVO openApiVO = new AccessItemOpenApiVO();
        openApiVO.setCountryCode(vo.getCountryCode());
        openApiVO.setCallingCode(vo.getCallingCode());
        openApiVO.setPhone(vo.getPhone());
        return openApiVO;
    }

    public static AccessItemVO toVO(AccessItemOpenApiVO openApiVO) {
        if (openApiVO == null) {
            return null;
        }
        AccessItemVO vo = new AccessItemVO();
        vo.setCountryCode(openApiVO.getCountryCode());
        vo.setCallingCode(openApiVO.getCallingCode());
        vo.setPhone(openApiVO.getPhone());
        return vo;
    }

    @Generated
    public String getCountryCode() {
        return this.countryCode;
    }

    @Generated
    public String getCallingCode() {
        return this.callingCode;
    }

    @Generated
    public String getPhone() {
        return this.phone;
    }

    @Generated
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    @Generated
    public void setCallingCode(String callingCode) {
        this.callingCode = callingCode;
    }

    @Generated
    public void setPhone(String phone) {
        this.phone = phone;
    }

    @Generated
    public String toString() {
        return "AccessItemOpenApiVO(countryCode=" + this.getCountryCode() + ", callingCode=" + this.getCallingCode() + ", phone=" + this.getPhone() + ")";
    }

    @Generated
    public AccessItemOpenApiVO() {
    }

    @Generated
    public AccessItemOpenApiVO(String countryCode, String callingCode, String phone) {
        this.countryCode = countryCode;
        this.callingCode = callingCode;
        this.phone = phone;
    }
}

