/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.sim.dto.smsmessage;

import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.sim.dto.quota.SimQuotaSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.sim.dto.sms.message.SendMessageVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="SendMessage")
public class SendMessageOpenApiVO {
    @Pattern(regexp="\\+\\d{1,4}", message="Parameter [callingCode] Invalid.")
    @Schema(name="callingCode", description="Calling code should contain 2 to 5 characters. Calling code must be entered when entering the country code. For the values of Calling code, refer to section 5.4.1 of the Open API Access Guide.")
    private @Pattern(regexp="\\+\\d{1,4}", message="Parameter [callingCode] Invalid.") String callingCode;
    @NotNull(message="Message parameter [receiver] should not be null.")
    @Pattern(regexp="\\d{1,20}", message="Parameter [receiver] Invalid.")
    @Schema(name="receiver", description="Receiver number.")
    private @NotNull(message="Message parameter [receiver] should not be null.") @Pattern(regexp="\\d{1,20}", message="Parameter [receiver] Invalid.") String receiver;
    @NotNull(message="Message parameter [type] should not be null.")
    @Range(min=0L, max=1L, message="Value of type is from 0 to 1.")
    @Schema(name="type", description="Send type. 0: formal; 1: test")
    private @NotNull(message="Message parameter [type] should not be null.") @Range(min=0L, max=1L, message="Value of type is from 0 to 1.") Integer type;
    @Schema(name="content", description="When parameter [type] is 0, parameter [content] should not be null.")
    private String content;
    @Schema(name="test", description="When parameter [type] is 0, parameter [content] should not be null.")
    private SimQuotaSettingOpenApiVO test;
    @Schema(name="simCard", description="When the device supports Dual-SIM card, parameter [simCard] shoud not be null.1: SIM1; 2: SIM2.")
    private Integer simCard;

    public static SendMessageVO toWebVO(SendMessageOpenApiVO openApiVO) {
        SendMessageVO sendMessageVO = new SendMessageVO();
        if (openApiVO == null) {
            return sendMessageVO;
        }
        sendMessageVO.setCallingCode(openApiVO.getCallingCode());
        sendMessageVO.setReceiver(openApiVO.getReceiver());
        sendMessageVO.setType(openApiVO.getType());
        sendMessageVO.setContent(openApiVO.getContent());
        sendMessageVO.setTest(SimQuotaSettingOpenApiVO.toVO(openApiVO.getTest()));
        sendMessageVO.setSimCard(openApiVO.getSimCard());
        return sendMessageVO;
    }

    @Generated
    public String getCallingCode() {
        return this.callingCode;
    }

    @Generated
    public String getReceiver() {
        return this.receiver;
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public SimQuotaSettingOpenApiVO getTest() {
        return this.test;
    }

    @Generated
    public Integer getSimCard() {
        return this.simCard;
    }

    @Generated
    public void setCallingCode(String callingCode) {
        this.callingCode = callingCode;
    }

    @Generated
    public void setReceiver(String receiver) {
        this.receiver = receiver;
    }

    @Generated
    public void setType(Integer type) {
        this.type = type;
    }

    @Generated
    public void setContent(String content) {
        this.content = content;
    }

    @Generated
    public void setTest(SimQuotaSettingOpenApiVO test) {
        this.test = test;
    }

    @Generated
    public void setSimCard(Integer simCard) {
        this.simCard = simCard;
    }

    @Generated
    public String toString() {
        return "SendMessageOpenApiVO(callingCode=" + this.getCallingCode() + ", receiver=" + this.getReceiver() + ", type=" + this.getType() + ", content=" + this.getContent() + ", test=" + this.getTest() + ", simCard=" + this.getSimCard() + ")";
    }

    @Generated
    public SendMessageOpenApiVO() {
    }

    @Generated
    public SendMessageOpenApiVO(String callingCode, String receiver, Integer type, String content, SimQuotaSettingOpenApiVO test, Integer simCard) {
        this.callingCode = callingCode;
        this.receiver = receiver;
        this.type = type;
        this.content = content;
        this.test = test;
        this.simCard = simCard;
    }
}

