/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.sim.dto.quota;

import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.sim.dto.quota.QuotaDataSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.sim.dto.quota.QuotaSmsSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.sim.dto.quota.QuotaDataSettingVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.sim.dto.quota.QuotaSmsSettingVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.sim.dto.quota.SimQuotaSettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.Optional;
import lombok.Generated;

@Schema(name="SimQuotaSetting")
public class SimQuotaSettingOpenApiVO {
    @Valid
    @Schema(name="dataSetting", description="Data quota setting.")
    private QuotaDataSettingOpenApiVO dataSetting;
    @Valid
    @Schema(name="smsSetting", description="SMS quota setting.")
    private QuotaSmsSettingOpenApiVO smsSetting;
    @Schema(name="simCard", description="When device supports Dual-SIM card, using parameter [simCard] to point which card to configure. 1: SIM1; 2:SIM2.")
    private Integer simCard;
    @Schema(name="cardStatus", description="Sim card status.")
    private Integer cardStatus;
    @Schema(name="resource", description="Sim quota setting creation resource,such as: 0: new created, 1: from template, 2: override.")
    private Integer resource;

    public static SimQuotaSettingOpenApiVO toOpenApiVO(SimQuotaSettingVO vo) {
        if (vo == null) {
            return new SimQuotaSettingOpenApiVO();
        }
        SimQuotaSettingOpenApiVO simQuotaSettingOpenApiVO = new SimQuotaSettingOpenApiVO();
        simQuotaSettingOpenApiVO.setDataSetting(Optional.ofNullable(vo.getDataSetting()).map(QuotaDataSettingOpenApiVO::toOpenApiVO).orElse(null));
        simQuotaSettingOpenApiVO.setSmsSetting(Optional.ofNullable(vo.getSmsSetting()).map(QuotaSmsSettingOpenApiVO::toOpenApiVO).orElse(null));
        simQuotaSettingOpenApiVO.setSimCard(vo.getSimCard());
        simQuotaSettingOpenApiVO.setCardStatus(vo.getCardStatus());
        simQuotaSettingOpenApiVO.setResource(vo.getResource());
        return simQuotaSettingOpenApiVO;
    }

    public static SimQuotaSettingVO toVO(SimQuotaSettingOpenApiVO openApiVO) {
        if (openApiVO == null) {
            return SimQuotaSettingVO.builder().build();
        }
        return SimQuotaSettingVO.builder().dataSetting((QuotaDataSettingVO)Optional.ofNullable(openApiVO.getDataSetting()).map(QuotaDataSettingOpenApiVO::toVO).orElse(null)).smsSetting((QuotaSmsSettingVO)Optional.ofNullable(openApiVO.getSmsSetting()).map(QuotaSmsSettingOpenApiVO::toVO).orElse(null)).simCard(openApiVO.getSimCard()).cardStatus(openApiVO.getCardStatus()).resource(openApiVO.getResource()).build();
    }

    @Generated
    public QuotaDataSettingOpenApiVO getDataSetting() {
        return this.dataSetting;
    }

    @Generated
    public QuotaSmsSettingOpenApiVO getSmsSetting() {
        return this.smsSetting;
    }

    @Generated
    public Integer getSimCard() {
        return this.simCard;
    }

    @Generated
    public Integer getCardStatus() {
        return this.cardStatus;
    }

    @Generated
    public Integer getResource() {
        return this.resource;
    }

    @Generated
    public void setDataSetting(QuotaDataSettingOpenApiVO dataSetting) {
        this.dataSetting = dataSetting;
    }

    @Generated
    public void setSmsSetting(QuotaSmsSettingOpenApiVO smsSetting) {
        this.smsSetting = smsSetting;
    }

    @Generated
    public void setSimCard(Integer simCard) {
        this.simCard = simCard;
    }

    @Generated
    public void setCardStatus(Integer cardStatus) {
        this.cardStatus = cardStatus;
    }

    @Generated
    public void setResource(Integer resource) {
        this.resource = resource;
    }

    @Generated
    public String toString() {
        return "SimQuotaSettingOpenApiVO(dataSetting=" + this.getDataSetting() + ", smsSetting=" + this.getSmsSetting() + ", simCard=" + this.getSimCard() + ", cardStatus=" + this.getCardStatus() + ", resource=" + this.getResource() + ")";
    }

    @Generated
    public SimQuotaSettingOpenApiVO() {
    }

    @Generated
    public SimQuotaSettingOpenApiVO(QuotaDataSettingOpenApiVO dataSetting, QuotaSmsSettingOpenApiVO smsSetting, Integer simCard, Integer cardStatus, Integer resource) {
        this.dataSetting = dataSetting;
        this.smsSetting = smsSetting;
        this.simCard = simCard;
        this.cardStatus = cardStatus;
        this.resource = resource;
    }
}

