/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.sim.dto.quota;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.manager.configuration.api.web.site.sim.dto.quota.QuotaDataSettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class QuotaDataSettingOpenApiVO {
    @Schema(name="used", description="The amount of data usage (KB) in current billing cycle.")
    private Float used;
    @Schema(name="type", description="Billing cycle type should be a value as follows: 0:total; 1:monthly.")
    @NotNull(message="Data parameter [type] should not be null.")
    @Range(min=0L, max=1L, message="Value of type is from 0 to 1.")
    private @NotNull(message="Data parameter [type] should not be null.") @Range(min=0L, max=1L, message="Value of type is from 0 to 1.") Integer type;
    @Schema(name="startDate", description="Start date of monthly billing cycle type, valid date should be within the range of 1\u201331.")
    @Range(min=1L, max=31L, message="Value of startDate is from 1 to 31.")
    private @Range(min=1L, max=31L, message="Value of startDate is from 1 to 31.") Integer startDate;
    @Schema(name="limit", description="Quota limit is enabled/disabled.")
    @NotNull(message="Data parameter [limit] should not be null.")
    private @NotNull(message="Data parameter [limit] should not be null.") Boolean limit;
    @Schema(name="credit", description="The amount of data allowance in current billing cycle.")
    private Float credit;
    @Schema(name="creditUnit", description="Unit for data allowance should be a value as follows: 2:MB; 3:GB.")
    @Range(min=2L, max=3L, message="Value of creditUnit is from 2 to 3.")
    private @Range(min=2L, max=3L, message="Value of creditUnit is from 2 to 3.") Integer creditUnit;
    @Schema(name="alert", description="SMS alert for usage is enabled/disabled.")
    private Boolean alert;
    @Schema(name="usage", description="SMS alert for usage when reach percentage of allowance, valid date should be within the range of 0\u2013100.")
    @Range(min=0L, max=100L, message="Value of usage is from 0 to 100.")
    private @Range(min=0L, max=100L, message="Value of usage is from 0 to 100.") Integer usage;
    @Schema(name="countryCode", description="Country code should contain 2 characters. Country code must be entered when entering the calling code. For the values of Country code, refer to section 5.4.1 of the Open API Access Guide.")
    @Size(min=2, max=2, message="Value of countryCode is 2.")
    private @Size(min=2, max=2, message="Value of countryCode is 2.") String countryCode;
    @Schema(name="callingCode", description="Calling code should contain 2 to 5 characters. Calling code must be entered when entering the country code. For the values of Calling code, refer to section 5.4.1 of the Open API Access Guide.")
    @Size(min=2, max=5, message="Value of callingCode is from 2 to 5.")
    private @Size(min=2, max=5, message="Value of callingCode is from 2 to 5.") String callingCode;
    @Schema(name="phone", description="The phone number to receive SMS alerts.")
    @Pattern(regexp="\\d{1,20}", message="Parameter [phone] Invalid.")
    @PII(strategy=PIIMaskStrategy.HASH)
    private @Pattern(regexp="\\d{1,20}", message="Parameter [phone] Invalid.") String phone;

    public static QuotaDataSettingOpenApiVO toOpenApiVO(QuotaDataSettingVO vo) {
        if (vo == null) {
            return new QuotaDataSettingOpenApiVO();
        }
        QuotaDataSettingOpenApiVO quotaDataSettingOpenApiVO = new QuotaDataSettingOpenApiVO();
        quotaDataSettingOpenApiVO.setUsed(vo.getUsed());
        quotaDataSettingOpenApiVO.setType(vo.getType());
        quotaDataSettingOpenApiVO.setStartDate(vo.getStartDate());
        quotaDataSettingOpenApiVO.setLimit(vo.getLimit());
        quotaDataSettingOpenApiVO.setCredit(vo.getCredit());
        quotaDataSettingOpenApiVO.setCreditUnit(vo.getCreditUnit());
        quotaDataSettingOpenApiVO.setAlert(vo.getAlert());
        quotaDataSettingOpenApiVO.setUsage(vo.getUsage());
        quotaDataSettingOpenApiVO.setCountryCode(vo.getCountryCode());
        quotaDataSettingOpenApiVO.setCallingCode(vo.getCallingCode());
        quotaDataSettingOpenApiVO.setPhone(vo.getPhone());
        return quotaDataSettingOpenApiVO;
    }

    public static QuotaDataSettingVO toVO(QuotaDataSettingOpenApiVO openApiVO) {
        if (openApiVO == null) {
            return QuotaDataSettingVO.builder().build();
        }
        return QuotaDataSettingVO.builder().used(openApiVO.getUsed()).type(openApiVO.getType()).startDate(openApiVO.getStartDate()).limit(openApiVO.getLimit()).credit(openApiVO.getCredit()).creditUnit(openApiVO.getCreditUnit()).alert(openApiVO.getAlert()).usage(openApiVO.getUsage()).countryCode(openApiVO.getCountryCode()).callingCode(openApiVO.getCallingCode()).phone(openApiVO.getPhone()).build();
    }

    @Generated
    public Float getUsed() {
        return this.used;
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public Integer getStartDate() {
        return this.startDate;
    }

    @Generated
    public Boolean getLimit() {
        return this.limit;
    }

    @Generated
    public Float getCredit() {
        return this.credit;
    }

    @Generated
    public Integer getCreditUnit() {
        return this.creditUnit;
    }

    @Generated
    public Boolean getAlert() {
        return this.alert;
    }

    @Generated
    public Integer getUsage() {
        return this.usage;
    }

    @Generated
    public String getCountryCode() {
        return this.countryCode;
    }

    @Generated
    public String getCallingCode() {
        return this.callingCode;
    }

    @Generated
    public String getPhone() {
        return this.phone;
    }

    @Generated
    public void setUsed(Float used) {
        this.used = used;
    }

    @Generated
    public void setType(Integer type) {
        this.type = type;
    }

    @Generated
    public void setStartDate(Integer startDate) {
        this.startDate = startDate;
    }

    @Generated
    public void setLimit(Boolean limit) {
        this.limit = limit;
    }

    @Generated
    public void setCredit(Float credit) {
        this.credit = credit;
    }

    @Generated
    public void setCreditUnit(Integer creditUnit) {
        this.creditUnit = creditUnit;
    }

    @Generated
    public void setAlert(Boolean alert) {
        this.alert = alert;
    }

    @Generated
    public void setUsage(Integer usage) {
        this.usage = usage;
    }

    @Generated
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    @Generated
    public void setCallingCode(String callingCode) {
        this.callingCode = callingCode;
    }

    @Generated
    public void setPhone(String phone) {
        this.phone = phone;
    }

    @Generated
    public String toString() {
        return "QuotaDataSettingOpenApiVO(used=" + this.getUsed() + ", type=" + this.getType() + ", startDate=" + this.getStartDate() + ", limit=" + this.getLimit() + ", credit=" + this.getCredit() + ", creditUnit=" + this.getCreditUnit() + ", alert=" + this.getAlert() + ", usage=" + this.getUsage() + ", countryCode=" + this.getCountryCode() + ", callingCode=" + this.getCallingCode() + ", phone=" + this.getPhone() + ")";
    }

    @Generated
    public QuotaDataSettingOpenApiVO() {
    }

    @Generated
    public QuotaDataSettingOpenApiVO(Float used, Integer type, Integer startDate, Boolean limit, Float credit, Integer creditUnit, Boolean alert, Integer usage, String countryCode, String callingCode, String phone) {
        this.used = used;
        this.type = type;
        this.startDate = startDate;
        this.limit = limit;
        this.credit = credit;
        this.creditUnit = creditUnit;
        this.alert = alert;
        this.usage = usage;
        this.countryCode = countryCode;
        this.callingCode = callingCode;
        this.phone = phone;
    }
}

