/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.sim.dto.mailserver;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.manager.configuration.api.web.site.mail.dto.MailServerVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class MailServerOpenApiVO {
    @PII(strategy=PIIMaskStrategy.HASH)
    @Schema(name="id", description="Mail server ID.")
    private String id;
    @NotNull(message="MailServer parameter [sender] should not be null.")
    @PII(strategy=PIIMaskStrategy.HASH)
    @Schema(name="sender", description="The email address of the sender.")
    private @NotNull(message="MailServer parameter [sender] should not be null.") String sender;
    @NotNull(message="MailServer parameter [sender] should not be null.")
    @PII(strategy=PIIMaskStrategy.HASH)
    @Schema(name="receiver", description="The email address of the receiver, which can be the same as or different from the sender's email address.")
    private @NotNull(message="MailServer parameter [sender] should not be null.") String receiver;
    @NotNull(message="MailServer parameter [sender] should not be null.")
    @Schema(name="ssl", description="Enable this feature, and the data will be transmitted based on the SSL protocol.")
    private @NotNull(message="MailServer parameter [sender] should not be null.") Boolean ssl;
    @Schema(name="smtpServer", description="Enter the domain name or IP address of the SMTP server.")
    private String smtpServer;
    @Range(min=1L, max=65535L, message="Value of smtpPort is from 1 to 65535.")
    @Schema(name="smtpPort", description="Enter the port used by the SMTP server according to the instructions of your email service provider.")
    private @Range(min=1L, max=65535L, message="Value of smtpPort is from 1 to 65535.") Integer smtpPort;
    @NotNull(message="MailServer parameter [sender] should not be null.")
    @Schema(name="auth", description="Enable this feature if the login of the mailbox requires a username and authorization code.")
    private @NotNull(message="MailServer parameter [sender] should not be null.") Boolean auth;
    @PII(strategy=PIIMaskStrategy.HASH)
    @Schema(name="username", description="When Authentication is enabled, enter your email address as the username.")
    private String username;
    @Schema(name="authCode", description="When Authentication is enabled, enter the authorization code that enables a third party to log in to the mailbox. Note that the authorization code is not the mailbox's password.")
    private String authCode;
    @Schema(name="resource", description="Mail server setting creation resource, such as: 0: new created, 1: from template, 2: override.")
    private Integer resource;

    public static MailServerOpenApiVO fromVO(MailServerVO vo) {
        if (vo == null) {
            return null;
        }
        MailServerOpenApiVO openApiVO = new MailServerOpenApiVO();
        openApiVO.setId(vo.getId());
        openApiVO.setSender(vo.getSender());
        openApiVO.setReceiver(vo.getReceiver());
        openApiVO.setSsl(vo.getSsl());
        openApiVO.setSmtpServer(vo.getSmtpServer());
        openApiVO.setSmtpPort(vo.getSmtpPort());
        openApiVO.setAuth(vo.getAuth());
        openApiVO.setUsername(vo.getUsername());
        openApiVO.setAuthCode(vo.getAuthCode());
        openApiVO.setResource(vo.getResource());
        return openApiVO;
    }

    public static MailServerVO toVO(MailServerOpenApiVO openApiVO) {
        if (openApiVO == null) {
            return null;
        }
        MailServerVO vo = new MailServerVO();
        vo.setId(openApiVO.getId());
        vo.setSender(openApiVO.getSender());
        vo.setReceiver(openApiVO.getReceiver());
        vo.setSsl(openApiVO.getSsl());
        vo.setSmtpServer(openApiVO.getSmtpServer());
        vo.setSmtpPort(openApiVO.getSmtpPort());
        vo.setAuth(openApiVO.getAuth());
        vo.setUsername(openApiVO.getUsername());
        vo.setAuthCode(openApiVO.getAuthCode());
        vo.setResource(openApiVO.getResource());
        return vo;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getSender() {
        return this.sender;
    }

    @Generated
    public String getReceiver() {
        return this.receiver;
    }

    @Generated
    public Boolean getSsl() {
        return this.ssl;
    }

    @Generated
    public String getSmtpServer() {
        return this.smtpServer;
    }

    @Generated
    public Integer getSmtpPort() {
        return this.smtpPort;
    }

    @Generated
    public Boolean getAuth() {
        return this.auth;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getAuthCode() {
        return this.authCode;
    }

    @Generated
    public Integer getResource() {
        return this.resource;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setSender(String sender) {
        this.sender = sender;
    }

    @Generated
    public void setReceiver(String receiver) {
        this.receiver = receiver;
    }

    @Generated
    public void setSsl(Boolean ssl) {
        this.ssl = ssl;
    }

    @Generated
    public void setSmtpServer(String smtpServer) {
        this.smtpServer = smtpServer;
    }

    @Generated
    public void setSmtpPort(Integer smtpPort) {
        this.smtpPort = smtpPort;
    }

    @Generated
    public void setAuth(Boolean auth) {
        this.auth = auth;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }

    @Generated
    public void setResource(Integer resource) {
        this.resource = resource;
    }

    @Generated
    public String toString() {
        return "MailServerOpenApiVO(id=" + this.getId() + ", sender=" + this.getSender() + ", receiver=" + this.getReceiver() + ", ssl=" + this.getSsl() + ", smtpServer=" + this.getSmtpServer() + ", smtpPort=" + this.getSmtpPort() + ", auth=" + this.getAuth() + ", username=" + this.getUsername() + ", authCode=" + this.getAuthCode() + ", resource=" + this.getResource() + ")";
    }

    @Generated
    public MailServerOpenApiVO() {
    }

    @Generated
    public MailServerOpenApiVO(String id, String sender, String receiver, Boolean ssl, String smtpServer, Integer smtpPort, Boolean auth, String username, String authCode, Integer resource) {
        this.id = id;
        this.sender = sender;
        this.receiver = receiver;
        this.ssl = ssl;
        this.smtpServer = smtpServer;
        this.smtpPort = smtpPort;
        this.auth = auth;
        this.username = username;
        this.authCode = authCode;
        this.resource = resource;
    }
}

