/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.sim.dto.mailserver;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.manager.configuration.api.web.site.mail.dto.MailServerVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class MailServerOpenApiModifyVO {
    @Pattern(regexp="[-0-9a-zA-Z.+_]+@[-0-9a-zA-Z.+_]+\\.[a-zA-Z0-9]{2,}", message="sender is not a email address.")
    @NotNull(message="MailServer parameter [sender] should not be null.")
    @PII(strategy=PIIMaskStrategy.HASH)
    @Schema(name="sender", description="The email address of the sender.")
    private @Pattern(regexp="[-0-9a-zA-Z.+_]+@[-0-9a-zA-Z.+_]+\\.[a-zA-Z0-9]{2,}", message="sender is not a email address.") @NotNull(message="MailServer parameter [sender] should not be null.") String sender;
    @Pattern(regexp="[-0-9a-zA-Z.+_]+@[-0-9a-zA-Z.+_]+\\.[a-zA-Z0-9]{2,}", message="receiver is not a email address.")
    @NotNull(message="MailServer parameter [receiver] should not be null.")
    @PII(strategy=PIIMaskStrategy.HASH)
    @Schema(name="receiver", description="The email address of the receiver, which can be the same as or different from the sender's email address.")
    private @Pattern(regexp="[-0-9a-zA-Z.+_]+@[-0-9a-zA-Z.+_]+\\.[a-zA-Z0-9]{2,}", message="receiver is not a email address.") @NotNull(message="MailServer parameter [receiver] should not be null.") String receiver;
    @NotNull(message="MailServer parameter [ssl] should not be null.")
    @Schema(name="ssl", description="Enable this feature, and the data will be transmitted based on the SSL protocol.")
    private @NotNull(message="MailServer parameter [ssl] should not be null.") Boolean ssl;
    @Pattern(regexp="((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6})", message="smtpServer is not a IP address or domain name")
    @Schema(name="smtpServer", description="Enter the domain name or IP address of the SMTP server.")
    private @Pattern(regexp="((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6})", message="smtpServer is not a IP address or domain name") String smtpServer;
    @Range(min=1L, max=65535L, message="Value of smtpPort is from 1 to 65535.")
    @Schema(name="smtpPort", description="Enter the port used by the SMTP server according to the instructions of your email service provider.")
    private @Range(min=1L, max=65535L, message="Value of smtpPort is from 1 to 65535.") Integer smtpPort;
    @NotNull(message="MailServer parameter [auth] should not be null.")
    @Schema(name="auth", description="Enable this feature if the login of the mailbox requires a username and authorization code.")
    private @NotNull(message="MailServer parameter [auth] should not be null.") Boolean auth;
    @PII(strategy=PIIMaskStrategy.HASH)
    @Schema(name="username", description="When Authentication is enabled, enter your email address as the username.")
    private String username;
    @Schema(name="authCode", description="When Authentication is enabled, enter the authorization code that enables a third party to log in to the mailbox. Note that the authorization code is not the mailbox's password.")
    private String authCode;

    public static MailServerVO toVO(MailServerOpenApiModifyVO openApiVO) {
        if (openApiVO == null) {
            return null;
        }
        MailServerVO vo = new MailServerVO();
        vo.setSender(openApiVO.getSender());
        vo.setReceiver(openApiVO.getReceiver());
        vo.setSsl(openApiVO.getSsl());
        vo.setSmtpServer(openApiVO.getSmtpServer());
        vo.setSmtpPort(openApiVO.getSmtpPort());
        vo.setAuth(openApiVO.getAuth());
        vo.setUsername(openApiVO.getUsername());
        vo.setAuthCode(openApiVO.getAuthCode());
        return vo;
    }

    @Generated
    public String getSender() {
        return this.sender;
    }

    @Generated
    public String getReceiver() {
        return this.receiver;
    }

    @Generated
    public Boolean getSsl() {
        return this.ssl;
    }

    @Generated
    public String getSmtpServer() {
        return this.smtpServer;
    }

    @Generated
    public Integer getSmtpPort() {
        return this.smtpPort;
    }

    @Generated
    public Boolean getAuth() {
        return this.auth;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getAuthCode() {
        return this.authCode;
    }

    @Generated
    public void setSender(String sender) {
        this.sender = sender;
    }

    @Generated
    public void setReceiver(String receiver) {
        this.receiver = receiver;
    }

    @Generated
    public void setSsl(Boolean ssl) {
        this.ssl = ssl;
    }

    @Generated
    public void setSmtpServer(String smtpServer) {
        this.smtpServer = smtpServer;
    }

    @Generated
    public void setSmtpPort(Integer smtpPort) {
        this.smtpPort = smtpPort;
    }

    @Generated
    public void setAuth(Boolean auth) {
        this.auth = auth;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }

    @Generated
    public String toString() {
        return "MailServerOpenApiModifyVO(sender=" + this.getSender() + ", receiver=" + this.getReceiver() + ", ssl=" + this.getSsl() + ", smtpServer=" + this.getSmtpServer() + ", smtpPort=" + this.getSmtpPort() + ", auth=" + this.getAuth() + ", username=" + this.getUsername() + ", authCode=" + this.getAuthCode() + ")";
    }

    @Generated
    public MailServerOpenApiModifyVO() {
    }

    @Generated
    public MailServerOpenApiModifyVO(String sender, String receiver, Boolean ssl, String smtpServer, Integer smtpPort, Boolean auth, String username, String authCode) {
        this.sender = sender;
        this.receiver = receiver;
        this.ssl = ssl;
        this.smtpServer = smtpServer;
        this.smtpPort = smtpPort;
        this.auth = auth;
        this.username = username;
        this.authCode = authCode;
    }
}

