/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.security.urlfiltering;

import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.manager.configuration.api.web.site.firewall.dto.UrlFilteringVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class UrlFilteringOpenApiVO {
    @NotNull(message="Value of type can not be null.")
    @Schema(name="type", description="Type should be a value as follows: \"gateway\"; \"ap\".")
    @Pattern(regexp="gateway|ap", message="Type should be a value as follows: \"gateway\"; \"ap\".")
    private @NotNull(message="Value of type can not be null.") @Pattern(regexp="gateway|ap", message="Type should be a value as follows: \"gateway\"; \"ap\".") String type;
    @NotNull(message="Value of name can not be null.")
    @Schema(name="name", description="Name should contain 1 to 64 characters.")
    @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Value of name should be 1 ~ 64 characters.")
    private @NotNull(message="Value of name can not be null.") @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Value of name should be 1 ~ 64 characters.") String name;
    @NotNull(message="Value of status can not be null.")
    @Schema(name="status", description="Status of the URL filtering.")
    private @NotNull(message="Value of status can not be null.") Boolean status;
    @NotNull(message="Value of policy can not be null.")
    @Schema(name="policy", description="Policy should be a value as follows: 0: drop; 1: allow.")
    @Range(min=0L, max=1L, message="Value of policy should be between 0 and 1.")
    private @NotNull(message="Value of policy can not be null.") @Range(min=0L, max=1L, message="Value of policy should be between 0 and 1.") Integer policy;
    @NotNull(message="Value of sourceType can not be null.")
    @Schema(name="sourceType", description="Source type should be a value as follows: 0: network; 1: IP group; 2: SSID.")
    @Range(min=0L, max=2L, message="Value of sourceType should be between 0 and 2.")
    private @NotNull(message="Value of sourceType can not be null.") @Range(min=0L, max=2L, message="Value of sourceType should be between 0 and 2.") Integer sourceType;
    @NotNull(message="Value of sourceIds can not be null.")
    @Schema(name="sourceIds", description="Source IDs of the URL filtering. Network can be created using 'Create LAN network' interface, and network ID can be obtained from 'Get LAN network list' interface. IP group can be created using 'Create a new group profile' interface, and IP group ID can be obtained from 'Get group profile list' interface. SSID can be created using 'Create new SSID' interface, and SSID ID can be obtained from 'Get SSID list' interface.")
    private @NotNull(message="Value of sourceIds can not be null.") List<String> sourceIds;
    @NotNull(message="Value of mode can not be null.")
    @Schema(name="mode", description="Mode should be a value as follows: 0: URL Path; 1: keywords(Only for gateway).")
    @Range(min=0L, max=1L, message="Value of mode should be between 0 and 1.")
    private @NotNull(message="Value of mode can not be null.") @Range(min=0L, max=1L, message="Value of mode should be between 0 and 1.") Integer mode;
    @Schema(name="urls", description="URLs of the URL filtering, eg: www.google.com.")
    private List<String> urls;
    @Schema(name="keywords", description="Keywords of the URL filtering.")
    private List<String> keywords;
    @NotNull(message="Value of mode can not be null.")
    @Schema(name="filterMode", description="filterMode should be a value as follows: 0: URL; 1: category.")
    @Range(min=0L, max=1L, message="Value of mode should be between 0 and 1.")
    private @NotNull(message="Value of mode can not be null.") @Range(min=0L, max=1L, message="Value of mode should be between 0 and 1.") Integer filterMode;
    @Schema(name="scenarioMode", description="scenarioMode should be a value as follows:0: Custom  1: Family 2\uff1aWork 3\uff1aEducation 4\uff1aGuest.")
    @Range(min=0L, max=4L, message="Value of mode should be between 0 and 4.")
    private @Range(min=0L, max=4L, message="Value of mode should be between 0 and 4.") Integer scenarioMode;
    @Schema(name="categories", description="categories of the URL filtering, TreeMap<String, List<String>> categories")
    private TreeMap<String, List<String>> categories;
    @Schema(name="timeRange", description="timeRange of the URL filtering, TimeSchedule")
    private String timeRangeId;

    public static UrlFilteringVO toVO(UrlFilteringOpenApiVO openApiVO) {
        UrlFilteringVO vo = new UrlFilteringVO();
        vo.setType(openApiVO.getType());
        vo.setName(openApiVO.getName());
        vo.setStatus(openApiVO.getStatus());
        vo.setPolicy(openApiVO.getPolicy());
        vo.setSourceType(openApiVO.getSourceType());
        vo.setSourceIds(openApiVO.getSourceIds());
        if (!Objects.equals(DeviceTypeEnum.b.b(), vo.getType())) {
            vo.setMode(Integer.valueOf(0));
        } else {
            vo.setMode(openApiVO.getMode());
        }
        vo.setUrls(openApiVO.getUrls());
        vo.setKeywords(openApiVO.getKeywords());
        vo.setFilterMode(openApiVO.getFilterMode());
        vo.setScenarioMode(openApiVO.getScenarioMode());
        vo.setCategories(openApiVO.getCategories());
        vo.setTimeRangeId(openApiVO.getTimeRangeId());
        return vo;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public Integer getPolicy() {
        return this.policy;
    }

    @Generated
    public Integer getSourceType() {
        return this.sourceType;
    }

    @Generated
    public List<String> getSourceIds() {
        return this.sourceIds;
    }

    @Generated
    public Integer getMode() {
        return this.mode;
    }

    @Generated
    public List<String> getUrls() {
        return this.urls;
    }

    @Generated
    public List<String> getKeywords() {
        return this.keywords;
    }

    @Generated
    public Integer getFilterMode() {
        return this.filterMode;
    }

    @Generated
    public Integer getScenarioMode() {
        return this.scenarioMode;
    }

    @Generated
    public TreeMap<String, List<String>> getCategories() {
        return this.categories;
    }

    @Generated
    public String getTimeRangeId() {
        return this.timeRangeId;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setStatus(Boolean status) {
        this.status = status;
    }

    @Generated
    public void setPolicy(Integer policy) {
        this.policy = policy;
    }

    @Generated
    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    @Generated
    public void setSourceIds(List<String> sourceIds) {
        this.sourceIds = sourceIds;
    }

    @Generated
    public void setMode(Integer mode) {
        this.mode = mode;
    }

    @Generated
    public void setUrls(List<String> urls) {
        this.urls = urls;
    }

    @Generated
    public void setKeywords(List<String> keywords) {
        this.keywords = keywords;
    }

    @Generated
    public void setFilterMode(Integer filterMode) {
        this.filterMode = filterMode;
    }

    @Generated
    public void setScenarioMode(Integer scenarioMode) {
        this.scenarioMode = scenarioMode;
    }

    @Generated
    public void setCategories(TreeMap<String, List<String>> categories) {
        this.categories = categories;
    }

    @Generated
    public void setTimeRangeId(String timeRangeId) {
        this.timeRangeId = timeRangeId;
    }

    @Generated
    public String toString() {
        return "UrlFilteringOpenApiVO(type=" + this.getType() + ", name=" + this.getName() + ", status=" + this.getStatus() + ", policy=" + this.getPolicy() + ", sourceType=" + this.getSourceType() + ", sourceIds=" + this.getSourceIds() + ", mode=" + this.getMode() + ", urls=" + this.getUrls() + ", keywords=" + this.getKeywords() + ", filterMode=" + this.getFilterMode() + ", scenarioMode=" + this.getScenarioMode() + ", categories=" + this.getCategories() + ", timeRangeId=" + this.getTimeRangeId() + ")";
    }

    @Generated
    public UrlFilteringOpenApiVO(String type, String name, Boolean status, Integer policy, Integer sourceType, List<String> sourceIds, Integer mode, List<String> urls, List<String> keywords, Integer filterMode, Integer scenarioMode, TreeMap<String, List<String>> categories, String timeRangeId) {
        this.type = type;
        this.name = name;
        this.status = status;
        this.policy = policy;
        this.sourceType = sourceType;
        this.sourceIds = sourceIds;
        this.mode = mode;
        this.urls = urls;
        this.keywords = keywords;
        this.filterMode = filterMode;
        this.scenarioMode = scenarioMode;
        this.categories = categories;
        this.timeRangeId = timeRangeId;
    }

    @Generated
    public UrlFilteringOpenApiVO() {
    }
}

