/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.security.urlfiltering;

import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.security.urlfiltering.UrlFilteringOpenApiGridVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.firewall.dto.UrlFilteringGridVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.firewall.dto.UrlFilteringVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class QueryUrlFilteringOpenApiVO {
    @Schema(name="id", description="ID of the URL filtering.")
    private String id;
    @Schema(name="index", description="Index of the URL filtering.")
    private Integer index;
    @NotNull(message="Value of type can not be null.")
    @Schema(name="type", description="Type should be a value as follows: \"gateway\"; \"ap\".")
    @Pattern(regexp="gateway|ap", message="Type should be a value as follows: \"gateway\"; \"ap\".")
    private @NotNull(message="Value of type can not be null.") @Pattern(regexp="gateway|ap", message="Type should be a value as follows: \"gateway\"; \"ap\".") String type;
    @NotNull(message="Value of name can not be null.")
    @Schema(name="name", description="Name should contain 1 to 64 characters.")
    @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Value of name should be 1 ~ 64 characters.")
    private @NotNull(message="Value of name can not be null.") @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Value of name should be 1 ~ 64 characters.") String name;
    @NotNull(message="Value of status can not be null.")
    @Schema(name="status", description="Status of the URL filtering.")
    private @NotNull(message="Value of status can not be null.") Boolean status;
    @NotNull(message="Value of policy can not be null.")
    @Schema(name="policy", description="Policy should be a value as follows: 0: drop; 1: allow.")
    @Range(min=0L, max=1L, message="Value of policy should be between 0 and 1.")
    private @NotNull(message="Value of policy can not be null.") @Range(min=0L, max=1L, message="Value of policy should be between 0 and 1.") Integer policy;
    @NotNull(message="Value of sourceType can not be null.")
    @Schema(name="sourceType", description="Source type should be a value as follows: 0: network; 1: IP group; 2: SSID.")
    @Range(min=0L, max=2L, message="Value of sourceType should be between 0 and 2.")
    private @NotNull(message="Value of sourceType can not be null.") @Range(min=0L, max=2L, message="Value of sourceType should be between 0 and 2.") Integer sourceType;
    @NotNull(message="Value of sourceIds can not be null.")
    @Schema(name="sourceIds", description="Source IDs of the URL filtering. Network can be created using 'Create LAN network' interface, and network ID can be obtained from 'Get LAN network list' interface. IP group can be created using 'Create a new group profile' interface, and IP group ID can be obtained from 'Get group profile list' interface. SSID can be created using 'Create new SSID' interface, and SSID ID can be obtained from 'Get SSID list' interface.")
    private @NotNull(message="Value of sourceIds can not be null.") List<String> sourceIds;
    @Schema(name="mode", description="Mode should be a value as follows: 0: URL; 1: keyword.")
    @Range(min=0L, max=1L, message="Value of mode should be between 0 and 1.")
    private @Range(min=0L, max=1L, message="Value of mode should be between 0 and 1.") Integer mode;
    @Schema(name="urls", description="URLs of the URL filtering, eg: www.google.com.")
    private List<String> urls;
    @Schema(name="keywords", description="Keywords of the URL filtering.")
    private List<String> keywords;
    @NotNull(message="Value of mode can not be null.")
    @Schema(name="filterMode", description="filterMode should be a value as follows: 0: URL; 1: category.")
    @Range(min=0L, max=1L, message="Value of mode should be between 0 and 1.")
    private @NotNull(message="Value of mode can not be null.") @Range(min=0L, max=1L, message="Value of mode should be between 0 and 1.") Integer filterMode;
    @Schema(name="scenarioMode", description="scenarioMode should be a value as follows:0: Custom  1: Family 2\uff1aWork 3\uff1aEducation 4\uff1aGuest.")
    @Range(min=0L, max=4L, message="Value of mode should be between 0 and 4.")
    private @Range(min=0L, max=4L, message="Value of mode should be between 0 and 4.") Integer scenarioMode;
    @Schema(name="categories", description="categories of the URL filtering, TreeMap<String, List<String>> categories")
    private TreeMap<String, List<String>> categories;
    @Schema(name="timeRange", description="timeRange of the URL filtering, TimeSchedule")
    private String timeRangeId;
    @Schema(name="existKeyword", description="Whether this URL filtering is keyword mode.")
    private Boolean existKeyword;
    @Schema(name="existCategory", description="Whether this URL filtering is category mode.")
    private Boolean existCategory;
    @Schema(name="existTimeSchedule", description="Whether this URL filtering contains time schedule setting.")
    private Boolean existTimeSchedule;

    public static QueryUrlFilteringOpenApiVO toOpenApiVO(UrlFilteringVO vo) {
        if (vo == null) {
            return new QueryUrlFilteringOpenApiVO();
        }
        QueryUrlFilteringOpenApiVO queryUrlFilteringOpenApiVO = new QueryUrlFilteringOpenApiVO();
        queryUrlFilteringOpenApiVO.setId(vo.getId());
        queryUrlFilteringOpenApiVO.setIndex(vo.getIndex());
        queryUrlFilteringOpenApiVO.setType(vo.getType());
        queryUrlFilteringOpenApiVO.setName(vo.getName());
        queryUrlFilteringOpenApiVO.setStatus(vo.getStatus());
        queryUrlFilteringOpenApiVO.setPolicy(vo.getPolicy());
        queryUrlFilteringOpenApiVO.setSourceType(vo.getSourceType());
        queryUrlFilteringOpenApiVO.setSourceIds(vo.getSourceIds());
        queryUrlFilteringOpenApiVO.setMode(vo.getMode());
        queryUrlFilteringOpenApiVO.setUrls(vo.getUrls());
        queryUrlFilteringOpenApiVO.setKeywords(vo.getKeywords());
        queryUrlFilteringOpenApiVO.setFilterMode(vo.getFilterMode());
        queryUrlFilteringOpenApiVO.setScenarioMode(vo.getScenarioMode());
        queryUrlFilteringOpenApiVO.setCategories(vo.getCategories());
        queryUrlFilteringOpenApiVO.setTimeRangeId(vo.getTimeRangeId());
        queryUrlFilteringOpenApiVO.setExistKeyword(vo.getExistKeyword());
        queryUrlFilteringOpenApiVO.setExistCategory(vo.getExistCategory());
        queryUrlFilteringOpenApiVO.setExistTimeSchedule(vo.getExistTimeSchedule());
        return queryUrlFilteringOpenApiVO;
    }

    public static UrlFilteringOpenApiGridVO<QueryUrlFilteringOpenApiVO> toOpenApiGridVO(UrlFilteringGridVO<UrlFilteringVO> gridVO) {
        UrlFilteringOpenApiGridVO<QueryUrlFilteringOpenApiVO> openApiGridVO = new UrlFilteringOpenApiGridVO<QueryUrlFilteringOpenApiVO>();
        openApiGridVO.setTotalRows(gridVO.getTotalRows());
        openApiGridVO.setCurrentPage(gridVO.getCurrentPage());
        openApiGridVO.setCurrentSize(gridVO.getCurrentSize());
        openApiGridVO.setData(gridVO.getData().stream().map(QueryUrlFilteringOpenApiVO::toOpenApiVO).collect(Collectors.toList()));
        openApiGridVO.setSupportKeyword(gridVO.getSupportKeyword());
        openApiGridVO.setSupportCategory(gridVO.getSupportCategory());
        openApiGridVO.setSupportTimeSchedule(gridVO.getSupportCategory());
        return openApiGridVO;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Integer getIndex() {
        return this.index;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public Integer getPolicy() {
        return this.policy;
    }

    @Generated
    public Integer getSourceType() {
        return this.sourceType;
    }

    @Generated
    public List<String> getSourceIds() {
        return this.sourceIds;
    }

    @Generated
    public Integer getMode() {
        return this.mode;
    }

    @Generated
    public List<String> getUrls() {
        return this.urls;
    }

    @Generated
    public List<String> getKeywords() {
        return this.keywords;
    }

    @Generated
    public Integer getFilterMode() {
        return this.filterMode;
    }

    @Generated
    public Integer getScenarioMode() {
        return this.scenarioMode;
    }

    @Generated
    public TreeMap<String, List<String>> getCategories() {
        return this.categories;
    }

    @Generated
    public String getTimeRangeId() {
        return this.timeRangeId;
    }

    @Generated
    public Boolean getExistKeyword() {
        return this.existKeyword;
    }

    @Generated
    public Boolean getExistCategory() {
        return this.existCategory;
    }

    @Generated
    public Boolean getExistTimeSchedule() {
        return this.existTimeSchedule;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setIndex(Integer index) {
        this.index = index;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setStatus(Boolean status) {
        this.status = status;
    }

    @Generated
    public void setPolicy(Integer policy) {
        this.policy = policy;
    }

    @Generated
    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    @Generated
    public void setSourceIds(List<String> sourceIds) {
        this.sourceIds = sourceIds;
    }

    @Generated
    public void setMode(Integer mode) {
        this.mode = mode;
    }

    @Generated
    public void setUrls(List<String> urls) {
        this.urls = urls;
    }

    @Generated
    public void setKeywords(List<String> keywords) {
        this.keywords = keywords;
    }

    @Generated
    public void setFilterMode(Integer filterMode) {
        this.filterMode = filterMode;
    }

    @Generated
    public void setScenarioMode(Integer scenarioMode) {
        this.scenarioMode = scenarioMode;
    }

    @Generated
    public void setCategories(TreeMap<String, List<String>> categories) {
        this.categories = categories;
    }

    @Generated
    public void setTimeRangeId(String timeRangeId) {
        this.timeRangeId = timeRangeId;
    }

    @Generated
    public void setExistKeyword(Boolean existKeyword) {
        this.existKeyword = existKeyword;
    }

    @Generated
    public void setExistCategory(Boolean existCategory) {
        this.existCategory = existCategory;
    }

    @Generated
    public void setExistTimeSchedule(Boolean existTimeSchedule) {
        this.existTimeSchedule = existTimeSchedule;
    }

    @Generated
    public String toString() {
        return "QueryUrlFilteringOpenApiVO(id=" + this.getId() + ", index=" + this.getIndex() + ", type=" + this.getType() + ", name=" + this.getName() + ", status=" + this.getStatus() + ", policy=" + this.getPolicy() + ", sourceType=" + this.getSourceType() + ", sourceIds=" + this.getSourceIds() + ", mode=" + this.getMode() + ", urls=" + this.getUrls() + ", keywords=" + this.getKeywords() + ", filterMode=" + this.getFilterMode() + ", scenarioMode=" + this.getScenarioMode() + ", categories=" + this.getCategories() + ", timeRangeId=" + this.getTimeRangeId() + ", existKeyword=" + this.getExistKeyword() + ", existCategory=" + this.getExistCategory() + ", existTimeSchedule=" + this.getExistTimeSchedule() + ")";
    }

    @Generated
    public QueryUrlFilteringOpenApiVO(String id, Integer index, String type, String name, Boolean status, Integer policy, Integer sourceType, List<String> sourceIds, Integer mode, List<String> urls, List<String> keywords, Integer filterMode, Integer scenarioMode, TreeMap<String, List<String>> categories, String timeRangeId, Boolean existKeyword, Boolean existCategory, Boolean existTimeSchedule) {
        this.id = id;
        this.index = index;
        this.type = type;
        this.name = name;
        this.status = status;
        this.policy = policy;
        this.sourceType = sourceType;
        this.sourceIds = sourceIds;
        this.mode = mode;
        this.urls = urls;
        this.keywords = keywords;
        this.filterMode = filterMode;
        this.scenarioMode = scenarioMode;
        this.categories = categories;
        this.timeRangeId = timeRangeId;
        this.existKeyword = existKeyword;
        this.existCategory = existCategory;
        this.existTimeSchedule = existTimeSchedule;
    }

    @Generated
    public QueryUrlFilteringOpenApiVO() {
    }
}

