/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.security.macfiltering;

import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.security.macfiltering.OsgMacFilterAddressOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.firewall.dto.OsgMacFilterVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.hibernate.validator.constraints.Range;

@Schema(name="MacFiltering")
public class OsgMacFilteringOpenApiVO {
    @Schema(name="id", description="ID of the MAC filtering entity.")
    private String id;
    @Schema(name="name", description="Name of the MAC filtering entity.")
    @NotEmpty(message="Parameter [name] is null")
    private @NotEmpty(message="Parameter [name] is null") String name;
    @Schema(name="filterMode", description="Filter mode should be a value as follows: 0: allow; 1: deny.")
    @NotNull(message="Parameter [filterMode] is null")
    @Range(min=0L, max=1L, message="Value of filterMode should be between 0 and 1.")
    private @NotNull(message="Parameter [filterMode] is null") @Range(min=0L, max=1L, message="Value of filterMode should be between 0 and 1.") Integer filterMode;
    @Schema(name="type", description="Type should be a value as follows: 0: macAddresses; 1: macGroupIds.")
    @NotNull(message="Parameter [type] is null")
    @Range(min=0L, max=1L, message="Value of type should be between 0 and 1.")
    private @NotNull(message="Parameter [type] is null") @Range(min=0L, max=1L, message="Value of type should be between 0 and 1.") Integer type;
    @Schema(name="macAddresses", description="MAC addresses of the MAC filtering entity.")
    @a(a=false)
    @Valid
    private List<OsgMacFilterAddressOpenApiVO> macAddresses;
    @Schema(name="macGroupIds", description="MAC groups of the MAC filtering entity. MAC group can be created using 'Create a new group profile' interface, and MAC group ID can be obtained from 'Get group profile list' interface.")
    private List<String> macGroupIds;

    public static OsgMacFilteringOpenApiVO toOpenApiVO(OsgMacFilterVO vo) {
        if (vo == null) {
            return new OsgMacFilteringOpenApiVO();
        }
        OsgMacFilteringOpenApiVO osgMacFilteringOpenApiVO = new OsgMacFilteringOpenApiVO();
        osgMacFilteringOpenApiVO.setId(vo.getId());
        osgMacFilteringOpenApiVO.setName(vo.getName());
        osgMacFilteringOpenApiVO.setFilterMode(vo.getFilterMode());
        osgMacFilteringOpenApiVO.setType(vo.getType());
        osgMacFilteringOpenApiVO.setMacAddresses(vo.getMacAddresses().stream().map(OsgMacFilterAddressOpenApiVO::toOpenApiVO).collect(Collectors.toList()));
        osgMacFilteringOpenApiVO.setMacGroupIds(vo.getMacGroupIds());
        return osgMacFilteringOpenApiVO;
    }

    public static GridVO<OsgMacFilteringOpenApiVO> toOpenApiGridVO(@Nonnull GridVO<OsgMacFilterVO> gridVO) {
        GridVO openApiGridVO = new GridVO();
        openApiGridVO.setTotalRows(gridVO.getTotalRows());
        openApiGridVO.setCurrentPage(gridVO.getCurrentPage());
        openApiGridVO.setCurrentSize(gridVO.getCurrentSize());
        openApiGridVO.setData(gridVO.getData().stream().map(OsgMacFilteringOpenApiVO::toOpenApiVO).collect(Collectors.toList()));
        return openApiGridVO;
    }

    public static OsgMacFilterVO toVO(OsgMacFilteringOpenApiVO openApiVO) {
        OsgMacFilterVO vo = new OsgMacFilterVO();
        vo.setId(openApiVO.getId());
        vo.setName(openApiVO.getName());
        vo.setFilterMode(openApiVO.getFilterMode());
        vo.setType(openApiVO.getType());
        if (openApiVO.getType() == 0) {
            vo.setMacAddresses(openApiVO.getMacAddresses().stream().map(OsgMacFilterAddressOpenApiVO::toVO).collect(Collectors.toList()));
        } else {
            vo.setMacGroupIds(openApiVO.getMacGroupIds());
        }
        return vo;
    }

    public OperationResponse check() {
        if (Objects.equals(this.getType(), 0)) {
            if (CollectionUtils.isEmpty(this.getMacAddresses())) {
                return new OperationResponse(b.d, "You should config parameter [macAddresses] when [type] is 0.", null);
            }
        } else if (CollectionUtils.isEmpty(this.getMacGroupIds())) {
            return new OperationResponse(b.d, "You should config parameter [macGroupIds] when [type] is 1.", null);
        }
        return OperationResponse.SUCCESS;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getFilterMode() {
        return this.filterMode;
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public List<OsgMacFilterAddressOpenApiVO> getMacAddresses() {
        return this.macAddresses;
    }

    @Generated
    public List<String> getMacGroupIds() {
        return this.macGroupIds;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setFilterMode(Integer filterMode) {
        this.filterMode = filterMode;
    }

    @Generated
    public void setType(Integer type) {
        this.type = type;
    }

    @Generated
    public void setMacAddresses(List<OsgMacFilterAddressOpenApiVO> macAddresses) {
        this.macAddresses = macAddresses;
    }

    @Generated
    public void setMacGroupIds(List<String> macGroupIds) {
        this.macGroupIds = macGroupIds;
    }

    @Generated
    public String toString() {
        return "OsgMacFilteringOpenApiVO(id=" + this.getId() + ", name=" + this.getName() + ", filterMode=" + this.getFilterMode() + ", type=" + this.getType() + ", macAddresses=" + this.getMacAddresses() + ", macGroupIds=" + this.getMacGroupIds() + ")";
    }

    @Generated
    public OsgMacFilteringOpenApiVO(String id, String name, Integer filterMode, Integer type, List<OsgMacFilterAddressOpenApiVO> macAddresses, List<String> macGroupIds) {
        this.id = id;
        this.name = name;
        this.filterMode = filterMode;
        this.type = type;
        this.macAddresses = macAddresses;
        this.macGroupIds = macGroupIds;
    }

    @Generated
    public OsgMacFilteringOpenApiVO() {
    }
}

