/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.security.macfiltering;

import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.DirectionOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.firewall.dto.OsgMacFilterGlobalVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="MacFilteringGeneralSetting")
public class OsgMacFilterGeneralSettingOpenApiVO {
    @NotNull(message="Value of enable can not be null.")
    @Schema(name="enable", description="Enable of the MAC filtering general setting.")
    private @NotNull(message="Value of enable can not be null.") Boolean enable;
    @Schema(name="filterMode", description="Filter mode should be a value as follows: 0: allow; 1: deny.")
    @Range(min=0L, max=1L, message="Value of filterMode should be between 0 and 1.")
    private @Range(min=0L, max=1L, message="Value of filterMode should be between 0 and 1.") Integer filterMode;
    @Schema(name="direction", description="Direction of the MAC filtering general setting.")
    private DirectionOpenApiVO direction;

    public static OsgMacFilterGeneralSettingOpenApiVO toOpenApiVO(OsgMacFilterGlobalVO vo) {
        if (vo == null) {
            return OsgMacFilterGeneralSettingOpenApiVO.builder().build();
        }
        if (Boolean.FALSE.equals(vo.getEnable())) {
            return OsgMacFilterGeneralSettingOpenApiVO.builder().enable(vo.getEnable()).build();
        }
        return OsgMacFilterGeneralSettingOpenApiVO.builder().enable(vo.getEnable()).filterMode(vo.getFilterMode()).direction(DirectionOpenApiVO.buildByWebVO(vo.getDirection())).build();
    }

    public static OsgMacFilterGlobalVO toVO(OsgMacFilterGeneralSettingOpenApiVO openApiVO) {
        OsgMacFilterGlobalVO vo = new OsgMacFilterGlobalVO();
        vo.setEnable(openApiVO.getEnable());
        vo.setFilterMode(openApiVO.getFilterMode());
        vo.setDirection(DirectionOpenApiVO.toWebVO(openApiVO.getDirection()));
        return vo;
    }

    @Generated
    public static OsgMacFilterGeneralSettingOpenApiVOBuilder builder() {
        return new OsgMacFilterGeneralSettingOpenApiVOBuilder();
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public Integer getFilterMode() {
        return this.filterMode;
    }

    @Generated
    public DirectionOpenApiVO getDirection() {
        return this.direction;
    }

    @Generated
    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    @Generated
    public void setFilterMode(Integer filterMode) {
        this.filterMode = filterMode;
    }

    @Generated
    public void setDirection(DirectionOpenApiVO direction) {
        this.direction = direction;
    }

    @Generated
    public String toString() {
        return "OsgMacFilterGeneralSettingOpenApiVO(enable=" + this.getEnable() + ", filterMode=" + this.getFilterMode() + ", direction=" + this.getDirection() + ")";
    }

    @Generated
    public OsgMacFilterGeneralSettingOpenApiVO(Boolean enable, Integer filterMode, DirectionOpenApiVO direction) {
        this.enable = enable;
        this.filterMode = filterMode;
        this.direction = direction;
    }

    @Generated
    public OsgMacFilterGeneralSettingOpenApiVO() {
    }

    @Generated
    public static class OsgMacFilterGeneralSettingOpenApiVOBuilder {
        @Generated
        private Boolean enable;
        @Generated
        private Integer filterMode;
        @Generated
        private DirectionOpenApiVO direction;

        @Generated
        OsgMacFilterGeneralSettingOpenApiVOBuilder() {
        }

        @Generated
        public OsgMacFilterGeneralSettingOpenApiVOBuilder enable(Boolean enable) {
            this.enable = enable;
            return this;
        }

        @Generated
        public OsgMacFilterGeneralSettingOpenApiVOBuilder filterMode(Integer filterMode) {
            this.filterMode = filterMode;
            return this;
        }

        @Generated
        public OsgMacFilterGeneralSettingOpenApiVOBuilder direction(DirectionOpenApiVO direction) {
            this.direction = direction;
            return this;
        }

        @Generated
        public OsgMacFilterGeneralSettingOpenApiVO build() {
            return new OsgMacFilterGeneralSettingOpenApiVO(this.enable, this.filterMode, this.direction);
        }

        @Generated
        public String toString() {
            return "OsgMacFilterGeneralSettingOpenApiVO.OsgMacFilterGeneralSettingOpenApiVOBuilder(enable=" + this.enable + ", filterMode=" + this.filterMode + ", direction=" + this.direction + ")";
        }
    }
}

