/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.security.ipmacbinding;

import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.firewall.dto.IpMacBindingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="IPMacBinding")
public class IpMacBindingOpenApiVO {
    @Schema(name="id", description="ID of the IP MAC binding entity.", hidden=true)
    private String id;
    @Schema(name="description", description="Description should contain 1 to 64 characters.")
    @Pattern(regexp="^$|^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [description] should be 1 ~ 64 characters")
    private @Pattern(regexp="^$|^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [description] should be 1 ~ 64 characters") String description;
    @NotNull
    @Schema(name="mac", description="MAC of the IP MAC binding entity.")
    @Pattern(regexp="[A-Fa-f0-9]{1}[02468aceACE]{1}([-:][A-Fa-f0-9]{2}){5}", message="Parameter [mac] should be a valid MAC address.")
    @a
    private @NotNull @Pattern(regexp="[A-Fa-f0-9]{1}[02468aceACE]{1}([-:][A-Fa-f0-9]{2}){5}", message="Parameter [mac] should be a valid MAC address.") String mac;
    @NotNull
    @Schema(name="ip", description="IP of the IP MAC binding entity.")
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Parameter [ip] should be a valid IP address.")
    private @NotNull @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Parameter [ip] should be a valid IP address.") String ip;
    @NotNull
    @Schema(name="status", description="Status of the IP MAC binding entity.")
    private Boolean status;
    @NotNull
    @Schema(name="interfaceType", description="Interface type should be a value as follows: 0: WAN; 1: LAN interface.")
    @Range(min=0L, max=1L, message="Value of interfaceType is from 0 to 1.")
    private @NotNull @Range(min=0L, max=1L, message="Value of interfaceType is from 0 to 1.") Integer interfaceType;
    @NotNull
    @Schema(name="interfaceId", description="Interface ID. WAN port ID can be obtained from 'Get internet basic info' interface. LAN Network can be created using 'Create LAN network' interface, and LAN Network ID can be obtained from 'Get LAN network list' interface.")
    private String interfaceId;
    @Deprecated
    @Schema(name="exportToDhcpReservation", description="Whether to export to the DhcpReservation table. This subsection is deprecated.")
    private Boolean exportToDhcpReservation;
    @Deprecated
    @Schema(name="supportExport", description="Whether could export to the DhcpReservation table. This subsection is deprecated.")
    private Boolean supportExport;
    @Schema(name="enableExportToDhcpReservation", description="Whether to enable export to the DhcpReservation table.")
    private Boolean enableExportToDhcpReservation;

    public static IpMacBindingOpenApiVO toOpenApiVO(IpMacBindingVO vo) {
        if (vo == null) {
            return new IpMacBindingOpenApiVO();
        }
        IpMacBindingOpenApiVO ipMacBindingOpenApiVO = new IpMacBindingOpenApiVO();
        ipMacBindingOpenApiVO.setId(vo.getId());
        ipMacBindingOpenApiVO.setDescription(vo.getDescription());
        ipMacBindingOpenApiVO.setMac(vo.getMac());
        ipMacBindingOpenApiVO.setIp(vo.getIp());
        ipMacBindingOpenApiVO.setStatus(vo.getStatus());
        ipMacBindingOpenApiVO.setInterfaceType(vo.getInterfaceType());
        ipMacBindingOpenApiVO.setInterfaceId(vo.getInterfaceId());
        ipMacBindingOpenApiVO.setExportToDhcpReservation(vo.getExportToDhcpReservation());
        ipMacBindingOpenApiVO.setSupportExport(vo.getSupportExport());
        ipMacBindingOpenApiVO.setEnableExportToDhcpReservation(vo.getEnableExportToDhcpReservation());
        return ipMacBindingOpenApiVO;
    }

    public static GridVO<IpMacBindingOpenApiVO> toOpenApiGridVO(@Nonnull GridVO<IpMacBindingVO> gridVO) {
        GridVO openApiGridVO = new GridVO();
        openApiGridVO.setTotalRows(gridVO.getTotalRows());
        openApiGridVO.setCurrentPage(gridVO.getCurrentPage());
        openApiGridVO.setCurrentSize(gridVO.getCurrentSize());
        openApiGridVO.setData(gridVO.getData().stream().map(IpMacBindingOpenApiVO::toOpenApiVO).collect(Collectors.toList()));
        return openApiGridVO;
    }

    public static IpMacBindingVO toVO(IpMacBindingOpenApiVO openApiVO) {
        IpMacBindingVO vo = new IpMacBindingVO();
        vo.setId(openApiVO.getId());
        vo.setDescription(openApiVO.getDescription());
        vo.setMac(openApiVO.getMac());
        vo.setIp(openApiVO.getIp());
        vo.setStatus(openApiVO.getStatus());
        vo.setInterfaceType(openApiVO.getInterfaceType());
        vo.setInterfaceId(openApiVO.getInterfaceId());
        vo.setExportToDhcpReservation(openApiVO.getExportToDhcpReservation());
        vo.setEnableExportToDhcpReservation(openApiVO.getEnableExportToDhcpReservation());
        return vo;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getMac() {
        return this.mac;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public Integer getInterfaceType() {
        return this.interfaceType;
    }

    @Generated
    public String getInterfaceId() {
        return this.interfaceId;
    }

    @Deprecated
    @Generated
    public Boolean getExportToDhcpReservation() {
        return this.exportToDhcpReservation;
    }

    @Deprecated
    @Generated
    public Boolean getSupportExport() {
        return this.supportExport;
    }

    @Generated
    public Boolean getEnableExportToDhcpReservation() {
        return this.enableExportToDhcpReservation;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setMac(String mac) {
        this.mac = mac;
    }

    @Generated
    public void setIp(String ip) {
        this.ip = ip;
    }

    @Generated
    public void setStatus(Boolean status) {
        this.status = status;
    }

    @Generated
    public void setInterfaceType(Integer interfaceType) {
        this.interfaceType = interfaceType;
    }

    @Generated
    public void setInterfaceId(String interfaceId) {
        this.interfaceId = interfaceId;
    }

    @Deprecated
    @Generated
    public void setExportToDhcpReservation(Boolean exportToDhcpReservation) {
        this.exportToDhcpReservation = exportToDhcpReservation;
    }

    @Deprecated
    @Generated
    public void setSupportExport(Boolean supportExport) {
        this.supportExport = supportExport;
    }

    @Generated
    public void setEnableExportToDhcpReservation(Boolean enableExportToDhcpReservation) {
        this.enableExportToDhcpReservation = enableExportToDhcpReservation;
    }

    @Generated
    public String toString() {
        return "IpMacBindingOpenApiVO(id=" + this.getId() + ", description=" + this.getDescription() + ", mac=" + this.getMac() + ", ip=" + this.getIp() + ", status=" + this.getStatus() + ", interfaceType=" + this.getInterfaceType() + ", interfaceId=" + this.getInterfaceId() + ", exportToDhcpReservation=" + this.getExportToDhcpReservation() + ", supportExport=" + this.getSupportExport() + ", enableExportToDhcpReservation=" + this.getEnableExportToDhcpReservation() + ")";
    }

    @Generated
    public IpMacBindingOpenApiVO(String id, String description, String mac, String ip, Boolean status, Integer interfaceType, String interfaceId, Boolean exportToDhcpReservation, Boolean supportExport, Boolean enableExportToDhcpReservation) {
        this.id = id;
        this.description = description;
        this.mac = mac;
        this.ip = ip;
        this.status = status;
        this.interfaceType = interfaceType;
        this.interfaceId = interfaceId;
        this.exportToDhcpReservation = exportToDhcpReservation;
        this.supportExport = supportExport;
        this.enableExportToDhcpReservation = enableExportToDhcpReservation;
    }

    @Generated
    public IpMacBindingOpenApiVO() {
    }
}

